/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.common;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.api.service.common.TModelManager;
import org.ow2.dragon.api.to.common.CategoryTO;
import org.ow2.dragon.api.to.common.CategoryValueTO;
import org.ow2.dragon.api.to.common.IdentifierTO;
import org.ow2.dragon.persistence.bo.common.Category;
import org.ow2.dragon.persistence.bo.common.Identifier;
import org.ow2.dragon.persistence.dao.common.CategoryDAO;
import org.ow2.dragon.persistence.dao.common.CategoryValueDAO;
import org.ow2.dragon.persistence.dao.common.IdentifierDAO;
import org.ow2.dragon.service.TransfertObjectAssembler;
import org.springframework.stereotype.Service;

@Service(value="tModelManager")
public class TModelManagerImpl
implements TModelManager {
    @Resource
    private CategoryDAO categoryDAO;
    @Resource
    private IdentifierDAO identifierDAO;
    @Resource
    private CategoryValueDAO categoryValueDAO;
    @Resource
    private TransfertObjectAssembler transfertObjectAssembler;

    @Override
    @CheckAllArgumentsNotNull
    public List<CategoryValueTO> loadCategoryValues(String categoryId) {
        return this.transfertObjectAssembler.toCategoryValuesTO(this.categoryValueDAO.loadCategoryValues(categoryId));
    }

    @Override
    public List<CategoryTO> loadServiceCategories() {
        ArrayList<CategoryTO> result = new ArrayList<CategoryTO>();
        List<Category> categoryBOs = this.categoryDAO.loadServiceRelatedCategories();
        if (categoryBOs != null) {
            for (Category category : categoryBOs) {
                result.add(this.transfertObjectAssembler.toCategoryTO(category));
            }
        }
        return result;
    }

    @Override
    public List<CategoryTO> loadOrganizationCategories() {
        ArrayList<CategoryTO> result = new ArrayList<CategoryTO>();
        List<Category> categoryBOs = this.categoryDAO.loadOrganizationRelatedCategories();
        if (categoryBOs != null) {
            for (Category category : categoryBOs) {
                result.add(this.transfertObjectAssembler.toCategoryTO(category));
            }
        }
        return result;
    }

    @Override
    public List<IdentifierTO> loadOrganizationIdentifierSystems() {
        ArrayList<IdentifierTO> result = new ArrayList<IdentifierTO>();
        List<Identifier> identifierBOs = this.identifierDAO.loadOrganizationRelatedIdentifierSystems();
        if (identifierBOs != null) {
            for (Identifier identifier : identifierBOs) {
                result.add(this.transfertObjectAssembler.toIdentifierTO(identifier));
            }
        }
        return result;
    }

    @Override
    public List<CategoryTO> loadEndpointCategories() {
        ArrayList<CategoryTO> result = new ArrayList<CategoryTO>();
        List<Category> categoryBOs = this.categoryDAO.loadEndpointRelatedCategories();
        if (categoryBOs != null) {
            for (Category category : categoryBOs) {
                result.add(this.transfertObjectAssembler.toCategoryTO(category));
            }
        }
        return result;
    }
}

