/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.dataloader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import org.ow2.dragon.api.service.dataloader.DataLoaderException;
import org.ow2.dragon.dataset.Dataset;
import org.ow2.dragon.dataset.ObjectFactory;
import org.ow2.dragon.util.JAXBUtil;

public class DragonDatasetHandler {
    private static DragonDatasetHandler instance;
    private static Unmarshaller unmarshaller;
    private static Marshaller marshaller;
    private static final List<Class> defaultObjectFactories;

    private DragonDatasetHandler() throws DataLoaderException {
        try {
            JAXBContext context = JAXBUtil.createJAXBContext(defaultObjectFactories);
            unmarshaller = context.createUnmarshaller();
            marshaller = context.createMarshaller();
        }
        catch (JAXBException e) {
            throw new DataLoaderException(e);
        }
    }

    public Dataset convertStreamSource2DragonDataset(Source datasetStream) throws DataLoaderException {
        try {
            JAXBElement wsdlBinding = unmarshaller.unmarshal(datasetStream, Dataset.class);
            return (Dataset)wsdlBinding.getValue();
        }
        catch (JAXBException e) {
            throw new DataLoaderException("Failed to build Java bindings from dataset XML document", e);
        }
    }

    public static DragonDatasetHandler getInstance() throws DataLoaderException {
        if (instance == null) {
            instance = new DragonDatasetHandler();
        }
        return instance;
    }

    static {
        defaultObjectFactories = new ArrayList<Class>(Arrays.asList(ObjectFactory.class));
    }
}

