/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.deployment;

import com.ebmwebsourcing.webcommons.persistence.dao.util.RequestOptions;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import javax.annotation.Resource;
import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.aop.annotation.CheckArgumentsNotNull;
import org.ow2.dragon.api.service.deployment.DeploymentException;
import org.ow2.dragon.api.service.deployment.EndpointManager;
import org.ow2.dragon.api.service.metadata.MetadataService;
import org.ow2.dragon.api.service.wsdl.WSDLManager;
import org.ow2.dragon.api.service.wsdl.WSDLServiceException;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.common.KeyedRefTO;
import org.ow2.dragon.api.to.deployment.CommentTO;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.api.to.deployment.TechnicalServiceTO;
import org.ow2.dragon.persistence.bo.common.Category;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.CategoryValue;
import org.ow2.dragon.persistence.bo.common.Comment;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.common.Rating;
import org.ow2.dragon.persistence.bo.deployment.Binding;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.metadata.SimpleFile;
import org.ow2.dragon.persistence.bo.specification.ServiceInterface;
import org.ow2.dragon.persistence.bo.specification.ServiceSpecification;
import org.ow2.dragon.persistence.dao.common.CategoryDAO;
import org.ow2.dragon.persistence.dao.common.CategoryValueDAO;
import org.ow2.dragon.persistence.dao.common.CommentDAO;
import org.ow2.dragon.persistence.dao.common.KeyedReferenceDAO;
import org.ow2.dragon.persistence.dao.deployment.BindingDAO;
import org.ow2.dragon.persistence.dao.deployment.EndpointDAO;
import org.ow2.dragon.persistence.dao.deployment.TechnicalServiceDAO;
import org.ow2.dragon.persistence.dao.specification.ServiceInterfaceDAO;
import org.ow2.dragon.persistence.dao.specification.ServiceSpecificationDAO;
import org.ow2.dragon.service.TransfertObjectAssembler;
import org.ow2.dragon.service.wsdl.importreport.WsdlEntitiesImportReport;
import org.ow2.dragon.util.StringHelper;
import org.ow2.dragon.util.XMLUtil;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

@Service(value="endpointManager")
public class EndpointManagerImpl
implements EndpointManager {
    @Resource
    private EndpointDAO endpointDAO;
    @Resource
    private TechnicalServiceDAO technicalServiceDAO;
    @Resource
    private ServiceSpecificationDAO serviceSpecificationDAO;
    @Resource
    private ServiceInterfaceDAO serviceInterfaceDAO;
    @Resource
    private KeyedReferenceDAO keyedReferenceDAO;
    @Resource
    private CategoryDAO categoryDAO;
    @Resource
    private CategoryValueDAO categoryValueDAO;
    @Resource
    private BindingDAO bindingDAO;
    @Resource
    private TransfertObjectAssembler transfertObjectAssembler;
    @Resource
    private MetadataService metadataService;
    @Resource
    private WSDLManager wsdlManager;
    @Resource
    private CommentDAO commentDAO;

    @Override
    public List<EndpointTO> getAllEndpoints(RequestOptionsTO requestOptionsTO) throws DeploymentException {
        ArrayList<EndpointTO> result = new ArrayList<EndpointTO>();
        List endpoints = this.endpointDAO.getAll(this.transfertObjectAssembler.toEndpointRequestOptions(requestOptionsTO));
        this.toEndpointsTO(result, endpoints);
        return result;
    }

    @Override
    @CheckArgumentsNotNull
    public EndpointTO getEndpoint(String endpointId, String user) throws DeploymentException {
        Endpoint endpointBO = (Endpoint)this.endpointDAO.get((Serializable)((Object)endpointId));
        if (endpointBO == null) {
            throw new DeploymentException("No endpoint found matching the given id: " + endpointId);
        }
        EndpointTO endpointTO = this.toEndpointTO(endpointBO, user);
        return endpointTO;
    }

    @Override
    @CheckArgumentsNotNull
    public String createEndpoint(String epName, String epAddress, String servId) throws DeploymentException {
        this.validateEndpointBeforeCreation(epName, epAddress, servId);
        TechnicalService technicalService = (TechnicalService)((Object)this.technicalServiceDAO.get((Serializable)((Object)servId)));
        if (technicalService == null) {
            throw new DeploymentException("The specified service doesn't exist: " + servId);
        }
        Endpoint endpointBO = new Endpoint();
        endpointBO.setName(epName);
        endpointBO.setNetworkAddress(epAddress);
        technicalService.addEndpoint(endpointBO);
        this.endpointDAO.save(endpointBO);
        return endpointBO.getId();
    }

    private void validateEndpointBeforeCreation(String epName, String epAddress, String servId) throws DeploymentException {
        if (StringHelper.isNullOrEmpty((String)epName)) {
            throw new DeploymentException("Endpoint name must be specified.");
        }
        if (StringHelper.isNullOrEmpty((String)servId)) {
            throw new DeploymentException("Endpoint must have a parent Service with a specified id.");
        }
        Endpoint endpoint = this.endpointDAO.getByNameAndServiceId(servId, epName);
        if (endpoint != null) {
            throw new DeploymentException("Endpoint already created with the same name (" + epName + ") in the same service (" + servId + ")");
        }
    }

    private void validateEndpointBeforeUpdate(EndpointTO endpointTO) throws DeploymentException {
        String epName = endpointTO.getName();
        if (StringHelper.isNullOrEmpty((String)epName)) {
            throw new DeploymentException("Endpoint name must be specified.");
        }
        TechnicalServiceTO techService = endpointTO.getTechService();
        if (techService == null) {
            throw new DeploymentException("Endpoint must have a parent Service.");
        }
        String serviceId = techService.getId();
        if (StringHelper.isNullOrEmpty((String)serviceId)) {
            throw new DeploymentException("Endpoint must have a parent Service with a specified id.");
        }
        Endpoint endpoint = this.endpointDAO.getByNameAndServiceId(serviceId, epName);
        if (endpoint != null && !endpointTO.getId().equals(endpoint.getId())) {
            throw new DeploymentException("Endpoint already created with the same name (" + epName + ") in the same service (" + serviceId + ")");
        }
    }

    @Override
    @CheckArgumentsNotNull
    public List<EndpointTO> getEndpointsByBinding(String bindingId, RequestOptionsTO requestOptionsTO) throws DeploymentException {
        throw new RuntimeException("not implemented method");
    }

    @Override
    @CheckArgumentsNotNull
    public List<EndpointTO> getEndpointsByTechService(String techServiceId, RequestOptionsTO requestOptionsTO) {
        ArrayList<EndpointTO> result = new ArrayList<EndpointTO>();
        RequestOptions requestOptions = this.transfertObjectAssembler.toEndpointRequestOptions(requestOptionsTO);
        if (requestOptions != null) {
            requestOptions.setCaseSensitive(true);
        }
        List endpoints = this.endpointDAO.searchEquals(new String[]{techServiceId}, new String[]{"technicalService.id"}, requestOptions);
        this.toEndpointsTO(result, endpoints);
        return result;
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removeEndpoint(String endpointId) throws DeploymentException {
        Endpoint endpoint = (Endpoint)this.endpointDAO.get((Serializable)((Object)endpointId));
        if (endpoint != null) {
            Set<ServiceSpecification> serviceSpecifications;
            Binding binding = endpoint.getBinding();
            if (binding != null) {
                Set<Endpoint> endpoints = binding.getEndpoints();
                endpoints.remove(endpoint);
                if (endpoints.size() == 0) {
                    this.removeBinding(binding);
                }
            }
            if ((serviceSpecifications = endpoint.getServiceSpecifications()) != null) {
                for (ServiceSpecification serviceSpecification : serviceSpecifications) {
                    serviceSpecification.getEndpoints().remove(endpoint);
                    if (serviceSpecification.getTechnicalServices() != null && !serviceSpecification.getTechnicalServices().isEmpty() || serviceSpecification.getEndpoints().size() != 0) continue;
                    this.removeServiceSpec(serviceSpecification);
                }
            }
        } else {
            throw new DeploymentException("No endpoint found for the given id: " + endpointId);
        }
        this.deleteEndpoint(endpoint);
    }

    private void deleteEndpoint(Endpoint endpoint) {
        endpoint.getTechnicalService().getEndpoints().remove(endpoint);
        this.endpointDAO.remove(endpoint);
    }

    private void removeServiceSpec(ServiceSpecification serviceSpecification) {
        this.deleteOverviewDocs(serviceSpecification);
        this.serviceSpecificationDAO.remove((Object)serviceSpecification);
    }

    private void deleteOverviewDocs(ServiceSpecification serviceSpecification) {
        List<SimpleFile> overviewDocs = serviceSpecification.getOverviewDocs();
        if (overviewDocs != null) {
            for (SimpleFile simpleFile : overviewDocs) {
                this.metadataService.deleteMetadata(simpleFile.getId());
            }
        }
    }

    private void removeBinding(Binding binding) {
        Set<ServiceSpecification> serviceSpecifications = binding.getServiceSpecifications();
        for (ServiceSpecification serviceSpecification : serviceSpecifications) {
            serviceSpecification.getBindings().remove((Object)binding);
        }
        this.bindingDAO.remove((Object)binding);
        ServiceInterface serviceInterface = binding.getServiceInterface();
        if (serviceInterface != null) {
            Set<Binding> bindings = serviceInterface.getBindings();
            bindings.remove((Object)binding);
            if (bindings.size() == 0) {
                this.removeInterface(serviceInterface);
            }
        }
    }

    private void removeInterface(ServiceInterface serviceInterface) {
        Set<ServiceSpecification> serviceSpecifications = serviceInterface.getServiceSpecs();
        for (ServiceSpecification serviceSpecification : serviceSpecifications) {
            serviceSpecification.getServiceInterfaces().remove((Object)serviceInterface);
        }
        this.serviceInterfaceDAO.remove((Object)serviceInterface);
    }

    private void toEndpointsTO(List<EndpointTO> result, Collection<Endpoint> endpoints) {
        if (endpoints != null && !endpoints.isEmpty()) {
            for (Endpoint endpoint : endpoints) {
                EndpointTO endpointTO = this.toEndpointTO(endpoint, null);
                endpointTO.setGlobalRating(this.updateGlobalRating(endpointTO.getId()));
                result.add(endpointTO);
            }
        }
    }

    private EndpointTO toEndpointTO(Endpoint endpoint, String user) {
        return this.transfertObjectAssembler.toEndpointTO(endpoint, user);
    }

    @Override
    @CheckAllArgumentsNotNull
    public String updateEndpoint(EndpointTO endpointTO) throws DeploymentException {
        Endpoint endpoint = (Endpoint)this.endpointDAO.get((Serializable)((Object)endpointTO.getId()));
        if (endpoint == null) {
            throw new DeploymentException("Your are trying to update a non existing Endpoint with id: " + endpointTO.getId());
        }
        this.validateEndpointBeforeUpdate(endpointTO);
        this.transfertObjectAssembler.toEndpointBO(endpointTO, endpoint);
        return ((Endpoint)this.endpointDAO.save(endpoint)).getId();
    }

    @Override
    public float updateGlobalRating(String endpointId) {
        Endpoint endpoint = (Endpoint)this.endpointDAO.get((Serializable)((Object)endpointId));
        float globalRating = 0.0f;
        if (!endpoint.getRatings().isEmpty()) {
            Iterator<Rating> iter = endpoint.getRatings().iterator();
            int size = endpoint.getRatings().size();
            while (iter.hasNext()) {
                globalRating += (float)iter.next().getMyRating();
            }
            globalRating /= (float)size;
        }
        return globalRating;
    }

    @Override
    public void updateComments(String endpointId, CommentTO comment) {
        Endpoint endpoint = (Endpoint)this.endpointDAO.get((Serializable)((Object)endpointId));
        if (endpoint != null) {
            Comment commentTemp = new Comment();
            commentTemp.setContent(comment.getContent());
            commentTemp.setDate(comment.getDate());
            commentTemp.setUserName(comment.getUserName());
            commentTemp.setId(comment.getId());
            endpoint.addComment(commentTemp);
        }
    }

    @Override
    public List<EndpointTO> getEndpointsByTag(String tag) {
        ArrayList<EndpointTO> result = new ArrayList<EndpointTO>();
        List allEndpoints = this.endpointDAO.getAll();
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        for (Endpoint endpointTemp : allEndpoints) {
            if (!endpointTemp.isTagged(tag)) continue;
            endpoints.add(endpointTemp);
        }
        this.toEndpointsTO(result, endpoints);
        return result;
    }

    @Override
    public void removeTag(String tag, String endpointId) {
        Endpoint endpoint = (Endpoint)this.endpointDAO.get((Serializable)((Object)endpointId));
        Set<String> tags = endpoint.getTags();
        tags.remove(tag);
        endpoint.setTags(tags);
    }

    @Override
    public void removeComment(String endpointId, String commentId) {
        Endpoint endpoint = (Endpoint)this.endpointDAO.get((Serializable)((Object)endpointId));
        Comment comment = (Comment)((Object)this.commentDAO.get((Serializable)((Object)commentId)));
        List<Comment> comments = endpoint.getComments();
        comments.remove((Object)comment);
        endpoint.setComments(comments);
    }

    @Override
    @CheckAllArgumentsNotNull
    public List<KeyedRefTO> getCategoriesForEndpoint(String endpointId) throws DeploymentException {
        Endpoint endpoint = (Endpoint)this.endpointDAO.get((Serializable)((Object)endpointId));
        if (endpoint == null) {
            throw new DeploymentException("No endpoint found for the given id: " + endpointId);
        }
        return this.transfertObjectAssembler.toCategoriesTO(endpoint.getCategoryBag());
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removeCategories(String endpointId, List<String> categoryIds) throws DeploymentException {
        Endpoint endpoint = (Endpoint)this.endpointDAO.get((Serializable)((Object)endpointId));
        if (endpoint == null) {
            throw new DeploymentException("No endpoint found for the given id: " + endpointId);
        }
        List keyRefs = this.keyedReferenceDAO.getAll(categoryIds);
        List<KeyedReference> keyedReferences = endpoint.getCategoryBag().getKeyedReferences();
        for (KeyedReference keyRef : keyRefs) {
            if (keyedReferences.contains((Object)keyRef)) continue;
            throw new DeploymentException("No category found for the given id: " + keyRef.getId());
        }
        keyedReferences.removeAll(keyRefs);
        this.keyedReferenceDAO.removeAll(keyRefs);
    }

    @Override
    @CheckAllArgumentsNotNull
    public void addCategory(String endpointId, String categoryId, String categoryValueId) throws DeploymentException {
        Endpoint endpoint = (Endpoint)this.endpointDAO.get((Serializable)((Object)endpointId));
        Category category = (Category)((Object)this.categoryDAO.get((Serializable)((Object)categoryId)));
        CategoryValue value = (CategoryValue)((Object)this.categoryValueDAO.get((Serializable)((Object)categoryValueId)));
        if (endpoint != null && category != null && value != null) {
            KeyedReference keyedReference = new KeyedReference();
            keyedReference.setTmodel(category);
            keyedReference.setKeyName(value.getDescription());
            keyedReference.setKeyValue(value.getValue());
            this.validateCategory(endpoint, keyedReference);
            CategoryBag categoryBag = endpoint.getCategoryBag();
            if (categoryBag != null) {
                categoryBag.addKeyedReference(keyedReference);
            } else {
                categoryBag = new CategoryBag();
                categoryBag.addKeyedReference(keyedReference);
                endpoint.setCategoryBag(categoryBag);
            }
        } else {
            throw new DeploymentException("You have specified unknown endpoint, category system or category value");
        }
        this.endpointDAO.save(endpoint);
    }

    private void validateCategory(Endpoint endpoint, KeyedReference keyedReference) throws DeploymentException {
        List<KeyedReference> keyedReferences;
        CategoryBag categoryBag = endpoint.getCategoryBag();
        if (categoryBag != null && (keyedReferences = categoryBag.getKeyedReferences()) != null && keyedReferences.contains((Object)keyedReference)) {
            throw new DeploymentException("Category already added to this endpoint.");
        }
    }

    @Override
    @CheckArgumentsNotNull
    public void addCategory(String endpointId, String categoryId, String categoryValue, String categoryDesc) throws DeploymentException {
        Endpoint endpoint = (Endpoint)this.endpointDAO.get((Serializable)((Object)endpointId));
        Category category = (Category)((Object)this.categoryDAO.get((Serializable)((Object)categoryId)));
        if (endpoint != null && category != null && !StringHelper.isNullOrEmpty((String)categoryValue)) {
            KeyedReference keyedReference = new KeyedReference();
            keyedReference.setTmodel(category);
            keyedReference.setKeyName(categoryDesc);
            keyedReference.setKeyValue(categoryValue);
            this.validateCategory(endpoint, keyedReference);
            CategoryBag categoryBag = endpoint.getCategoryBag();
            if (categoryBag != null) {
                categoryBag.addKeyedReference(keyedReference);
            } else {
                categoryBag = new CategoryBag();
                categoryBag.addKeyedReference(keyedReference);
                endpoint.setCategoryBag(categoryBag);
            }
        } else {
            throw new DeploymentException("You have specified unknown endpoint, category system or category value");
        }
        this.endpointDAO.save(endpoint);
    }

    private String addServiceDefFile(InputSource wsdlSource, Map<String, InputSource> imports, String wsdlFileName, String endpointId, boolean storeEntities) throws DeploymentException, TimeoutException {
        WsdlEntitiesImportReport registeredWsdlEntities;
        try {
            registeredWsdlEntities = this.wsdlManager.registerServiceDefFile(wsdlSource, imports, wsdlFileName, storeEntities, false);
        }
        catch (WSDLServiceException e) {
            throw new DeploymentException("Can't register the given wsdl file", e);
        }
        ServiceSpecification serviceSpecification = (ServiceSpecification)((Object)this.serviceSpecificationDAO.get((Serializable)((Object)registeredWsdlEntities.getServiceSpecId())));
        Endpoint endpoint = (Endpoint)this.endpointDAO.get((Serializable)((Object)endpointId));
        serviceSpecification.addEndpoint(endpoint);
        this.serviceSpecificationDAO.save((Object)serviceSpecification);
        return serviceSpecification.getId();
    }

    @Override
    @CheckArgumentsNotNull
    public String addServiceDefFile(URI wsdlURI, String wsdlFileName, String endpointId, boolean storeEntities) throws DeploymentException, TimeoutException {
        InputSource inputSource;
        try {
            inputSource = XMLUtil.createWsdlSource((URI)wsdlURI);
        }
        catch (Exception e) {
            throw new DeploymentException("Can't read wsdl file", e);
        }
        return this.addServiceDefFile(inputSource, null, wsdlFileName, endpointId, storeEntities);
    }

    @Override
    @CheckArgumentsNotNull
    public String addServiceDefFile(Document wsdlDoc, String wsdlFileName, String endpointId, boolean storeEntities) throws DeploymentException, TimeoutException {
        InputSource wsdlSource;
        try {
            wsdlSource = XMLUtil.createWsdlSource((Document)wsdlDoc);
        }
        catch (Exception e) {
            throw new DeploymentException("Can't read wsdl file", e);
        }
        return this.addServiceDefFile(wsdlSource, null, wsdlFileName, endpointId, storeEntities);
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removeServiceSpec(String endpointId, String serviceSpecificationId) throws DeploymentException {
        ServiceSpecification serviceSpecification = (ServiceSpecification)((Object)this.serviceSpecificationDAO.get((Serializable)((Object)serviceSpecificationId)));
        if (serviceSpecification == null) {
            throw new DeploymentException("You're trying to remove a non registered service description");
        }
        Endpoint endpoint = (Endpoint)this.endpointDAO.get((Serializable)((Object)endpointId));
        if (endpoint == null) {
            throw new DeploymentException("You're trying to remove a service description from a non registered endpoint");
        }
        serviceSpecification.removeEndpoint(endpoint);
        if (serviceSpecification.getTechnicalServices().size() == 0 && serviceSpecification.getEndpoints().size() == 0) {
            this.removeServiceSpec(serviceSpecification);
        }
    }
}

