/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.deployment;

import com.ebmwebsourcing.webcommons.persistence.dao.DAOLayerException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import javax.annotation.Resource;
import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.aop.annotation.CheckArgumentsNotNull;
import org.ow2.dragon.api.service.deployment.DeploymentException;
import org.ow2.dragon.api.service.deployment.EndpointManager;
import org.ow2.dragon.api.service.deployment.TechServiceManager;
import org.ow2.dragon.api.service.lifecycle.LifecycleException;
import org.ow2.dragon.api.service.lifecycle.LifecycleServiceManager;
import org.ow2.dragon.api.service.metadata.MetadataService;
import org.ow2.dragon.api.service.metadata.MetadataServiceException;
import org.ow2.dragon.api.service.wsdl.WSDLManager;
import org.ow2.dragon.api.service.wsdl.WSDLServiceException;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.common.KeyedRefTO;
import org.ow2.dragon.api.to.deployment.CommentTO;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.api.to.deployment.ServiceSearchProperties;
import org.ow2.dragon.api.to.deployment.TechnicalServiceTO;
import org.ow2.dragon.api.to.metadata.SimpleFileTO;
import org.ow2.dragon.persistence.bo.common.Category;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.CategoryValue;
import org.ow2.dragon.persistence.bo.common.Comment;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.common.Rating;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.metadata.SimpleFile;
import org.ow2.dragon.persistence.bo.specification.ServiceSpecification;
import org.ow2.dragon.persistence.dao.common.CategoryDAO;
import org.ow2.dragon.persistence.dao.common.CategoryValueDAO;
import org.ow2.dragon.persistence.dao.common.CommentDAO;
import org.ow2.dragon.persistence.dao.common.KeyedReferenceDAO;
import org.ow2.dragon.persistence.dao.deployment.EndpointDAO;
import org.ow2.dragon.persistence.dao.deployment.TechnicalServiceDAO;
import org.ow2.dragon.persistence.dao.specification.ServiceSpecificationDAO;
import org.ow2.dragon.service.TransfertObjectAssembler;
import org.ow2.dragon.service.wsdl.importreport.WsdlEntitiesImportReport;
import org.ow2.dragon.util.SearchHelper;
import org.ow2.dragon.util.StringHelper;
import org.ow2.dragon.util.XMLUtil;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

@Service(value="techServiceManager")
public class TechServiceManagerImpl
implements TechServiceManager {
    @Resource
    private TechnicalServiceDAO technicalServiceDAO;
    @Resource
    private TransfertObjectAssembler transfertObjectAssembler;
    @Resource
    private MetadataService metadataService;
    @Resource
    private ServiceSpecificationDAO serviceSpecificationDAO;
    @Resource
    private EndpointDAO endpointDAO;
    @Resource
    private CategoryDAO categoryDAO;
    @Resource
    private CategoryValueDAO categoryValueDAO;
    @Resource
    private KeyedReferenceDAO keyedReferenceDAO;
    @Resource
    private EndpointManager endpointManager;
    @Resource
    private WSDLManager wsdlManager;
    @Resource
    private LifecycleServiceManager lifecycleServiceManager;
    @Resource
    private CommentDAO commentDAO;

    private String[] createSearchProperties(List<ServiceSearchProperties> searchedProperties) {
        ArrayList<String> propertiesList = new ArrayList<String>();
        if (searchedProperties != null && !searchedProperties.isEmpty()) {
            if (searchedProperties.contains((Object)ServiceSearchProperties.NAME)) {
                propertiesList.add("fullName");
            }
            if (searchedProperties.contains((Object)ServiceSearchProperties.CATEGORY)) {
                propertiesList.add("categoryBag.keyedReferences.keyValue");
                propertiesList.add("categoryBag.keyedReferences.keyName");
            }
            if (searchedProperties.contains((Object)ServiceSearchProperties.PURPOSE)) {
                propertiesList.add("descriptions.description");
            }
            if (searchedProperties.contains((Object)ServiceSearchProperties.OPERATIONS)) {
                propertiesList.add("endpoints.binding.serviceInterface.specifiedOps.name");
                propertiesList.add("endpoints.binding.serviceInterface.specifiedOps.purpose");
            }
            if (searchedProperties.contains((Object)ServiceSearchProperties.PROTOCOL)) {
                propertiesList.add("endpoints.binding.protocols.name.name");
                propertiesList.add("endpoints.binding.transports.name.name");
                propertiesList.add("endpoints.binding.protocols.descriptions.description");
                propertiesList.add("endpoints.binding.transports.descriptions.description");
            }
            if (searchedProperties.contains((Object)ServiceSearchProperties.ORGANIZATION)) {
                propertiesList.add("toLinks.type");
                propertiesList.add("toLinks.from.names.name");
            }
            if (searchedProperties.contains((Object)ServiceSearchProperties.RELATED_DOCS)) {
                propertiesList.add("relatedDocs.author");
                propertiesList.add("relatedDocs.title");
                propertiesList.add("relatedDocs.extractedContent");
            }
        } else {
            propertiesList.add("fullName");
            propertiesList.add("categoryBag.keyedReferences.keyValue");
            propertiesList.add("categoryBag.keyedReferences.keyName");
            propertiesList.add("descriptions.description");
            propertiesList.add("endpoints.binding.serviceInterface.specifiedOps.name");
            propertiesList.add("endpoints.binding.serviceInterface.specifiedOps.purpose");
            propertiesList.add("endpoints.binding.protocols.name.name");
            propertiesList.add("endpoints.binding.transports.name.name");
            propertiesList.add("endpoints.binding.protocols.descriptions.description");
            propertiesList.add("endpoints.binding.transports.descriptions.description");
            propertiesList.add("toLinks.type");
            propertiesList.add("toLinks.from.names.name");
            propertiesList.add("relatedDocs.author");
            propertiesList.add("relatedDocs.title");
            propertiesList.add("relatedDocs.extractedContent");
        }
        return propertiesList.toArray(new String[0]);
    }

    @Override
    @CheckAllArgumentsNotNull
    public String createTechService(TechnicalServiceTO techServiceTO) throws DeploymentException {
        this.validateServiceBeforeCreation(techServiceTO);
        TechnicalService technicalServiceBO = new TechnicalService();
        this.transfertObjectAssembler.toTechServiceBO(techServiceTO, technicalServiceBO);
        return ((TechnicalService)((Object)this.technicalServiceDAO.save((Object)technicalServiceBO))).getId();
    }

    private void validateServiceBeforeCreation(TechnicalServiceTO techServiceTO) throws DeploymentException {
        if (StringHelper.isNullOrEmpty((String)techServiceTO.getName())) {
            throw new DeploymentException("Service name must be specified.");
        }
        TechnicalService technicalService = this.technicalServiceDAO.getTechServiceByName(techServiceTO.getName());
        if (technicalService != null) {
            throw new DeploymentException("Service already created with the same name (" + techServiceTO.getName() + ")");
        }
    }

    private void validateServiceBeforeUpdate(TechnicalServiceTO techServiceTO) throws DeploymentException {
        if (StringHelper.isNullOrEmpty((String)techServiceTO.getName())) {
            throw new DeploymentException("Service name must be specified.");
        }
        TechnicalService technicalService = this.technicalServiceDAO.getTechServiceByName(techServiceTO.getName());
        if (technicalService != null && !techServiceTO.getId().equals(technicalService.getId())) {
            throw new DeploymentException("Service already created with the same name (" + techServiceTO.getName() + ")");
        }
    }

    @Override
    public List<TechnicalServiceTO> getAllTechServices(RequestOptionsTO requestOptionsTO) {
        ArrayList<TechnicalServiceTO> result = new ArrayList<TechnicalServiceTO>();
        List techServices = this.technicalServiceDAO.getAll(this.transfertObjectAssembler.toServiceRequestOptions(requestOptionsTO));
        this.toTechServicesTO(result, techServices);
        return result;
    }

    private void toTechServicesTO(List<TechnicalServiceTO> result, Collection<TechnicalService> techServices) {
        if (techServices != null && !techServices.isEmpty()) {
            for (TechnicalService techServ : techServices) {
                TechnicalServiceTO techTO = this.toTechServiceTO(techServ, null);
                techTO.setGlobalRating(this.updateGlobalRating(techTO.getId()));
                result.add(techTO);
            }
        }
    }

    private TechnicalServiceTO toTechServiceTO(TechnicalService techServ, String user) {
        return this.transfertObjectAssembler.toTechServiceTO(techServ, user);
    }

    @Override
    @CheckAllArgumentsNotNull
    public EndpointTO getEndpoint(String techServiceName, String endpointName) throws DeploymentException {
        Endpoint endpointBO = this.endpointDAO.getByNameAndServiceFullName(techServiceName, endpointName);
        if (endpointBO == null) {
            throw new DeploymentException("Can't retrieve the endpoint '" + endpointName + "' which is part of technical service '" + techServiceName + "'");
        }
        return this.toEndpointTO(endpointBO);
    }

    private EndpointTO toEndpointTO(Endpoint endpoint) {
        return this.transfertObjectAssembler.toEndpointTO(endpoint, null);
    }

    @Override
    @CheckArgumentsNotNull
    public TechnicalServiceTO getTechService(String techServiceId, String user) throws DeploymentException {
        TechnicalService technicalServiceBO = (TechnicalService)((Object)this.technicalServiceDAO.get((Serializable)((Object)techServiceId)));
        if (technicalServiceBO == null) {
            throw new DeploymentException("No tech service found for the given id: " + techServiceId);
        }
        TechnicalServiceTO techServiceTO = this.toTechServiceTO(technicalServiceBO, user);
        return techServiceTO;
    }

    @Override
    public List<TechnicalServiceTO> loadServicesFromWSDL(String[] servicesId, RequestOptionsTO requestOptionsTO) throws DeploymentException {
        ArrayList<TechnicalServiceTO> techServs = new ArrayList<TechnicalServiceTO>();
        if (servicesId != null) {
            for (String servId : servicesId) {
                TechnicalServiceTO serviceTO = this.getTechService(servId, null);
                if (serviceTO == null) continue;
                techServs.add(serviceTO);
            }
        }
        return techServs;
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removeTechService(String techServiceId) throws DeploymentException, LifecycleException {
        TechnicalService technicalService = (TechnicalService)((Object)this.technicalServiceDAO.get((Serializable)((Object)techServiceId)));
        if (technicalService != null) {
            Set<SimpleFile> relatedDocs;
            Set<ServiceSpecification> serviceSpecifications;
            ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
            endpoints.addAll(technicalService.getEndpoints());
            if (endpoints != null) {
                for (Endpoint endpoint : endpoints) {
                    this.endpointManager.removeEndpoint(endpoint.getId());
                }
            }
            if ((serviceSpecifications = technicalService.getServiceSpecifications()) != null) {
                for (ServiceSpecification serviceSpecification : serviceSpecifications) {
                    serviceSpecification.getTechnicalServices().remove((Object)technicalService);
                    if (serviceSpecification.getTechnicalServices().size() != 0) continue;
                    this.removeServiceSpec(serviceSpecification);
                }
            }
            if ((relatedDocs = technicalService.getRelatedDocs()) != null) {
                for (SimpleFile simpleFile : relatedDocs) {
                    this.metadataService.deleteMetadata(simpleFile.getId());
                }
            }
        } else {
            throw new DeploymentException("No tech service found fro the given id: " + techServiceId);
        }
        this.lifecycleServiceManager.deleteByTechServiceId(techServiceId);
        this.technicalServiceDAO.remove((Object)technicalService);
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removeServiceSpec(String serviceId, String serviceSpecificationId) throws DeploymentException {
        ServiceSpecification serviceSpecification = (ServiceSpecification)((Object)this.serviceSpecificationDAO.get((Serializable)((Object)serviceSpecificationId)));
        if (serviceSpecification == null) {
            throw new DeploymentException("You're trying to remove a non registered service description");
        }
        TechnicalService service = (TechnicalService)((Object)this.technicalServiceDAO.get((Serializable)((Object)serviceId)));
        if (service == null) {
            throw new DeploymentException("You're trying to remove a service description from a non registered service");
        }
        serviceSpecification.removeTechnicalService(service);
        if (serviceSpecification.getTechnicalServices().size() == 0 && serviceSpecification.getEndpoints().size() == 0) {
            this.removeServiceSpec(serviceSpecification);
        }
    }

    private void removeServiceSpec(ServiceSpecification serviceSpecification) {
        this.deleteOverviewDocs(serviceSpecification);
        this.serviceSpecificationDAO.remove((Object)serviceSpecification);
    }

    private void deleteOverviewDocs(ServiceSpecification serviceSpecification) {
        List<SimpleFile> overviewDocs = serviceSpecification.getOverviewDocs();
        if (overviewDocs != null) {
            for (SimpleFile simpleFile : overviewDocs) {
                this.metadataService.deleteMetadata(simpleFile.getId());
            }
        }
    }

    @Override
    @CheckArgumentsNotNull
    public List<TechnicalServiceTO> searchTechService(String searchCriteria, List<ServiceSearchProperties> searchedProperties, RequestOptionsTO options) throws DeploymentException {
        List techServices;
        ArrayList<TechnicalServiceTO> result = new ArrayList<TechnicalServiceTO>();
        String[] criteria = SearchHelper.splitSearchCriteria((String)searchCriteria);
        String[] properties = this.createSearchProperties(searchedProperties);
        try {
            techServices = this.technicalServiceDAO.searchLucene(criteria, properties, this.transfertObjectAssembler.toServiceRequestOptions(options));
        }
        catch (DAOLayerException e) {
            throw new DeploymentException("You must specified non empty search criteria and properties.", e);
        }
        this.toTechServicesTO(result, techServices);
        return result;
    }

    @Override
    @CheckAllArgumentsNotNull
    public String updateTechService(TechnicalServiceTO techServiceTO) throws DeploymentException {
        TechnicalService technicalService = (TechnicalService)((Object)this.technicalServiceDAO.get((Serializable)((Object)techServiceTO.getId())));
        if (technicalService == null) {
            throw new DeploymentException("Your are trying to update a non existing Technical Service with id: " + techServiceTO.getId());
        }
        this.validateServiceBeforeUpdate(techServiceTO);
        this.transfertObjectAssembler.toTechServiceBO(techServiceTO, technicalService);
        this.technicalServiceDAO.save((Object)technicalService);
        return technicalService.getId();
    }

    @Override
    public String getRelatedDocContentAsString(String relatedDocId) throws DeploymentException {
        String result = null;
        try {
            InputStream inputStream = this.metadataService.loadMetadataContentAsInputStream(relatedDocId);
            result = StringHelper.toString((InputStream)inputStream);
        }
        catch (MetadataServiceException e) {
            throw new DeploymentException("Can't load related doc content", e);
        }
        catch (IOException e) {
            throw new DeploymentException("Can't convert related doc content to String", e);
        }
        return result;
    }

    @Override
    @CheckAllArgumentsNotNull
    public InputStream getRelatedDocContent(String relatedDocId) throws DeploymentException {
        InputStream result = null;
        try {
            result = this.metadataService.loadMetadataContentAsInputStream(relatedDocId);
        }
        catch (MetadataServiceException e) {
            throw new DeploymentException("Can't load related doc content", e);
        }
        return result;
    }

    @Override
    public List<SimpleFileTO> getRelatedDocsForTechServ(String techServiceId) throws DeploymentException {
        ArrayList<SimpleFileTO> result = new ArrayList<SimpleFileTO>();
        TechnicalService technicalServiceBO = (TechnicalService)((Object)this.technicalServiceDAO.get((Serializable)((Object)techServiceId)));
        Set<SimpleFile> relatedDocs = technicalServiceBO.getRelatedDocs();
        for (SimpleFile simpleFile : relatedDocs) {
            result.add(this.transfertObjectAssembler.toSimpleFileTO(simpleFile));
        }
        return result;
    }

    private void addRelatedDocs(String serviceId, Set<SimpleFile> relatedDocs) throws DeploymentException {
        if (!relatedDocs.isEmpty()) {
            TechnicalService service = (TechnicalService)((Object)this.technicalServiceDAO.get((Serializable)((Object)serviceId)));
            if (service == null) {
                throw new DeploymentException("No tech service found for the given id : " + serviceId);
            }
            for (SimpleFile relatedDoc : relatedDocs) {
                service.addRelatedDoc(relatedDoc);
            }
            this.technicalServiceDAO.save((Object)service);
        }
    }

    @Override
    @CheckArgumentsNotNull
    public String registerRelatedDoc(String serviceId, String mimetype, byte[] docContent, String fileName) throws DeploymentException {
        SimpleFile doc = null;
        try {
            doc = this.metadataService.storeMetadataAndIndexContent(mimetype, docContent, fileName);
        }
        catch (MetadataServiceException e) {
            throw new DeploymentException("Can't store document in registry", e);
        }
        HashSet<SimpleFile> docs = new HashSet<SimpleFile>();
        docs.add(doc);
        this.addRelatedDocs(serviceId, docs);
        return doc.getId();
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removeRelatedDoc(String serviceId, String documentId) throws DeploymentException {
        TechnicalService technicalService = (TechnicalService)((Object)this.technicalServiceDAO.get((Serializable)((Object)serviceId)));
        SimpleFile simpleFile = this.metadataService.loadMetadata(documentId);
        if (technicalService == null || simpleFile == null) {
            throw new DeploymentException("Service (id:" + serviceId + ") or document (id:" + documentId + ") not found");
        }
        technicalService.getRelatedDocs().remove((Object)simpleFile);
        this.metadataService.deleteMetadata(documentId);
    }

    @Override
    @CheckAllArgumentsNotNull
    public void addEndpoint(String endpointId, String serviceId) throws DeploymentException {
        TechnicalService service = (TechnicalService)((Object)this.technicalServiceDAO.get((Serializable)((Object)serviceId)));
        if (service == null) {
            throw new DeploymentException("Service doesn't exist for id: " + serviceId);
        }
        Endpoint endpoint = (Endpoint)this.endpointDAO.get((Serializable)((Object)endpointId));
        if (endpoint == null) {
            throw new DeploymentException("Endpoint doesn't exist for id: " + endpointId);
        }
        Endpoint endpoint2 = this.endpointDAO.getByNameAndServiceId(serviceId, endpoint.getName());
        if (endpoint2 != null) {
            throw new DeploymentException("Endpoint with the same name already linked to the given service.");
        }
        service.addEndpoint(endpoint);
        this.technicalServiceDAO.save((Object)service);
    }

    @Override
    @CheckArgumentsNotNull
    public void addCategory(String techServiceId, String categoryId, String categoryValue, String categoryDesc) throws DeploymentException {
        TechnicalService service = (TechnicalService)((Object)this.technicalServiceDAO.get((Serializable)((Object)techServiceId)));
        Category category = (Category)((Object)this.categoryDAO.get((Serializable)((Object)categoryId)));
        if (service != null && category != null && !StringHelper.isNullOrEmpty((String)categoryValue)) {
            KeyedReference keyedReference = new KeyedReference();
            keyedReference.setTmodel(category);
            keyedReference.setKeyName(categoryDesc);
            keyedReference.setKeyValue(categoryValue);
            this.validateCategory(service, keyedReference);
            CategoryBag categoryBag = service.getCategoryBag();
            if (categoryBag != null) {
                categoryBag.addKeyedReference(keyedReference);
            } else {
                categoryBag = new CategoryBag();
                categoryBag.addKeyedReference(keyedReference);
                service.setCategoryBag(categoryBag);
            }
        } else {
            throw new DeploymentException("You have specified unknown service, category system or category value");
        }
        this.technicalServiceDAO.save((Object)service);
    }

    @Override
    @CheckAllArgumentsNotNull
    public void addCategory(String techServiceId, String categoryId, String categoryValueId) throws DeploymentException {
        TechnicalService service = (TechnicalService)((Object)this.technicalServiceDAO.get((Serializable)((Object)techServiceId)));
        Category category = (Category)((Object)this.categoryDAO.get((Serializable)((Object)categoryId)));
        CategoryValue value = (CategoryValue)((Object)this.categoryValueDAO.get((Serializable)((Object)categoryValueId)));
        if (service != null && category != null) {
            KeyedReference keyedReference = new KeyedReference();
            keyedReference.setTmodel(category);
            keyedReference.setKeyName(value.getDescription());
            keyedReference.setKeyValue(value.getValue());
            this.validateCategory(service, keyedReference);
            CategoryBag categoryBag = service.getCategoryBag();
            if (categoryBag != null) {
                categoryBag.addKeyedReference(keyedReference);
            } else {
                categoryBag = new CategoryBag();
                categoryBag.addKeyedReference(keyedReference);
                service.setCategoryBag(categoryBag);
            }
        } else {
            throw new DeploymentException("You have specified unknown service, category system or category value");
        }
        this.technicalServiceDAO.save((Object)service);
    }

    private void validateCategory(TechnicalService techServ, KeyedReference keyedReference) throws DeploymentException {
        List<KeyedReference> keyedReferences;
        CategoryBag categoryBag = techServ.getCategoryBag();
        if (categoryBag != null && (keyedReferences = categoryBag.getKeyedReferences()) != null && keyedReferences.contains((Object)keyedReference)) {
            throw new DeploymentException("Category already added to this service.");
        }
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removeCategories(String techServiceId, List<String> categoryIds) throws DeploymentException {
        TechnicalService service = (TechnicalService)((Object)this.technicalServiceDAO.get((Serializable)((Object)techServiceId)));
        if (service == null) {
            throw new DeploymentException("No service found for the given id: " + techServiceId);
        }
        List keyRefs = this.keyedReferenceDAO.getAll(categoryIds);
        List<KeyedReference> keyedReferences = service.getCategoryBag().getKeyedReferences();
        for (KeyedReference keyRef : keyRefs) {
            if (keyedReferences.contains((Object)keyRef)) continue;
            throw new DeploymentException("No category found for the given id: " + keyRef.getId());
        }
        keyedReferences.removeAll(keyRefs);
        this.keyedReferenceDAO.removeAll(keyRefs);
    }

    private String addServiceDefFile(InputSource wsdlSource, Map<String, InputSource> imports, String wsdlFileName, String techServiceId, boolean storeEntities) throws DeploymentException, TimeoutException {
        WsdlEntitiesImportReport registeredWsdlEntities;
        try {
            registeredWsdlEntities = this.wsdlManager.registerServiceDefFile(wsdlSource, imports, wsdlFileName, storeEntities, false);
        }
        catch (WSDLServiceException e) {
            throw new DeploymentException("Can't register the given wsdl file", e);
        }
        ServiceSpecification serviceSpecification = (ServiceSpecification)((Object)this.serviceSpecificationDAO.get((Serializable)((Object)registeredWsdlEntities.getServiceSpecId())));
        TechnicalService technicalService = (TechnicalService)((Object)this.technicalServiceDAO.get((Serializable)((Object)techServiceId)));
        serviceSpecification.addTechnicalService(technicalService);
        this.serviceSpecificationDAO.save((Object)serviceSpecification);
        return serviceSpecification.getId();
    }

    @Override
    @CheckArgumentsNotNull
    public String addServiceDefFile(URI wsdlURI, String wsdlFileName, String techServiceId, boolean storeEntities) throws DeploymentException, TimeoutException {
        InputSource inputSource;
        try {
            inputSource = XMLUtil.createWsdlSource((URI)wsdlURI);
        }
        catch (Exception e) {
            throw new DeploymentException("Can't read wsdl file", e);
        }
        return this.addServiceDefFile(inputSource, null, wsdlFileName, techServiceId, storeEntities);
    }

    @Override
    @CheckArgumentsNotNull
    public String addServiceDefFile(Document wsdlDoc, String wsdlFileName, String techServiceId, boolean storeEntities) throws DeploymentException, TimeoutException {
        InputSource wsdlSource;
        try {
            wsdlSource = XMLUtil.createWsdlSource((Document)wsdlDoc);
        }
        catch (Exception e) {
            throw new DeploymentException("Can't read wsdl file", e);
        }
        return this.addServiceDefFile(wsdlSource, null, wsdlFileName, techServiceId, storeEntities);
    }

    @Override
    public float updateGlobalRating(String serviceId) {
        TechnicalService technicalService = (TechnicalService)((Object)this.technicalServiceDAO.get((Serializable)((Object)serviceId)));
        float globalRating = 0.0f;
        if (!technicalService.getRatings().isEmpty()) {
            Iterator<Rating> iter = technicalService.getRatings().iterator();
            int size = technicalService.getRatings().size();
            while (iter.hasNext()) {
                globalRating += (float)iter.next().getMyRating();
            }
            globalRating /= (float)size;
        }
        return globalRating;
    }

    @Override
    public void updateComments(String serviceId, CommentTO comment) {
        TechnicalService technicalService = (TechnicalService)((Object)this.technicalServiceDAO.get((Serializable)((Object)serviceId)));
        if (technicalService != null) {
            Comment commentTemp = new Comment();
            commentTemp.setContent(comment.getContent());
            commentTemp.setDate(comment.getDate());
            commentTemp.setUserName(comment.getUserName());
            technicalService.addComment(commentTemp);
        }
    }

    @Override
    public List<TechnicalServiceTO> getTechServicesByTag(String tag) {
        ArrayList<TechnicalServiceTO> result = new ArrayList<TechnicalServiceTO>();
        List allTechServices = this.technicalServiceDAO.getAll();
        ArrayList<TechnicalService> techServices = new ArrayList<TechnicalService>();
        for (TechnicalService techServiceTemp : allTechServices) {
            if (!techServiceTemp.isTagged(tag)) continue;
            techServices.add(techServiceTemp);
        }
        this.toTechServicesTO(result, techServices);
        return result;
    }

    @Override
    public void removeTag(String tag, String serviceId) {
        TechnicalService techService = (TechnicalService)((Object)this.technicalServiceDAO.get((Serializable)((Object)serviceId)));
        Set<String> tags = techService.getTags();
        tags.remove(tag);
        techService.setTags(tags);
    }

    @Override
    public void removeComment(String serviceId, String commentId) {
        TechnicalService techService = (TechnicalService)((Object)this.technicalServiceDAO.get((Serializable)((Object)serviceId)));
        Comment comment = (Comment)((Object)this.commentDAO.get((Serializable)((Object)commentId)));
        List<Comment> comments = techService.getComments();
        comments.remove((Object)comment);
        techService.setComments(comments);
    }

    @Override
    @CheckAllArgumentsNotNull
    public List<KeyedRefTO> getCategoriesForTechServ(String techServiceId) throws DeploymentException {
        TechnicalService service = (TechnicalService)((Object)this.technicalServiceDAO.get((Serializable)((Object)techServiceId)));
        if (service == null) {
            throw new DeploymentException("No service found for the given id: " + techServiceId);
        }
        return this.transfertObjectAssembler.toCategoriesTO(service.getCategoryBag());
    }
}

