/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.lifecycle;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.api.service.lifecycle.LifecycleException;
import org.ow2.dragon.api.service.lifecycle.LifecycleManager;
import org.ow2.dragon.api.to.deployment.TechnicalServiceTO;
import org.ow2.dragon.api.to.lifecycle.LifecycleStepTO;
import org.ow2.dragon.api.to.lifecycle.LifecycleTO;
import org.ow2.dragon.api.to.lifecycle.LifecycleUnderStepTO;
import org.ow2.dragon.persistence.bo.lifecycle.Lifecycle;
import org.ow2.dragon.persistence.bo.lifecycle.LifecycleService;
import org.ow2.dragon.persistence.bo.lifecycle.LifecycleStep;
import org.ow2.dragon.persistence.bo.lifecycle.LifecycleUnderStep;
import org.ow2.dragon.persistence.dao.lifecycle.LifecycleDAO;
import org.ow2.dragon.persistence.dao.lifecycle.LifecycleServiceDAO;
import org.ow2.dragon.persistence.dao.lifecycle.LifecycleStepDAO;
import org.ow2.dragon.persistence.dao.lifecycle.LifecycleUnderStepDAO;
import org.ow2.dragon.service.lifecycle.LifecycleTransfertObjectAssembler;
import org.ow2.dragon.util.StringHelper;
import org.springframework.stereotype.Service;

@Service(value="lifecycleManager")
public class LifecycleManagerImpl
implements LifecycleManager {
    @Resource
    private LifecycleDAO lifecycleDAO;
    @Resource
    private LifecycleStepDAO lifecycleStepDAO;
    @Resource
    private LifecycleUnderStepDAO lifecycleUnderStepDAO;
    @Resource
    private LifecycleTransfertObjectAssembler lifecycleTransfertObjectAssembler;
    @Resource
    private LifecycleServiceDAO lifecycleServiceDAO;

    @Override
    public List<LifecycleTO> getAll() throws LifecycleException {
        List listLifecycle = this.lifecycleDAO.getAll();
        ArrayList<LifecycleTO> listLifecycleTO = new ArrayList<LifecycleTO>();
        this.lifecycleTransfertObjectAssembler.toAllLifecyclesTO(listLifecycleTO, listLifecycle);
        return listLifecycleTO;
    }

    @Override
    @CheckAllArgumentsNotNull
    public LifecycleTO getLifecycle(String id) throws LifecycleException {
        Lifecycle lifecycle = (Lifecycle)((Object)this.lifecycleDAO.get((Serializable)((Object)id)));
        if (lifecycle == null) {
            throw new LifecycleException("no life cycle whith this id in database ! ");
        }
        LifecycleTO lifecycleTO = new LifecycleTO();
        this.lifecycleTransfertObjectAssembler.toLifecycleTO(lifecycleTO, lifecycle);
        return lifecycleTO;
    }

    @Override
    public List<TechnicalServiceTO> getAllLinkedServices(String idLifecycle) {
        ArrayList<TechnicalServiceTO> allLinkedServices = new ArrayList<TechnicalServiceTO>();
        Lifecycle lifecycle = new Lifecycle();
        lifecycle.setId(idLifecycle);
        List<LifecycleService> lifecycleServices = this.lifecycleServiceDAO.getLifecycleByLifecycle(lifecycle);
        for (int i = 0; i < lifecycleServices.size(); ++i) {
            TechnicalServiceTO techService = new TechnicalServiceTO();
            techService.setId(lifecycleServices.get(i).getTechnicalService().getId());
            techService.setName(lifecycleServices.get(i).getTechnicalService().getFullName());
            allLinkedServices.add(techService);
        }
        return allLinkedServices;
    }

    @Override
    @CheckAllArgumentsNotNull
    public String saveOrUpdateLifecycle(LifecycleTO lifecycleTO) throws LifecycleException {
        Lifecycle lifecycle = new Lifecycle();
        String name = null;
        String id = lifecycleTO.getId();
        if (id != null) {
            lifecycle = (Lifecycle)((Object)this.lifecycleDAO.get((Serializable)((Object)id)));
            if (lifecycle == null) {
                throw new LifecycleException("no life cycle whith this id in database ! ");
            }
            name = lifecycle.getName();
        }
        this.validateBeforeSaving(lifecycleTO, name);
        this.lifecycleTransfertObjectAssembler.toLifecycleBO(lifecycleTO, lifecycle);
        id = ((Lifecycle)((Object)this.lifecycleDAO.save((Object)lifecycle))).getId();
        return id;
    }

    @Override
    @CheckAllArgumentsNotNull
    public void deleteLifecycle(String id) throws LifecycleException {
        Lifecycle lifecycle = (Lifecycle)((Object)this.lifecycleDAO.get((Serializable)((Object)id)));
        if (lifecycle == null) {
            throw new LifecycleException("no life cycle whith this id in database ! ");
        }
        List<LifecycleStep> listLS = this.lifecycleStepDAO.getAllByLifecycleId(lifecycle);
        for (LifecycleStep lS : listLS) {
            this.lifecycleStepDAO.remove((Object)lS);
        }
        this.lifecycleDAO.remove((Object)lifecycle);
    }

    @Override
    @CheckAllArgumentsNotNull
    public boolean canChangeLifecycle(String id) {
        Lifecycle lifecycle = new Lifecycle();
        lifecycle.setId(id);
        List<LifecycleService> lifecycleServices = this.lifecycleServiceDAO.getLifecycleByLifecycle(lifecycle);
        return lifecycleServices == null || lifecycleServices.isEmpty();
    }

    @Override
    @CheckAllArgumentsNotNull
    public LifecycleStepTO getStep(String id) throws LifecycleException {
        if (id == null) {
            throw new LifecycleException("no life cycle step whith this id in database ! ");
        }
        LifecycleStep lifecycleStep = (LifecycleStep)((Object)this.lifecycleStepDAO.get((Serializable)((Object)id)));
        if (lifecycleStep == null) {
            throw new LifecycleException("no life cycle step whith this id in database ! ");
        }
        LifecycleStepTO lifecycleStepTO = new LifecycleStepTO();
        this.lifecycleTransfertObjectAssembler.toLifecycleStepTO(lifecycleStepTO, lifecycleStep);
        return lifecycleStepTO;
    }

    @Override
    @CheckAllArgumentsNotNull
    public String saveOrUpadeLifecycleStep(LifecycleStepTO lifecycleStepTO) throws LifecycleException {
        LifecycleStep lifecycleStep = new LifecycleStep();
        String name = null;
        if (lifecycleStepTO.getId() != null) {
            lifecycleStep = (LifecycleStep)((Object)this.lifecycleStepDAO.get((Serializable)((Object)lifecycleStepTO.getId())));
            if (lifecycleStep == null) {
                throw new LifecycleException("No life cycle step in database with this id !");
            }
            name = lifecycleStep.getName();
        }
        this.validateStepBeforeSaving(lifecycleStepTO, name, lifecycleStepTO.getLifecycleTO());
        this.lifecycleTransfertObjectAssembler.toLifecycleStepBO(lifecycleStepTO, lifecycleStep);
        String id = ((LifecycleStep)((Object)this.lifecycleStepDAO.save((Object)lifecycleStep))).getId();
        return id;
    }

    @Override
    @CheckAllArgumentsNotNull
    public void deleteLifecycleStep(String id) throws LifecycleException {
        LifecycleStep lifecycleStep = (LifecycleStep)((Object)this.lifecycleStepDAO.get((Serializable)((Object)id)));
        if (lifecycleStep == null) {
            throw new LifecycleException("no life cycle whith this id in database ! ");
        }
        this.lifecycleStepDAO.remove((Object)lifecycleStep);
    }

    @Override
    @CheckAllArgumentsNotNull
    public LifecycleUnderStepTO getUnderStep(String idUnderStep) throws LifecycleException {
        LifecycleUnderStepTO underStepTO = new LifecycleUnderStepTO();
        LifecycleUnderStep underStepBO = (LifecycleUnderStep)((Object)this.lifecycleUnderStepDAO.get((Serializable)((Object)idUnderStep)));
        this.lifecycleTransfertObjectAssembler.toUnderStepTO(underStepTO, underStepBO);
        return underStepTO;
    }

    @Override
    @CheckAllArgumentsNotNull
    public void saveOrUpdateUnderStep(LifecycleUnderStepTO underStepTO) throws LifecycleException {
        LifecycleUnderStep underStepBO = new LifecycleUnderStep();
        String name = null;
        if (underStepTO.getId() != null) {
            underStepBO = (LifecycleUnderStep)((Object)this.lifecycleUnderStepDAO.get((Serializable)((Object)underStepTO.getId())));
            if (underStepBO == null) {
                throw new LifecycleException("No check point in database with this id !");
            }
            name = underStepBO.getName();
        }
        this.validateUnderStepBeforeSaving(underStepTO, name, underStepTO.getLifecycleStepTO());
        this.lifecycleTransfertObjectAssembler.toUnderStepBO(underStepTO, underStepBO);
        this.lifecycleUnderStepDAO.save((Object)underStepBO);
    }

    @Override
    @CheckAllArgumentsNotNull
    public void deleteUnderStep(String id) throws LifecycleException {
        LifecycleUnderStep underStepBO = (LifecycleUnderStep)((Object)this.lifecycleUnderStepDAO.get((Serializable)((Object)id)));
        if (underStepBO == null) {
            throw new LifecycleException("no checkpoint whith this id in database ! ");
        }
        this.lifecycleUnderStepDAO.remove((Object)underStepBO);
    }

    private void validateBeforeSaving(LifecycleTO lifecycleTO, String lifecycleName) throws LifecycleException {
        Lifecycle lifecycle;
        String lifecycleNameTO = lifecycleTO.getName();
        if (StringHelper.isNullOrEmpty((String)lifecycleNameTO)) {
            throw new LifecycleException("Life cycle name must be specified.");
        }
        if (!lifecycleNameTO.equalsIgnoreCase(lifecycleName) && (lifecycle = this.lifecycleDAO.getLifecycleByName(lifecycleNameTO)) != null) {
            throw new LifecycleException("A life cycle whit that name already exists.");
        }
    }

    private void validateStepBeforeSaving(LifecycleStepTO lifecycleStepTO, String lifecycleStepName, LifecycleTO lifecycleTO) throws LifecycleException {
        String lifecycleStepNameTO = lifecycleStepTO.getName();
        if (StringHelper.isNullOrEmpty((String)lifecycleStepNameTO)) {
            throw new LifecycleException("Life cycle step name must be specified.");
        }
        if (lifecycleTO != null && lifecycleTO.getId() != null) {
            LifecycleStep lifecycleStep;
            Lifecycle lifecycle = (Lifecycle)((Object)this.lifecycleDAO.get((Serializable)((Object)lifecycleTO.getId())));
            if (lifecycle == null) {
                throw new LifecycleException("A life cycle whit that id doesn't exist in database.");
            }
            if (!lifecycleStepNameTO.equalsIgnoreCase(lifecycleStepName) && (lifecycleStep = this.lifecycleStepDAO.getLifecycleByNameAndLifecycleId(lifecycleStepNameTO, lifecycle)) != null) {
                throw new LifecycleException("A life cycle step whit that name already exists.");
            }
        }
        if (lifecycleStepTO.getLifecycleTO() == null || lifecycleStepTO.getLifecycleTO().getId() == null) {
            throw new LifecycleException("The life cycle step haven't life cycle defined.");
        }
    }

    private void validateUnderStepBeforeSaving(LifecycleUnderStepTO lifecycleUnderStepTO, String lifecycleUnerStepName, LifecycleStepTO lifecycleStepTO) throws LifecycleException {
        String lifecycleUnderStepNameTO = lifecycleUnderStepTO.getName();
        if (StringHelper.isNullOrEmpty((String)lifecycleUnderStepNameTO)) {
            throw new LifecycleException("Life cycle step check point name must be specified.");
        }
        if (lifecycleStepTO != null && lifecycleStepTO.getId() != null) {
            LifecycleUnderStep lifecycleUnderStep;
            LifecycleStep lifecycleStep = (LifecycleStep)((Object)this.lifecycleStepDAO.get((Serializable)((Object)lifecycleStepTO.getId())));
            if (lifecycleStep == null) {
                throw new LifecycleException("A life cycle step with that id doesn't exist in database.");
            }
            if (!lifecycleUnderStepNameTO.equalsIgnoreCase(lifecycleUnerStepName) && (lifecycleUnderStep = this.lifecycleUnderStepDAO.getLifecycleUnderByNameAndLifecycleId(lifecycleUnderStepNameTO, lifecycleStep)) != null) {
                throw new LifecycleException("A check point with that name already exists.");
            }
        }
        if (lifecycleUnderStepTO.getLifecycleStepTO() == null || lifecycleUnderStepTO.getLifecycleStepTO().getId() == null) {
            throw new LifecycleException("The check point haven't life cycle step defined.");
        }
    }
}

