/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.lifecycle;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.api.service.administration.UserException;
import org.ow2.dragon.api.service.lifecycle.LifecycleException;
import org.ow2.dragon.api.service.lifecycle.LifecycleManager;
import org.ow2.dragon.api.service.lifecycle.LifecycleServiceManager;
import org.ow2.dragon.api.to.lifecycle.LifecycleServiceTO;
import org.ow2.dragon.api.to.lifecycle.LifecycleStepServiceTO;
import org.ow2.dragon.api.to.lifecycle.LifecycleStepTO;
import org.ow2.dragon.api.to.lifecycle.LifecycleTO;
import org.ow2.dragon.api.to.lifecycle.LifecycleUnderStepServiceTO;
import org.ow2.dragon.api.to.lifecycle.LifecycleUnderStepTO;
import org.ow2.dragon.persistence.bo.administration.User;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.lifecycle.Lifecycle;
import org.ow2.dragon.persistence.bo.lifecycle.LifecycleService;
import org.ow2.dragon.persistence.bo.lifecycle.LifecycleStep;
import org.ow2.dragon.persistence.bo.lifecycle.LifecycleStepService;
import org.ow2.dragon.persistence.bo.lifecycle.LifecycleUnderStepService;
import org.ow2.dragon.persistence.dao.administration.UserDAO;
import org.ow2.dragon.persistence.dao.deployment.TechnicalServiceDAO;
import org.ow2.dragon.persistence.dao.lifecycle.LifecycleDAO;
import org.ow2.dragon.persistence.dao.lifecycle.LifecycleServiceDAO;
import org.ow2.dragon.persistence.dao.lifecycle.LifecycleStepDAO;
import org.ow2.dragon.persistence.dao.lifecycle.LifecycleStepServiceDAO;
import org.ow2.dragon.persistence.dao.lifecycle.LifecycleUnderStepServiceDAO;
import org.ow2.dragon.service.lifecycle.LifecycleServiceTransfertObjectAssembler;
import org.springframework.stereotype.Service;

@Service(value="lifecycleServiceManager")
public class LifecycleServiceManagerImpl
implements LifecycleServiceManager {
    @Resource
    private LifecycleServiceDAO lifecycleServiceDAO;
    @Resource
    private LifecycleStepServiceDAO lifecycleStepServiceDAO;
    @Resource
    private LifecycleUnderStepServiceDAO lifecycleUnderStepServiceDAO;
    @Resource
    private LifecycleServiceTransfertObjectAssembler lifecycleServiceTransfertObjectAssembler;
    @Resource
    private LifecycleManager lifecycleManager;
    @Resource
    private UserDAO userDAO;
    @Resource
    private TechnicalServiceDAO technicalServiceDAO;
    @Resource
    private LifecycleDAO lifecycleDAO;
    @Resource
    private LifecycleStepDAO lifecycleStepDAO;

    @Override
    @CheckAllArgumentsNotNull
    public LifecycleServiceTO getLifecycleService(String id) throws LifecycleException {
        LifecycleService lifecycleService = (LifecycleService)((Object)this.lifecycleServiceDAO.get((Serializable)((Object)id)));
        if (lifecycleService == null) {
            throw new LifecycleException("no life cycle service with this id in database ! ");
        }
        LifecycleServiceTO lifecycleServiceTO = new LifecycleServiceTO();
        this.lifecycleServiceTransfertObjectAssembler.toLifecycleServiceTO(lifecycleServiceTO, lifecycleService);
        return lifecycleServiceTO;
    }

    @Override
    @CheckAllArgumentsNotNull
    public LifecycleServiceTO getLifecycleServiceByTechnicalService(String id) throws LifecycleException {
        TechnicalService techService = (TechnicalService)((Object)this.technicalServiceDAO.get((Serializable)((Object)id)));
        if (techService == null) {
            throw new LifecycleException("no technical service with this id in database ! ");
        }
        LifecycleService lifecycleService = this.lifecycleServiceDAO.getLifecycleByTechnicalService(techService);
        LifecycleServiceTO lifecycleServiceTO = new LifecycleServiceTO();
        if (lifecycleService != null) {
            this.lifecycleServiceTransfertObjectAssembler.toLifecycleServiceTO(lifecycleServiceTO, lifecycleService);
        }
        return lifecycleServiceTO;
    }

    @Override
    @CheckAllArgumentsNotNull
    public List<Object> getAllStepAndUnderStepService(LifecycleServiceTO lifecycleServiceTO) {
        ArrayList<Object> items = new ArrayList<Object>();
        if (lifecycleServiceTO.getListLifecycleStepService() != null && !lifecycleServiceTO.getListLifecycleStepService().isEmpty()) {
            for (LifecycleStepServiceTO stepService : lifecycleServiceTO.getListLifecycleStepService()) {
                items.add(stepService);
                if (stepService.getListUnderStepService() == null || stepService.getListUnderStepService().isEmpty()) continue;
                for (LifecycleUnderStepServiceTO underStepService : stepService.getListUnderStepService()) {
                    items.add(underStepService);
                }
            }
        }
        return items;
    }

    @Override
    @CheckAllArgumentsNotNull
    public String saveOrUpdateLifecycleService(LifecycleServiceTO lifecycleServiceTO) throws LifecycleException {
        LifecycleService lifecycleService = new LifecycleService();
        TechnicalService techService = new TechnicalService();
        Lifecycle lifecycle = new Lifecycle();
        this.validateTechServiceAndLifecycle(lifecycleServiceTO, lifecycleService, techService, lifecycle);
        techService.setId(lifecycleServiceTO.getTechnicalServiceTO().getId());
        lifecycle.setId(lifecycleServiceTO.getLifecycleTO().getId());
        lifecycleService = this.validateBeforSavingLifecycleService(lifecycleServiceTO, lifecycleService, techService);
        this.createLifecycleStepService(lifecycleServiceTO);
        this.lifecycleServiceTransfertObjectAssembler.toLifecycleServiceBO(lifecycleServiceTO, lifecycleService, techService, lifecycle);
        String id = ((LifecycleService)((Object)this.lifecycleServiceDAO.save((Object)lifecycleService))).getId();
        return id;
    }

    @Override
    @CheckAllArgumentsNotNull
    public void deleteLifecycleService(String id) throws LifecycleException {
        LifecycleService lifecycleService = (LifecycleService)((Object)this.lifecycleServiceDAO.get((Serializable)((Object)id)));
        if (lifecycleService == null) {
            throw new LifecycleException("no life cycle service with this id in database ! ");
        }
        this.lifecycleServiceDAO.remove((Object)lifecycleService);
    }

    @Override
    @CheckAllArgumentsNotNull
    public void deleteByTechServiceId(String idTechService) throws LifecycleException {
        TechnicalService techService = (TechnicalService)((Object)this.technicalServiceDAO.get((Serializable)((Object)idTechService)));
        if (techService == null) {
            throw new LifecycleException("no technical service with this id in database ! ");
        }
        LifecycleService lifecycleService = this.lifecycleServiceDAO.getLifecycleByTechnicalService(techService);
        this.lifecycleServiceDAO.remove((Object)lifecycleService);
    }

    @CheckAllArgumentsNotNull
    public void createLifecycleStepService(LifecycleServiceTO lifecycleService) throws LifecycleException {
        LifecycleTO lifecycle;
        if (lifecycleService.getListLifecycleStepService() != null && !lifecycleService.getListLifecycleStepService().isEmpty()) {
            lifecycleService.getListLifecycleStepService().clear();
        }
        if ((lifecycle = this.lifecycleManager.getLifecycle(lifecycleService.getLifecycleTO().getId())) == null) {
            throw new LifecycleException("You must define a valid life cycle before creating life cycle service");
        }
        if (lifecycle.getListLifecycleStep() != null && !lifecycle.getListLifecycleStep().isEmpty()) {
            for (LifecycleStepTO stepTO : lifecycle.getListLifecycleStep()) {
                LifecycleStepServiceTO stepServiceTO = new LifecycleStepServiceTO();
                if (stepTO.getIdx() == 0) {
                    stepServiceTO.setStartDate(new Date().getTime());
                } else {
                    stepServiceTO.setStartDate(0L);
                }
                this.createGeneralStep(lifecycleService, stepTO, stepServiceTO);
            }
        }
    }

    private void createGeneralStep(LifecycleServiceTO lifecycleService, LifecycleStepTO stepTO, LifecycleStepServiceTO stepServiceTO) {
        stepServiceTO.setLifecycleStepTO(stepTO);
        stepServiceTO.setLifecycleServiceTO(lifecycleService);
        if (stepTO.getListLifecycleUnderStep() != null && !stepTO.getListLifecycleUnderStep().isEmpty()) {
            for (LifecycleUnderStepTO underStep : stepTO.getListLifecycleUnderStep()) {
                LifecycleUnderStepServiceTO underStepServiceTO = new LifecycleUnderStepServiceTO();
                underStepServiceTO.setLifecycleUnderStepTO(underStep);
                underStepServiceTO.setLifecycleStepServiceTO(stepServiceTO);
                stepServiceTO.addUnderStep(underStepServiceTO);
            }
        }
        lifecycleService.addStep(stepServiceTO);
    }

    @Override
    @CheckAllArgumentsNotNull
    public LifecycleStepServiceTO getStepService(String id) throws LifecycleException {
        LifecycleStepService lifecycleStep = (LifecycleStepService)((Object)this.lifecycleStepServiceDAO.get((Serializable)((Object)id)));
        if (lifecycleStep == null) {
            throw new LifecycleException("no life cycle step whith this id in database ! ");
        }
        LifecycleStepServiceTO lifecycleStepTO = new LifecycleStepServiceTO();
        this.lifecycleServiceTransfertObjectAssembler.toLifecycleStepServiceTO(lifecycleStepTO, lifecycleStep, null);
        return lifecycleStepTO;
    }

    @Override
    @CheckAllArgumentsNotNull
    public String saveOrUpadeLifecycleStepService(LifecycleStepServiceTO lifecycleStepServiceTO) throws LifecycleException {
        LifecycleStepService lifecycleStepService = new LifecycleStepService();
        if (lifecycleStepServiceTO.getId() != null && (lifecycleStepService = (LifecycleStepService)((Object)this.lifecycleStepServiceDAO.get((Serializable)((Object)lifecycleStepServiceTO.getId())))) == null) {
            throw new LifecycleException("No life cycle step in database with this id !");
        }
        LifecycleStep lifecycleStep = new LifecycleStep();
        this.validateBeforeSavingLifecycleStepService(lifecycleStepServiceTO, lifecycleStep);
        this.lifecycleServiceTransfertObjectAssembler.toLifecycleStepServiceBO(lifecycleStepServiceTO, lifecycleStepService, null, lifecycleStep);
        String id = ((LifecycleStepService)((Object)this.lifecycleStepServiceDAO.save((Object)lifecycleStepService))).getId();
        return id;
    }

    @Override
    @CheckAllArgumentsNotNull
    public void closeCurrentStepAndStartNextStep(LifecycleStepServiceTO lifecycleStepServiceTO, String login) throws LifecycleException, UserException {
        User user = this.userDAO.getUserByName(login);
        if (user == null) {
            throw new LifecycleException("No user with this name : " + login + " in database !");
        }
        LifecycleService lifecycleService = new LifecycleService();
        lifecycleService.setId(lifecycleStepServiceTO.getLifecycleServiceTO().getId());
        List<LifecycleStepService> listStepService = this.lifecycleStepServiceDAO.getAllByLifecycleService(lifecycleService);
        for (LifecycleStepService stepService : listStepService) {
            if (stepService.getLifecycleStep().getIdx() == lifecycleStepServiceTO.getLifecycleStepTO().getIdx() + 1) {
                stepService.setStartDate(new Date().getTime());
                this.lifecycleStepServiceDAO.save((Object)stepService);
            }
            if (!stepService.getId().equals(lifecycleStepServiceTO.getId())) continue;
            for (LifecycleUnderStepServiceTO underStepServiceTO : lifecycleStepServiceTO.getListUnderStepService()) {
                for (LifecycleUnderStepService underStepService : stepService.getListLifecycleUnderStepService()) {
                    if (!underStepService.getId().equals(underStepServiceTO.getId()) || underStepService.getEndDate() != 0L) continue;
                    underStepService.setEndDate(new Date().getTime());
                }
            }
            stepService.setEndDate(new Date().getTime());
            stepService.setPerson(user);
            this.lifecycleStepServiceDAO.save((Object)stepService);
        }
    }

    @Override
    @CheckAllArgumentsNotNull
    public void openCurrentStepAndCloseNextStep(LifecycleStepServiceTO lifecycleStepServiceTO) throws LifecycleException {
        LifecycleService lifecycleService = new LifecycleService();
        lifecycleService.setId(lifecycleStepServiceTO.getLifecycleServiceTO().getId());
        List<LifecycleStepService> listStepService = this.lifecycleStepServiceDAO.getAllByLifecycleService(lifecycleService);
        for (LifecycleStepService stepService : listStepService) {
            if (stepService.getLifecycleStep().getIdx() == lifecycleStepServiceTO.getLifecycleStepTO().getIdx() + 1) {
                stepService.setStartDate(0L);
                stepService.setEndDate(0L);
                for (LifecycleUnderStepService underStepService : stepService.getListLifecycleUnderStepService()) {
                    if (underStepService.getEndDate() == 0L) continue;
                    underStepService.setEndDate(0L);
                }
                this.lifecycleStepServiceDAO.save((Object)stepService);
            }
            if (!stepService.getId().equals(lifecycleStepServiceTO.getId())) continue;
            for (LifecycleUnderStepServiceTO underStepServiceTO : lifecycleStepServiceTO.getListUnderStepService()) {
                for (LifecycleUnderStepService underStepService : stepService.getListLifecycleUnderStepService()) {
                    if (!underStepService.getId().equals(underStepServiceTO.getId())) continue;
                    underStepService.setEndDate(underStepServiceTO.getEndDate());
                }
            }
            stepService.setPerson(null);
            stepService.setEndDate(0L);
            this.lifecycleStepServiceDAO.save((Object)stepService);
        }
    }

    @CheckAllArgumentsNotNull
    public void deleteLifecycleStepService(String id) throws LifecycleException {
        LifecycleStepService lifecycleStepService = (LifecycleStepService)((Object)this.lifecycleStepServiceDAO.get((Serializable)((Object)id)));
        if (lifecycleStepService == null) {
            throw new LifecycleException("no life cycle whith this id in database ! ");
        }
        this.lifecycleStepServiceDAO.remove((Object)lifecycleStepService);
    }

    @CheckAllArgumentsNotNull
    public void saveOrUpdateUnderStepService(LifecycleUnderStepServiceTO underStepServiceTO) throws LifecycleException {
        LifecycleUnderStepService underStepServiceBO = new LifecycleUnderStepService();
        if (underStepServiceTO.getId() != null && (underStepServiceBO = (LifecycleUnderStepService)((Object)this.lifecycleUnderStepServiceDAO.get((Serializable)((Object)underStepServiceTO.getId())))) == null) {
            throw new LifecycleException("No check point in database with this id !");
        }
        this.lifecycleServiceTransfertObjectAssembler.toUnderStepServiceBO(underStepServiceTO, underStepServiceBO, null);
        this.lifecycleUnderStepServiceDAO.save((Object)underStepServiceBO);
    }

    @CheckAllArgumentsNotNull
    public void deleteUnderStepService(String id) throws LifecycleException {
        LifecycleUnderStepService underStepServiceBO = (LifecycleUnderStepService)((Object)this.lifecycleUnderStepServiceDAO.get((Serializable)((Object)id)));
        if (underStepServiceBO == null) {
            throw new LifecycleException("no checkpoint whith this id in database ! ");
        }
        this.lifecycleUnderStepServiceDAO.remove((Object)underStepServiceBO);
    }

    @Override
    public void updateCheckUnderStep(List<String> underStepServiceId, List<LifecycleUnderStepServiceTO> listUnderStepService) {
        boolean isChecked = false;
        if (underStepServiceId != null && !underStepServiceId.isEmpty()) {
            for (LifecycleUnderStepServiceTO underStepService : listUnderStepService) {
                for (String idUnderStep : underStepServiceId) {
                    if (idUnderStep.equals(underStepService.getId()) && underStepService.getEndDate() == 0L) {
                        underStepService.setEndDate(new Date().getTime());
                    }
                    if (!idUnderStep.equals(underStepService.getId())) continue;
                    isChecked = true;
                }
                if (!isChecked && underStepService.getEndDate() != 0L) {
                    underStepService.setEndDate(0L);
                }
                isChecked = false;
            }
        } else {
            for (LifecycleUnderStepServiceTO underStepService : listUnderStepService) {
                if (underStepService.getEndDate() == 0L) continue;
                underStepService.setEndDate(0L);
            }
        }
    }

    private LifecycleService validateBeforSavingLifecycleService(LifecycleServiceTO lifecycleServiceTO, LifecycleService lifecycleService, TechnicalService techService) throws LifecycleException {
        LifecycleService tmp;
        String id = lifecycleServiceTO.getId();
        if (id != null) {
            lifecycleService = (LifecycleService)((Object)this.lifecycleServiceDAO.get((Serializable)((Object)id)));
            if (lifecycleService == null) {
                throw new LifecycleException("no life cycle whith this id in database ! ");
            }
            tmp = this.lifecycleServiceDAO.getLifecycleByTechnicalService(techService);
            if (tmp != null && !tmp.getId().equalsIgnoreCase(lifecycleService.getId())) {
                throw new LifecycleException("a lifecycle service is already associate with this technical service ! ");
            }
        } else {
            tmp = this.lifecycleServiceDAO.getLifecycleByTechnicalService(techService);
            if (tmp != null && tmp.getId() != null) {
                throw new LifecycleException("a lifecycle service is already associate with this technical service ! ");
            }
        }
        if (lifecycleService.getListLifecycleStepService() != null && !lifecycleService.getListLifecycleStepService().isEmpty()) {
            for (int i = 0; i < lifecycleService.getListLifecycleStepService().size(); ++i) {
                this.lifecycleStepDAO.remove((Serializable)((Object)lifecycleService.getListLifecycleStepService().get(i).getId()));
            }
            lifecycleService.getListLifecycleStepService().clear();
        }
        return lifecycleService;
    }

    private void validateTechServiceAndLifecycle(LifecycleServiceTO lifecycleServiceTO, LifecycleService lifecycleService, TechnicalService techService, Lifecycle lifecycle) throws LifecycleException {
        if (lifecycleServiceTO.getLifecycleTO() == null || lifecycleServiceTO.getLifecycleTO().getId() == null) {
            throw new LifecycleException("You must define a life cycle before creating lifecycle service");
        }
        if (lifecycleServiceTO.getTechnicalServiceTO() == null || lifecycleServiceTO.getTechnicalServiceTO().getId() == null) {
            throw new LifecycleException("You must define a technical service before creating life cycle service");
        }
        techService = (TechnicalService)((Object)this.technicalServiceDAO.get((Serializable)((Object)lifecycleServiceTO.getTechnicalServiceTO().getId())));
        if (techService == null) {
            throw new LifecycleException("You must define a valid technical service before creating lifecycle service");
        }
        lifecycle = (Lifecycle)((Object)this.lifecycleDAO.get((Serializable)((Object)lifecycleServiceTO.getLifecycleTO().getId())));
        if (lifecycle == null) {
            throw new LifecycleException("You must define a valid life cycle before creating life cycle service");
        }
    }

    private void validateBeforeSavingLifecycleStepService(LifecycleStepServiceTO lifecycleStepServiceTO, LifecycleStep lifecycleStep) throws LifecycleException {
        if (lifecycleStepServiceTO.getLifecycleStepTO() == null || lifecycleStepServiceTO.getLifecycleStepTO().getId() == null) {
            throw new LifecycleException("You must define a valid life cycle step before creating life cycle service");
        }
        lifecycleStep = (LifecycleStep)((Object)this.lifecycleStepDAO.get((Serializable)((Object)lifecycleStepServiceTO.getLifecycleStepTO().getId())));
        if (lifecycleStep == null) {
            throw new LifecycleException("You must define a valid life cycle step before creating life cycle service");
        }
    }
}

