/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.organization;

import com.ebmwebsourcing.webcommons.persistence.dao.DAOLayerException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.aop.annotation.CheckArgumentsNotNull;
import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.service.organization.OrganizationManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.SortCriteria;
import org.ow2.dragon.api.to.common.KeyedRefTO;
import org.ow2.dragon.api.to.organization.OrganizationSearchProperties;
import org.ow2.dragon.api.to.organization.OrganizationUnitTO;
import org.ow2.dragon.api.to.organization.PostTO;
import org.ow2.dragon.persistence.bo.common.Category;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.CategoryValue;
import org.ow2.dragon.persistence.bo.common.Identifier;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.bo.organization.Post;
import org.ow2.dragon.persistence.dao.common.CategoryDAO;
import org.ow2.dragon.persistence.dao.common.CategoryValueDAO;
import org.ow2.dragon.persistence.dao.common.IdentifierDAO;
import org.ow2.dragon.persistence.dao.common.KeyedReferenceDAO;
import org.ow2.dragon.persistence.dao.organization.OrganizationUnitDAO;
import org.ow2.dragon.persistence.dao.organization.PostDAO;
import org.ow2.dragon.service.TransfertObjectAssembler;
import org.ow2.dragon.util.SearchHelper;
import org.ow2.dragon.util.StringHelper;
import org.springframework.stereotype.Service;

@Service(value="organizationManager")
public class OrganizationManagerImpl
implements OrganizationManager {
    @Resource
    private TransfertObjectAssembler transfertObjectAssembler;
    @Resource
    private OrganizationUnitDAO organizationUnitDAO;
    @Resource
    private CategoryDAO categoryDAO;
    @Resource
    private CategoryValueDAO categoryValueDAO;
    @Resource
    private KeyedReferenceDAO keyedReferenceDAO;
    @Resource
    private IdentifierDAO identifierDAO;
    @Resource
    private PostDAO postDAO;

    @Override
    @CheckAllArgumentsNotNull
    public void addPost(String organizationId, String postId) throws OrganizationException {
        OrganizationUnit organizationUnit = (OrganizationUnit)((Object)this.organizationUnitDAO.get((Serializable)((Object)organizationId)));
        if (organizationUnit == null) {
            throw new OrganizationException("You are trying to add a post to a non existing org with id: " + organizationId);
        }
        Post post = (Post)((Object)this.postDAO.get((Serializable)((Object)postId)));
        if (post == null) {
            throw new OrganizationException("You are trying to add a non existing post to an org. Post id: " + postId);
        }
        organizationUnit.addPost(post);
        this.organizationUnitDAO.save((Object)organizationUnit);
    }

    @Override
    @CheckAllArgumentsNotNull
    public void addCategory(String orgId, String categoryId, String categoryValueId) throws OrganizationException {
        OrganizationUnit org = (OrganizationUnit)((Object)this.organizationUnitDAO.get((Serializable)((Object)orgId)));
        Category category = (Category)((Object)this.categoryDAO.get((Serializable)((Object)categoryId)));
        CategoryValue value = (CategoryValue)((Object)this.categoryValueDAO.get((Serializable)((Object)categoryValueId)));
        if (org != null && category != null && value != null) {
            KeyedReference keyedReference = new KeyedReference();
            keyedReference.setTmodel(category);
            keyedReference.setKeyName(value.getDescription());
            keyedReference.setKeyValue(value.getValue());
            this.validateCategory(org, keyedReference);
            CategoryBag categoryBag = org.getCategoryBag();
            if (categoryBag != null) {
                categoryBag.addKeyedReference(keyedReference);
            } else {
                categoryBag = new CategoryBag();
                categoryBag.addKeyedReference(keyedReference);
                org.setCategoryBag(categoryBag);
            }
        } else {
            throw new OrganizationException("You have specified unknown organization, category system or category value.");
        }
        this.organizationUnitDAO.save((Object)org);
    }

    private void validateCategory(OrganizationUnit org, KeyedReference keyedReference) throws OrganizationException {
        List<KeyedReference> keyedReferences;
        CategoryBag categoryBag = org.getCategoryBag();
        if (categoryBag != null && (keyedReferences = categoryBag.getKeyedReferences()) != null && keyedReferences.contains((Object)keyedReference)) {
            throw new OrganizationException("Category already added to this organization.");
        }
    }

    @Override
    @CheckArgumentsNotNull
    public void addIdentifier(String orgId, String identifierId, String identifierValue, String identifierDesc) throws OrganizationException {
        OrganizationUnit org = (OrganizationUnit)((Object)this.organizationUnitDAO.get((Serializable)((Object)orgId)));
        Identifier identifier = (Identifier)((Object)this.identifierDAO.get((Serializable)((Object)identifierId)));
        if (org != null && identifier != null && !StringHelper.isNullOrEmpty((String)identifierValue)) {
            KeyedReference keyedReference = new KeyedReference();
            keyedReference.setTmodel(identifier);
            keyedReference.setKeyName(identifierDesc);
            keyedReference.setKeyValue(identifierValue);
            this.validateIdentifier(org, keyedReference);
            List<KeyedReference> identifierBag = org.getIdentifierBag();
            if (identifierBag != null) {
                identifierBag.add(keyedReference);
            } else {
                identifierBag = new ArrayList<KeyedReference>();
                identifierBag.add(keyedReference);
                org.setIdentifierBag(identifierBag);
            }
        } else {
            throw new OrganizationException("You have specified unknown organization, identifier system or identifier value");
        }
        this.organizationUnitDAO.save((Object)org);
    }

    private void validateIdentifier(OrganizationUnit org, KeyedReference keyedReference) throws OrganizationException {
        List<KeyedReference> identifierBag = org.getIdentifierBag();
        if (identifierBag != null && identifierBag.contains((Object)keyedReference)) {
            throw new OrganizationException("Identifier already added to this organization.");
        }
    }

    @Override
    @CheckArgumentsNotNull
    public void addCategory(String orgId, String categoryId, String categoryValue, String categoryDesc) throws OrganizationException {
        OrganizationUnit org = (OrganizationUnit)((Object)this.organizationUnitDAO.get((Serializable)((Object)orgId)));
        Category category = (Category)((Object)this.categoryDAO.get((Serializable)((Object)categoryId)));
        if (org != null && category != null && !StringHelper.isNullOrEmpty((String)categoryValue)) {
            KeyedReference keyedReference = new KeyedReference();
            keyedReference.setTmodel(category);
            keyedReference.setKeyName(categoryDesc);
            keyedReference.setKeyValue(categoryValue);
            this.validateCategory(org, keyedReference);
            CategoryBag categoryBag = org.getCategoryBag();
            if (categoryBag != null) {
                categoryBag.addKeyedReference(keyedReference);
            } else {
                categoryBag = new CategoryBag();
                categoryBag.addKeyedReference(keyedReference);
                org.setCategoryBag(categoryBag);
            }
        } else {
            throw new OrganizationException("You have specified unknown organization, category system or category value");
        }
        this.organizationUnitDAO.save((Object)org);
    }

    @Override
    @CheckAllArgumentsNotNull
    public String createOrganization(OrganizationUnitTO organizationUnitTO) throws OrganizationException {
        this.validateOrganizationBeforeCreation(organizationUnitTO);
        OrganizationUnit organizationUnitBO = new OrganizationUnit();
        this.transfertObjectAssembler.toOrganizationUnitBO(organizationUnitTO, organizationUnitBO);
        return ((OrganizationUnit)((Object)this.organizationUnitDAO.save((Object)organizationUnitBO))).getId();
    }

    private void validateOrganizationBeforeCreation(OrganizationUnitTO organizationUnitTO) throws OrganizationException {
        if (StringHelper.isNullOrEmpty((String)organizationUnitTO.getName()) || StringHelper.isNullOrEmpty((String)organizationUnitTO.getCity())) {
            throw new OrganizationException("Organization Unit name and city must be specified.");
        }
        OrganizationUnit organizationUnit = this.organizationUnitDAO.getOrgUnitByNameAndCity(organizationUnitTO.getName(), organizationUnitTO.getCity());
        if (organizationUnit != null) {
            throw new OrganizationException("Organization Unit already created with the same name (" + organizationUnitTO.getName() + ") and city (" + organizationUnitTO.getCity() + ")");
        }
    }

    private String[] createSearchProperties(List<OrganizationSearchProperties> searchedProperties) {
        ArrayList<String> propertiesList = new ArrayList<String>();
        if (searchedProperties != null && !searchedProperties.isEmpty()) {
            if (searchedProperties.contains((Object)OrganizationSearchProperties.NAME)) {
                propertiesList.add("names.name");
            }
            if (searchedProperties.contains((Object)OrganizationSearchProperties.TYPE)) {
                propertiesList.add("type");
            }
            if (searchedProperties.contains((Object)OrganizationSearchProperties.LOCALIZATION)) {
                propertiesList.add("addresses.addressLines.addressLine");
            }
            if (searchedProperties.contains((Object)OrganizationSearchProperties.CATEGORY)) {
                propertiesList.add("categoryBag.keyedReferences.keyValue");
                propertiesList.add("categoryBag.keyedReferences.keyName");
            }
        } else {
            propertiesList.add("names.name");
            propertiesList.add("type");
            propertiesList.add("addresses.addressLines.addressLine");
            propertiesList.add("categoryBag.keyedReferences.keyValue");
            propertiesList.add("categoryBag.keyedReferences.keyName");
        }
        return propertiesList.toArray(new String[0]);
    }

    @Override
    public List<OrganizationUnitTO> getAllOrganizations(RequestOptionsTO requestOptionsTO) {
        ArrayList<OrganizationUnitTO> result = new ArrayList<OrganizationUnitTO>();
        List organizations = this.organizationUnitDAO.getAll(this.transfertObjectAssembler.toPartyRequestOptions(requestOptionsTO));
        this.toOrgUnitsTO(result, organizations);
        return result;
    }

    @Override
    @CheckAllArgumentsNotNull
    public OrganizationUnitTO getOrganization(String organizationId) throws OrganizationException {
        OrganizationUnit organizationUnitBO = (OrganizationUnit)((Object)this.organizationUnitDAO.get((Serializable)((Object)organizationId)));
        if (organizationUnitBO == null) {
            throw new OrganizationException("No organization found for the given id: " + organizationId);
        }
        OrganizationUnitTO organizationUnitTO = this.toOrgUnitTO(organizationUnitBO);
        return organizationUnitTO;
    }

    @Override
    @CheckAllArgumentsNotNull
    public List<OrganizationUnitTO> getAllOrgsWithoutMeAndMyChildren(String organizationId) throws OrganizationException {
        List<OrganizationUnit> organizations;
        ArrayList<OrganizationUnitTO> result = new ArrayList<OrganizationUnitTO>();
        try {
            organizations = this.organizationUnitDAO.getAllWithoutMeAndMyChildren(organizationId);
        }
        catch (DAOLayerException e) {
            throw new OrganizationException("No organization found for the given id: " + organizationId, e);
        }
        this.toOrgUnitsTO(result, organizations);
        return result;
    }

    @Override
    @CheckAllArgumentsNotNull
    public List<KeyedRefTO> getCategoriesForOrg(String orgId) throws OrganizationException {
        OrganizationUnit org = (OrganizationUnit)((Object)this.organizationUnitDAO.get((Serializable)((Object)orgId)));
        if (org == null) {
            throw new OrganizationException("No organization found for the given id: " + orgId);
        }
        return this.transfertObjectAssembler.toCategoriesTO(org.getCategoryBag());
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removeCategories(String orgId, List<String> categoryIds) throws OrganizationException {
        if (categoryIds != null) {
            OrganizationUnit org = (OrganizationUnit)((Object)this.organizationUnitDAO.get((Serializable)((Object)orgId)));
            if (org == null) {
                throw new OrganizationException("No organization found for the given id: " + orgId);
            }
            List keyRefs = this.keyedReferenceDAO.getAll(categoryIds);
            org.getCategoryBag().getKeyedReferences().removeAll(keyRefs);
            this.keyedReferenceDAO.removeAll(keyRefs);
        }
    }

    @Override
    @CheckAllArgumentsNotNull
    public List<KeyedRefTO> getIdentifiersForOrg(String orgId) throws OrganizationException {
        OrganizationUnit org = (OrganizationUnit)((Object)this.organizationUnitDAO.get((Serializable)((Object)orgId)));
        if (org == null) {
            throw new OrganizationException("No organization found for the given id: " + orgId);
        }
        return this.transfertObjectAssembler.toIdentifiersTO(org.getIdentifierBag());
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removeIdentifiers(String orgId, List<String> identifierIds) throws OrganizationException {
        if (identifierIds != null) {
            OrganizationUnit org = (OrganizationUnit)((Object)this.organizationUnitDAO.get((Serializable)((Object)orgId)));
            if (org == null) {
                throw new OrganizationException("No organization found for the given id: " + orgId);
            }
            List keyRefs = this.keyedReferenceDAO.getAll(identifierIds);
            org.getIdentifierBag().removeAll(keyRefs);
            this.keyedReferenceDAO.removeAll(keyRefs);
        }
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removeOrganization(String organizationId) {
        this.organizationUnitDAO.remove((Serializable)((Object)organizationId));
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removePost(String organizationId, String postId) throws OrganizationException {
        OrganizationUnit organizationUnit = (OrganizationUnit)((Object)this.organizationUnitDAO.get((Serializable)((Object)organizationId)));
        Post post = (Post)((Object)this.postDAO.get((Serializable)((Object)postId)));
        if (organizationUnit == null) {
            throw new OrganizationException("Organization doesn't exist for the given id: " + organizationId);
        }
        organizationUnit.removePost(post);
    }

    @Override
    @CheckArgumentsNotNull
    public List<OrganizationUnitTO> searchOrganization(String searchCriteria, List<OrganizationSearchProperties> searchedProperties, RequestOptionsTO requestOptionsTO) throws OrganizationException {
        List organizations;
        ArrayList<OrganizationUnitTO> result = new ArrayList<OrganizationUnitTO>();
        String[] criteria = SearchHelper.splitSearchCriteria((String)searchCriteria);
        String[] properties = this.createSearchProperties(searchedProperties);
        try {
            organizations = this.organizationUnitDAO.searchLucene(criteria, properties, this.transfertObjectAssembler.toPartyRequestOptions(requestOptionsTO));
        }
        catch (DAOLayerException e) {
            throw new OrganizationException("You must specified non empty search criteria and properties.", e);
        }
        this.toOrgUnitsTO(result, organizations);
        return result;
    }

    private void toOrgUnitsTO(List<OrganizationUnitTO> result, Collection<OrganizationUnit> organizations) {
        if (organizations != null && !organizations.isEmpty()) {
            for (OrganizationUnit organizationUnit : organizations) {
                result.add(this.toOrgUnitTO(organizationUnit));
            }
        }
    }

    private OrganizationUnitTO toOrgUnitTO(OrganizationUnit organizationUnit) {
        return this.transfertObjectAssembler.toOrganizationUnitTO(organizationUnit);
    }

    @Override
    @CheckArgumentsNotNull
    public List<PostTO> getPostsByOrganization(String orgId, RequestOptionsTO requestOptionsTO) throws OrganizationException {
        ArrayList<PostTO> result = new ArrayList<PostTO>();
        OrganizationUnit organizationUnit = (OrganizationUnit)((Object)this.organizationUnitDAO.get((Serializable)((Object)orgId)));
        if (organizationUnit == null) {
            throw new OrganizationException("No organization found for the given id: " + orgId);
        }
        Set<Post> posts = organizationUnit.getPosts();
        ArrayList<Post> postList = new ArrayList<Post>(posts);
        if (requestOptionsTO != null && requestOptionsTO.hasSortOption()) {
            final SortCriteria sortProp = requestOptionsTO.getSortCriteria();
            Collections.sort(postList, new Comparator<Post>(){

                @Override
                public int compare(Post o1, Post o2) {
                    int result = 0;
                    if (SortCriteria.POST_NAME.equals((Object)sortProp)) {
                        result = o1.getName().compareTo(o2.getName());
                    }
                    return result;
                }
            });
            if (!requestOptionsTO.isSortAscendingly()) {
                Collections.reverse(postList);
            }
        }
        this.toPostsTO(result, postList);
        return result;
    }

    private PostTO toPostTO(Post post) {
        return this.transfertObjectAssembler.toPostTO(post);
    }

    private void toPostsTO(List<PostTO> result, Collection<Post> posts) {
        if (posts != null && !posts.isEmpty()) {
            for (Post post : posts) {
                result.add(this.toPostTO(post));
            }
        }
    }

    @Override
    @CheckAllArgumentsNotNull
    public String updateOrganization(OrganizationUnitTO organizationUnitTO) throws OrganizationException {
        String orgId = organizationUnitTO.getId();
        if (orgId == null) {
            throw new NullPointerException("Organization to update must have an id.");
        }
        OrganizationUnit organizationUnit = (OrganizationUnit)((Object)this.organizationUnitDAO.get((Serializable)((Object)orgId)));
        if (organizationUnit == null) {
            throw new OrganizationException("Your are trying to update a non existing Organization with id: " + orgId);
        }
        this.validateOrganizationBeforeUpdate(organizationUnitTO);
        this.transfertObjectAssembler.toOrganizationUnitBO(organizationUnitTO, organizationUnit);
        this.organizationUnitDAO.save((Object)organizationUnit);
        return organizationUnit.getId();
    }

    private void validateOrganizationBeforeUpdate(OrganizationUnitTO organizationUnitTO) throws OrganizationException {
        if (StringHelper.isNullOrEmpty((String)organizationUnitTO.getName()) || StringHelper.isNullOrEmpty((String)organizationUnitTO.getCity())) {
            throw new OrganizationException("Organization Unit name and city must be specified.");
        }
        OrganizationUnit organizationUnit = this.organizationUnitDAO.getOrgUnitByNameAndCity(organizationUnitTO.getName(), organizationUnitTO.getCity());
        if (organizationUnit != null && !organizationUnit.getId().equals(organizationUnitTO.getId())) {
            throw new OrganizationException("Organization Unit already exists with the same name (" + organizationUnitTO.getName() + ") and city (" + organizationUnitTO.getCity() + ")");
        }
        if (organizationUnitTO.getMotherOrganization() != null && organizationUnitTO.getMotherOrganization().getId() != null) {
            List<OrganizationUnit> meAndMyChildren = this.organizationUnitDAO.getOrgAndChildren(organizationUnitTO.getId());
            ArrayList<String> meAndMyChildrenIds = new ArrayList<String>();
            for (OrganizationUnit organizationUnit2 : meAndMyChildren) {
                meAndMyChildrenIds.add(organizationUnit2.getId());
            }
            if (meAndMyChildrenIds.contains(organizationUnitTO.getMotherOrganization().getId())) {
                throw new OrganizationException("You are not allowed to choose you or one of your sub organization as mother organization");
            }
        }
    }
}

