/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.organization;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.service.organization.PartyManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.organization.PartyTO;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.bo.organization.Party;
import org.ow2.dragon.persistence.bo.organization.Person;
import org.ow2.dragon.persistence.dao.organization.PartyDAO;
import org.ow2.dragon.service.TransfertObjectAssembler;
import org.springframework.stereotype.Service;

@Service(value="partyManager")
public class PartyManagerImpl
implements PartyManager {
    @Resource
    private TransfertObjectAssembler transfertObjectAssembler;
    @Resource
    private PartyDAO partyDAO;

    @Override
    public List<PartyTO> getAllParties(RequestOptionsTO requestOptionsTO) {
        ArrayList<PartyTO> result = new ArrayList<PartyTO>();
        List parties = this.partyDAO.getAll(this.transfertObjectAssembler.toPartyRequestOptions(requestOptionsTO));
        if (parties != null && !parties.isEmpty()) {
            for (Party party : parties) {
                if (party instanceof OrganizationUnit) {
                    result.add(this.transfertObjectAssembler.toOrganizationUnitTO((OrganizationUnit)party));
                    continue;
                }
                if (!(party instanceof Person)) continue;
                result.add(this.transfertObjectAssembler.toPersonTO((Person)party));
            }
        }
        return result;
    }

    @Override
    @CheckAllArgumentsNotNull
    public PartyTO getParty(String partyId) throws OrganizationException {
        Party partyBO = (Party)((Object)this.partyDAO.get((Serializable)((Object)partyId)));
        if (partyBO == null) {
            throw new OrganizationException("No party found for the given id: " + partyId);
        }
        PartyTO partyTO = null;
        if (partyBO instanceof OrganizationUnit) {
            partyTO = this.transfertObjectAssembler.toOrganizationUnitTO((OrganizationUnit)partyBO);
        } else if (partyBO instanceof Person) {
            partyTO = this.transfertObjectAssembler.toPersonTO((Person)partyBO);
        }
        return partyTO;
    }

    public PartyDAO getPartyDAO() {
        return this.partyDAO;
    }
}

