/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.organization;

import com.ebmwebsourcing.webcommons.persistence.dao.DAOLayerException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.aop.annotation.CheckArgumentsNotNull;
import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.service.organization.PersonManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.organization.PersonSearchProperties;
import org.ow2.dragon.api.to.organization.PersonTO;
import org.ow2.dragon.persistence.bo.organization.Person;
import org.ow2.dragon.persistence.dao.organization.PersonDAO;
import org.ow2.dragon.service.TransfertObjectAssembler;
import org.ow2.dragon.util.SearchHelper;
import org.ow2.dragon.util.StringHelper;
import org.springframework.stereotype.Service;

@Service(value="personManager")
public class PersonManagerImpl
implements PersonManager {
    @Resource
    private TransfertObjectAssembler transfertObjectAssembler;
    @Resource
    private PersonDAO personDAO;

    @Override
    @CheckAllArgumentsNotNull
    public String createPerson(PersonTO personTO) throws OrganizationException {
        this.validatePersonBeforeCreation(personTO);
        Person personBO = new Person();
        this.transfertObjectAssembler.toPersonBO(personTO, personBO);
        return ((Person)((Object)this.personDAO.save((Object)personBO))).getId();
    }

    private void validatePersonBeforeCreation(PersonTO personTO) throws OrganizationException {
        if (StringHelper.isNullOrEmpty((String)personTO.getFirstname()) || StringHelper.isNullOrEmpty((String)personTO.getLastname()) || StringHelper.isNullOrEmpty((String)personTO.getEmail())) {
            throw new OrganizationException("Person firstname, lastname and email must be specified.");
        }
        Person person = this.personDAO.getPersonByFirstNameLastNameEmail(personTO.getFirstname(), personTO.getLastname(), personTO.getEmail());
        if (person != null) {
            throw new OrganizationException("A person with the same firstName, lastName and email address already exists.");
        }
    }

    private String[] createSearchProperties(List<PersonSearchProperties> searchedProperties) {
        ArrayList<String> propertiesList = new ArrayList<String>();
        if (searchedProperties != null && !searchedProperties.isEmpty()) {
            if (searchedProperties.contains((Object)PersonSearchProperties.NAME)) {
                propertiesList.add("firstName");
                propertiesList.add("lastName");
                propertiesList.add("middleName");
            }
            if (searchedProperties.contains((Object)PersonSearchProperties.PARENT_ORG)) {
                propertiesList.add("parentOrganization.names.name");
            }
            if (searchedProperties.contains((Object)PersonSearchProperties.POST)) {
                propertiesList.add("post.name");
                propertiesList.add("post.nature");
                propertiesList.add("post.description");
            }
        } else {
            propertiesList.add("firstName");
            propertiesList.add("lastName");
            propertiesList.add("middleName");
            propertiesList.add("parentOrganization.names.name");
            propertiesList.add("post.name");
            propertiesList.add("post.nature");
            propertiesList.add("post.description");
        }
        return propertiesList.toArray(new String[0]);
    }

    @Override
    public List<PersonTO> getAllPersons(RequestOptionsTO requestOptionsTO) {
        ArrayList<PersonTO> result = new ArrayList<PersonTO>();
        List persons = this.personDAO.getAll(this.transfertObjectAssembler.toPersonRequestOptions(requestOptionsTO));
        this.toPersonsTO(result, persons);
        return result;
    }

    @Override
    @CheckAllArgumentsNotNull
    public PersonTO getPerson(String personId) throws OrganizationException {
        Person personBO = (Person)((Object)this.personDAO.get((Serializable)((Object)personId)));
        if (personBO == null) {
            throw new OrganizationException("No person found for the given id: " + personId);
        }
        PersonTO personTO = this.toPersonTO(personBO);
        return personTO;
    }

    @Override
    public List<PersonTO> getPersonsByOrgAndPost(String organizationId, String postId, RequestOptionsTO optionsTO) {
        ArrayList<PersonTO> result = new ArrayList<PersonTO>();
        String[] criteria = new String[]{organizationId, postId};
        String[] properties = new String[]{"parentOrganization.id", "post.id"};
        List persons = this.personDAO.searchEquals(criteria, properties, this.transfertObjectAssembler.toPersonRequestOptions(optionsTO));
        this.toPersonsTO(result, persons);
        return result;
    }

    @Override
    public List<PersonTO> getPersonsByOrganization(String organizationId, RequestOptionsTO requestOptionsTO) throws OrganizationException {
        ArrayList<PersonTO> result = new ArrayList<PersonTO>();
        String[] criteria = new String[]{organizationId};
        String[] properties = new String[]{"parentOrganization.id"};
        List persons = this.personDAO.searchEquals(criteria, properties, this.transfertObjectAssembler.toPersonRequestOptions(requestOptionsTO));
        this.toPersonsTO(result, persons);
        return result;
    }

    @Override
    public List<PersonTO> getPersonsByPost(String postId, RequestOptionsTO requestOptionsTO) throws OrganizationException {
        ArrayList<PersonTO> result = new ArrayList<PersonTO>();
        String[] criteria = new String[]{postId};
        String[] properties = new String[]{"post.id"};
        List persons = this.personDAO.searchEquals(criteria, properties, this.transfertObjectAssembler.toPersonRequestOptions(requestOptionsTO));
        this.toPersonsTO(result, persons);
        return result;
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removePerson(String personId) {
        this.personDAO.remove((Serializable)((Object)personId));
    }

    @Override
    @CheckArgumentsNotNull
    public List<PersonTO> searchPersons(String searchCriteria, List<PersonSearchProperties> searchedProperties, RequestOptionsTO options) throws OrganizationException {
        List persons;
        ArrayList<PersonTO> result = new ArrayList<PersonTO>();
        String[] criteria = SearchHelper.splitSearchCriteria((String)searchCriteria);
        String[] properties = this.createSearchProperties(searchedProperties);
        try {
            persons = this.personDAO.searchLucene(criteria, properties, this.transfertObjectAssembler.toPersonRequestOptions(options));
        }
        catch (DAOLayerException e) {
            throw new OrganizationException("You must specified non empty search criteria and properties.", e);
        }
        this.toPersonsTO(result, persons);
        return result;
    }

    private void toPersonsTO(List<PersonTO> result, Collection<Person> persons) {
        if (persons != null && !persons.isEmpty()) {
            for (Person person : persons) {
                result.add(this.toPersonTO(person));
            }
        }
    }

    private PersonTO toPersonTO(Person person) {
        return this.transfertObjectAssembler.toPersonTO(person);
    }

    @Override
    @CheckAllArgumentsNotNull
    public String updatePerson(PersonTO personTO) throws OrganizationException {
        String persId = personTO.getId();
        if (persId == null) {
            throw new NullPointerException("Person to update must have an id.");
        }
        Person person = (Person)((Object)this.personDAO.get((Serializable)((Object)persId)));
        if (person == null) {
            throw new OrganizationException("Your are trying to update a non existing Person with id: " + persId);
        }
        this.validatePersonBeforeUpdate(personTO);
        this.transfertObjectAssembler.toPersonBO(personTO, person);
        this.personDAO.save((Object)person);
        return person.getId();
    }

    private void validatePersonBeforeUpdate(PersonTO personTO) throws OrganizationException {
        if (StringHelper.isNullOrEmpty((String)personTO.getFirstname()) || StringHelper.isNullOrEmpty((String)personTO.getLastname()) || StringHelper.isNullOrEmpty((String)personTO.getEmail())) {
            throw new OrganizationException("Person firstname, lastname and email must be specified.");
        }
        Person person = this.personDAO.getPersonByFirstNameLastNameEmail(personTO.getFirstname(), personTO.getLastname(), personTO.getEmail());
        if (person != null && !person.getId().equals(personTO.getId())) {
            throw new OrganizationException("A person with the same firstName, lastName and email address already exists.");
        }
    }
}

