/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ws;

import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.dataloader.DataLoader;
import org.ow2.dragon.api.service.dataloader.DataLoaderException;
import org.ow2.dragon.service.uddi.v3.util.UDDIObjectFactory;
import org.ow2.dragon.util.InputStreamUtil;
import org.ow2.dragon.util.SpringUtil;
import org.springframework.util.StringUtils;
import org.uddi.api_v3.SaveTModel;
import org.uddi.api_v3_porttype.UDDIPublicationPortType;

public class DragonServlet
extends CXFServlet {
    private final Logger logger = Logger.getLogger(this.getClass());
    private static final long serialVersionUID = 7866098412536374367L;

    public void init() throws ServletException {
        super.init();
        this.setDefaultTransformerFactory();
        this.initTModels();
        this.initDragonDatabase();
    }

    private void setDefaultTransformerFactory() {
        String dftClazzName = this.getInitParameter("defaultTransformerFactory");
        System.setProperty("javax.xml.transform.TransformerFactory", dftClazzName);
    }

    private void initDragonDatabase() {
        String datasetLocation = this.getInitParameter("datasetLocation");
        try {
            if (StringUtils.hasText((String)datasetLocation)) {
                this.logger.info((Object)"Create Dragon Database");
                ((DataLoader)SpringUtil.getWebApplicationContext((ServletContext)this.getServletContext()).getBean("dataLoader")).loadDataSet(datasetLocation);
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)("Can't load Dragon dataset from location: " + datasetLocation));
            this.logger.debug((Object)("Can't load Dragon dataset from location: " + datasetLocation), (Throwable)e);
        }
    }

    private void initTModels() {
        block4: {
            this.logger.info((Object)"Load base TModels");
            String tModelsLocation = this.getInitParameter("baseTModelsLocation");
            try {
                InputStream tModelsStream;
                if (!StringUtils.hasText((String)tModelsLocation)) break block4;
                try {
                    tModelsStream = InputStreamUtil.getInputStream((String)tModelsLocation);
                }
                catch (Exception e) {
                    throw new DataLoaderException("Can't load TModels xml file", (Throwable)e);
                }
                SaveTModel saveTModel = UDDIObjectFactory.getInstance().convertStreamSource2SaveTModel((Source)new StreamSource(tModelsStream));
                ((UDDIPublicationPortType)SpringUtil.getWebApplicationContext((ServletContext)this.getServletContext()).getBean("uddiPublicationServiceV3")).saveTModel(saveTModel);
            }
            catch (Exception e) {
                this.logger.warn((Object)("Can't load TModels from location: " + tModelsLocation));
                this.logger.debug((Object)("Can't load TModels from location: " + tModelsLocation), (Throwable)e);
            }
        }
    }
}

