/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.extensions.multiple.test;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.ow2.easywsdl.extensions.multiple.MultipleExtFactory;
import org.ow2.easywsdl.extensions.multiple.api.Description;
import org.ow2.easywsdl.extensions.multiple.api.MultipleExtReader;
import org.ow2.easywsdl.extensions.multiple.api.MultipleExtWriter;
import org.ow2.easywsdl.extensions.sawsdl.SAWSDLFactory;
import org.ow2.easywsdl.extensions.wsdl4bpel.WSDL4BPELFactory;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.PartnerLinkType;
import org.ow2.easywsdl.wsdl.ExtensionFactory;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLReader;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.w3c.dom.Document;

public class MultipleExtensionsTest
extends TestCase {
    private static final URL WSDL_00_ALL_URL = Thread.currentThread().getContextClassLoader().getResource("wsdl/00-all.wsdl");

    public void testCreateDescFromMultipleExtReader() throws URISyntaxException, WSDLException, IOException {
        MultipleExtReader multExtReader = MultipleExtFactory.newInstance().newMultipleExtReader();
        List factories = this.getExtFactoriesList();
        Description desc = multExtReader.read(factories, WSDL_00_ALL_URL);
        Assert.assertNotNull((Object)desc);
    }

    public void testCreateDescFromClassicReader() throws URISyntaxException, WSDLException, IOException {
        WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
        org.ow2.easywsdl.wsdl.api.Description wsdlDesc = wsdlReader.read(WSDL_00_ALL_URL);
        Description desc = null;
        List factories = this.getExtFactoriesList();
        desc = MultipleExtFactory.newInstance().addMultipleExtElmt2Description(factories, (AbsItfDescription)wsdlDesc);
        Assert.assertNotNull((Object)desc);
    }

    public void testFindExpectedExtensions() throws WSDLException, URISyntaxException, IOException {
        MultipleExtReader multExtReader = MultipleExtFactory.newInstance().newMultipleExtReader();
        List factories = this.getExtFactoriesList();
        Description desc = multExtReader.read(factories, WSDL_00_ALL_URL);
        org.ow2.easywsdl.extensions.sawsdl.api.Description sawsdlDesc = (org.ow2.easywsdl.extensions.sawsdl.api.Description)desc.find((ExtensionFactory)SAWSDLFactory.newInstance());
        Assert.assertEquals((String)"[http://desc.example/, http://2.example]", (String)sawsdlDesc.getModelReference().toString());
        org.ow2.easywsdl.extensions.wsdl4bpel.api.Description wsdl4bpelDesc = (org.ow2.easywsdl.extensions.wsdl4bpel.api.Description)desc.find((ExtensionFactory)WSDL4BPELFactory.newInstance());
        Assert.assertEquals((Object)new QName("http://greath.example.com/2004/wsdl/resSvc", "orderProcess"), (Object)((PartnerLinkType)wsdl4bpelDesc.getPartnerLinkTypes().get(0)).getQName());
        sawsdlDesc.setTargetNamespace("http://easywsdl.ow2.org/changeSpread");
        Assert.assertEquals((String)"http://easywsdl.ow2.org/changeSpread", (String)wsdl4bpelDesc.getTargetNamespace());
    }

    public void testFindUnexpectedExtension() throws WSDLException, URISyntaxException, IOException {
        MultipleExtReader multExtReader = MultipleExtFactory.newInstance().newMultipleExtReader();
        ArrayList<SAWSDLFactory> factories = new ArrayList<SAWSDLFactory>();
        factories.add(SAWSDLFactory.newInstance());
        Description desc = multExtReader.read(factories, WSDL_00_ALL_URL);
        org.ow2.easywsdl.extensions.sawsdl.api.Description sawsdlDesc = (org.ow2.easywsdl.extensions.sawsdl.api.Description)desc.find((ExtensionFactory)SAWSDLFactory.newInstance());
        Assert.assertEquals((String)"[http://desc.example/, http://2.example]", (String)sawsdlDesc.getModelReference().toString());
        org.ow2.easywsdl.extensions.wsdl4bpel.api.Description wsdl4bpelDesc = (org.ow2.easywsdl.extensions.wsdl4bpel.api.Description)desc.find((ExtensionFactory)WSDL4BPELFactory.newInstance());
        Assert.assertEquals((Object)new QName("http://greath.example.com/2004/wsdl/resSvc", "orderProcess"), (Object)((PartnerLinkType)wsdl4bpelDesc.getPartnerLinkTypes().get(0)).getQName());
    }

    public void testManageTagsFromMultipleExt() throws WSDLException, IOException, URISyntaxException {
        MultipleExtReader multExtReader = MultipleExtFactory.newInstance().newMultipleExtReader();
        Description desc = multExtReader.read(WSDL_00_ALL_URL);
        org.ow2.easywsdl.extensions.wsdl4bpel.api.Description wsdl4bpelDesc = (org.ow2.easywsdl.extensions.wsdl4bpel.api.Description)desc.find((ExtensionFactory)WSDL4BPELFactory.newInstance());
        ((PartnerLinkType)wsdl4bpelDesc.getPartnerLinkTypes().get(0)).setQName(new QName("testJUnit"));
        Assert.assertEquals((Object)new QName("http://greath.example.com/2004/wsdl/resSvc", "testJUnit"), (Object)((PartnerLinkType)wsdl4bpelDesc.getPartnerLinkTypes().get(0)).getQName());
        org.ow2.easywsdl.extensions.sawsdl.api.Description sawsdlDesc = (org.ow2.easywsdl.extensions.sawsdl.api.Description)desc.find((ExtensionFactory)SAWSDLFactory.newInstance());
        sawsdlDesc.addModelReference(new URI("http://3.example"));
        Assert.assertEquals((String)"[http://desc.example/, http://2.example, http://3.example]", (String)sawsdlDesc.getModelReference().toString());
    }

    public void testWriteMultipleExtDesc() throws WSDLException, IOException, URISyntaxException {
        MultipleExtReader multExtReader = MultipleExtFactory.newInstance().newMultipleExtReader();
        Description desc = multExtReader.read(WSDL_00_ALL_URL);
        org.ow2.easywsdl.extensions.wsdl4bpel.api.Description wsdl4bpelDesc = (org.ow2.easywsdl.extensions.wsdl4bpel.api.Description)desc.find((ExtensionFactory)WSDL4BPELFactory.newInstance());
        ((PartnerLinkType)wsdl4bpelDesc.getPartnerLinkTypes().get(0)).setQName(new QName("testJUnit"));
        org.ow2.easywsdl.extensions.sawsdl.api.Description sawsdlDesc = (org.ow2.easywsdl.extensions.sawsdl.api.Description)desc.find((ExtensionFactory)SAWSDLFactory.newInstance());
        sawsdlDesc.addModelReference(new URI("http://3.example"));
        MultipleExtWriter multExtWriter = MultipleExtFactory.newInstance().newMultipleExtWriter();
        Document doc = multExtWriter.getDocument((AbsItfDescription)desc);
        Assert.assertNotNull((Object)doc);
    }

    private List getExtFactoriesList() throws WSDLException {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(SAWSDLFactory.newInstance());
        factories.add(WSDL4BPELFactory.newInstance());
        return factories;
    }
}

