/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.extensions.sawsdl.test;

import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import edu.uga.cs.lsdis.sawsdl.Definition;
import edu.uga.cs.lsdis.sawsdl.PortType;
import edu.uga.cs.lsdis.sawsdl.extensions.schema.Schema;
import edu.uga.cs.lsdis.sawsdl.impl.util.SchemaUtils;
import edu.uga.cs.lsdis.sawsdl.util.SAWSDLUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.Types;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.ow2.easywsdl.extensions.sawsdl.SAWSDLFactory;
import org.ow2.easywsdl.extensions.sawsdl.api.Description;
import org.ow2.easywsdl.extensions.sawsdl.api.Input;
import org.ow2.easywsdl.extensions.sawsdl.api.InterfaceType;
import org.ow2.easywsdl.extensions.sawsdl.api.Output;
import org.ow2.easywsdl.extensions.sawsdl.api.SASchemaElement;
import org.ow2.easywsdl.extensions.sawsdl.api.SAWSDLElement;
import org.ow2.easywsdl.extensions.sawsdl.api.SAWSDLException;
import org.ow2.easywsdl.extensions.sawsdl.api.schema.All;
import org.ow2.easywsdl.extensions.sawsdl.api.schema.Choice;
import org.ow2.easywsdl.extensions.sawsdl.api.schema.ComplexType;
import org.ow2.easywsdl.extensions.sawsdl.api.schema.Sequence;
import org.ow2.easywsdl.extensions.sawsdl.api.schema.Type;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.WSDLReader;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAWSDL4JComparisonTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        System.setProperty("javax.wsdl.factory.WSDLFactory", "edu.uga.cs.lsdis.sawsdl.impl.factory.WSDLFactoryImpl");
    }

    public void testSAWSDL4J() throws Exception {
        String filePath = "./src/test/resources/sawsdl/";
        File directory = new File(filePath);
        File[] fileList = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".wsdl");
            }
        });
        WSDLReader readerDesc = WSDLFactory.newInstance().newWSDLReader();
        for (int i = 0; i < fileList.length; ++i) {
            String sawsdl = this.readFileAsString(fileList[i]);
            Document sawsdlDoc = XMLHelper.createDocumentFromString((String)sawsdl);
            sawsdlDoc.setDocumentURI(fileList[i].toURI().toURL().toString());
            org.ow2.easywsdl.wsdl.api.Description wsdlDesc = readerDesc.read(sawsdlDoc);
            Description sawsdlDesc = SAWSDLFactory.newInstance().addSAWSDLElmt2Description((AbsItfDescription)wsdlDesc);
            Assert.assertNotNull((Object)sawsdlDesc);
            if (sawsdlDesc.getVersion().toString() != "http://schemas.xmlsoap.org/wsdl/") continue;
            Definition sawsdlDef = SAWSDLUtility.getDefinitionFromFile((File)fileList[i]);
            Assert.assertNotNull((String)"WSDL not loaded by SAWSDL4J", (Object)sawsdlDef);
            this.assertWithSAWSDL4JModel(sawsdlDesc, sawsdlDef);
        }
    }

    private void assertWithSAWSDL4JModel(Description sawsdlDesc, Definition sawsdlDef) throws SAWSDLException {
        org.ow2.easywsdl.extensions.sawsdl.api.Types typesDesc = (org.ow2.easywsdl.extensions.sawsdl.api.Types)sawsdlDesc.getTypes();
        Types typesDef = sawsdlDef.getTypes();
        List schemasDesc = typesDesc.getSchemas();
        List schemasDef = SchemaUtils.getSchemas((Types)typesDef);
        Assert.assertEquals((int)schemasDef.size(), (int)schemasDesc.size());
        Iterator iSchemasDesc = schemasDesc.iterator();
        Iterator iSchemasDef = schemasDef.iterator();
        while (iSchemasDesc.hasNext()) {
            this.assertSchema((Schema)iSchemasDef.next(), (org.ow2.easywsdl.extensions.sawsdl.api.schema.Schema)iSchemasDesc.next());
        }
        List interfacesDesc = sawsdlDesc.getInterfaces();
        Iterator iInterfacesDesc = interfacesDesc.iterator();
        Map interfacesDef = sawsdlDef.getPortTypes();
        Assert.assertEquals((int)interfacesDef.size(), (int)interfacesDesc.size());
        while (iInterfacesDesc.hasNext()) {
            String interModelDesc = "[]";
            String interModelDef = "[]";
            InterfaceType interDesc = (InterfaceType)iInterfacesDesc.next();
            QName interQName = interDesc.getQName();
            interModelDesc = interDesc.getModelReference().toString();
            PortType interDef = sawsdlDef.getSemanticPortType(interQName);
            QName interModelDefQ = (QName)interDef.getExtensionAttribute(new QName("http://www.w3.org/ns/sawsdl", "modelReference"));
            if (interModelDefQ != null) {
                interModelDef = interModelDefQ.toString();
                interModelDef = this.multipleURI4j2easy(interModelDef);
            }
            Assert.assertEquals((String)interModelDef, (String)interModelDesc);
            List operations = interDesc.getOperations();
            Iterator iOperations = operations.iterator();
            while (iOperations.hasNext()) {
                Operation opDef;
                String opModelDesc = "[]";
                String opModelDef = "[]";
                org.ow2.easywsdl.extensions.sawsdl.api.Operation opDesc = (org.ow2.easywsdl.extensions.sawsdl.api.Operation)iOperations.next();
                String opName = opDesc.getQName().getLocalPart();
                if (opDesc.getAttrExtensions() != null) {
                    opModelDesc = opDesc.getAttrExtensions().getModelReference().toString();
                }
                if (!(opDef = interDef.getOperation(opName, ((Input)opDesc.getInput()).getName(), ((Output)opDesc.getOutput()).getName())).getExtensibilityElements().isEmpty()) {
                    Element extElement = ((UnknownExtensibilityElement)opDef.getExtensibilityElements().get(0)).getElement();
                    opModelDef = extElement.getAttributeNS("http://www.w3.org/ns/sawsdl", "modelReference");
                    opModelDef = this.multipleURI4j2easy(opModelDef);
                }
                Assert.assertEquals((String)opModelDef, (String)opModelDesc);
                List faults = opDesc.getFaults();
                Iterator iFaults = faults.iterator();
                while (iFaults.hasNext()) {
                    String fModelDesc = "[]";
                    String fModelDef = "[]";
                    org.ow2.easywsdl.extensions.sawsdl.api.Fault fDesc = (org.ow2.easywsdl.extensions.sawsdl.api.Fault)iFaults.next();
                    String fName = fDesc.getName();
                    interModelDesc = interDesc.getModelReference().toString();
                    Fault fDef = opDef.getFault(fName);
                    QName fModelDefQ = (QName)fDef.getExtensionAttribute(new QName("http://www.w3.org/ns/sawsdl", "modelReference"));
                    if (fModelDefQ != null) {
                        fModelDef = interModelDefQ.toString();
                        fModelDef = this.multipleURI4j2easy(interModelDef);
                    }
                    Assert.assertEquals((String)fModelDef, (String)fModelDesc);
                }
            }
        }
    }

    private void assertSchema(Schema schemaDefAbs, org.ow2.easywsdl.extensions.sawsdl.api.schema.Schema schemaDesc) throws SAWSDLException {
        Element schemaDef = schemaDefAbs.getElement();
        this.assertSchemaTest(schemaDef, (SAWSDLElement)schemaDesc);
        NodeList childDef = schemaDef.getChildNodes();
        ArrayList<Element> elemChildDef = new ArrayList<Element>();
        ArrayList<Element> typeChildDef = new ArrayList<Element>();
        ArrayList<Element> attrChildDef = new ArrayList<Element>();
        for (int i = 0; i < childDef.getLength() / 2; ++i) {
            Node childNode = childDef.item(i * 2 + 1);
            String childName = childNode.getNodeName();
            if (childName.contains("element")) {
                elemChildDef.add((Element)childNode);
                continue;
            }
            if (childName.contains("simpleType") || childName.contains("complexType")) {
                typeChildDef.add((Element)childNode);
                continue;
            }
            if (!childName.contains("attribute")) continue;
            attrChildDef.add((Element)childNode);
        }
        List elemChildDesc = schemaDesc.getElements();
        List typeChildDesc = schemaDesc.getTypes();
        List attrChildDesc = schemaDesc.getAttributes();
        Assert.assertEquals((int)elemChildDef.size(), (int)elemChildDesc.size());
        Iterator iElemDef = elemChildDef.iterator();
        Iterator iElemDesc = elemChildDesc.iterator();
        while (iElemDesc.hasNext()) {
            this.assertSchemaElement((Element)iElemDef.next(), (SAWSDLElement)iElemDesc.next());
        }
        Assert.assertEquals((int)typeChildDef.size(), (int)typeChildDesc.size());
        Iterator iTypeDef = typeChildDef.iterator();
        Iterator iTypeDesc = typeChildDesc.iterator();
        while (iTypeDesc.hasNext()) {
            this.assertSchemaElement((Element)iTypeDef.next(), (SAWSDLElement)iTypeDesc.next());
        }
        Assert.assertEquals((int)attrChildDef.size(), (int)attrChildDesc.size());
        Iterator iAttrDef = attrChildDef.iterator();
        Iterator iAttrDesc = attrChildDesc.iterator();
        while (iAttrDesc.hasNext()) {
            this.assertSchemaElement((Element)iAttrDef.next(), (SAWSDLElement)iAttrDesc.next());
        }
    }

    private void assertSchemaElement(Element elemDef, SAWSDLElement elemDesc) throws SAWSDLException {
        this.assertSchemaTest(elemDef, elemDesc);
        if (elemDesc instanceof org.ow2.easywsdl.extensions.sawsdl.api.schema.Element) {
            Type typeElemDesc = (Type)((org.ow2.easywsdl.extensions.sawsdl.api.schema.Element)elemDesc).getType();
            if (typeElemDesc instanceof ComplexType && typeElemDesc.getQName() == null) {
                Node typeElemDef = elemDef.getChildNodes().item(1);
                Assert.assertNotNull((Object)typeElemDef);
                this.assertSchemaElement((Element)typeElemDef, (SAWSDLElement)typeElemDesc);
            }
        } else if (elemDesc instanceof ComplexType) {
            int i;
            List elemAttrDesc = null;
            elemAttrDesc = ((ComplexType)elemDesc).getAttributes();
            NodeList elemAttrDef = elemDef.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "attribute");
            Assert.assertEquals((int)elemAttrDef.getLength(), (int)elemAttrDesc.size());
            for (int i2 = 0; i2 < elemAttrDef.getLength(); ++i2) {
                this.assertSchemaElement((Element)elemAttrDef.item(i2), (SAWSDLElement)elemAttrDesc.get(i2));
            }
            ArrayList elemChildDesc = new ArrayList();
            ArrayList<Element> elemChildDef = new ArrayList<Element>();
            NodeList elemNodeDef = null;
            if (((ComplexType)elemDesc).hasAll()) {
                elemChildDesc.addAll(((All)((ComplexType)elemDesc).getAll()).getElements());
                elemNodeDef = elemDef.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "element");
            } else if (((ComplexType)elemDesc).hasSequence()) {
                elemChildDesc.addAll(((Sequence)((ComplexType)elemDesc).getSequence()).getElements());
                elemNodeDef = elemDef.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "sequence").item(0).getChildNodes();
            } else if (((ComplexType)elemDesc).hasChoice()) {
                elemChildDesc.addAll(((Choice)((ComplexType)elemDesc).getChoice()).getElements());
                elemNodeDef = elemDef.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "choice").item(0).getChildNodes();
            }
            if (elemNodeDef != null) {
                for (i = 0; i < elemNodeDef.getLength(); ++i) {
                    if (!elemNodeDef.item(i).getNodeName().contains("element")) continue;
                    elemChildDef.add((Element)elemNodeDef.item(i));
                }
            }
            Assert.assertEquals((int)elemChildDef.size(), (int)elemChildDesc.size());
            for (i = 0; i < elemChildDesc.size(); ++i) {
                this.assertSchemaElement((Element)elemChildDef.get(i), (SAWSDLElement)elemChildDesc.get(i));
            }
        }
    }

    private void assertSchemaTest(Element elemDef, SAWSDLElement elemDesc) throws SAWSDLException {
        String modelDef = "[]";
        String modelDesc = "[]";
        modelDesc = elemDesc.getModelReference().toString();
        modelDef = elemDef.getAttributeNS("http://www.w3.org/ns/sawsdl", "modelReference").toString();
        modelDef = this.multipleURI4j2easy(modelDef);
        Assert.assertEquals((String)modelDef, (String)modelDesc);
        if (elemDesc instanceof SASchemaElement) {
            String liftDef = "[]";
            String liftDesc = "[]";
            liftDesc = ((SASchemaElement)elemDesc).getLiftingSchemaMapping().toString();
            liftDef = elemDef.getAttributeNS("http://www.w3.org/ns/sawsdl", "liftingSchemaMapping").toString();
            liftDef = this.multipleURI4j2easy(liftDef);
            Assert.assertEquals((String)liftDef, (String)liftDesc);
            String lowerDef = "[]";
            String lowerDesc = "[]";
            lowerDesc = ((SASchemaElement)elemDesc).getLoweringSchemaMapping().toString();
            lowerDef = elemDef.getAttributeNS("http://www.w3.org/ns/sawsdl", "loweringSchemaMapping").toString();
            lowerDef = this.multipleURI4j2easy(lowerDef);
            Assert.assertEquals((String)lowerDef, (String)lowerDesc);
        }
    }

    private String readFileAsString(File filePath) throws IOException {
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }

    private String multipleURI4j2easy(String str) {
        String result = str;
        result = result.replaceAll("\\s+", ", ");
        result = '[' + result + ']';
        return result;
    }
}

