/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.extensions.sawsdl.test;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.ow2.easywsdl.extensions.sawsdl.SAWSDLFactory;
import org.ow2.easywsdl.extensions.sawsdl.api.Binding;
import org.ow2.easywsdl.extensions.sawsdl.api.BindingOperation;
import org.ow2.easywsdl.extensions.sawsdl.api.Description;
import org.ow2.easywsdl.extensions.sawsdl.api.Endpoint;
import org.ow2.easywsdl.extensions.sawsdl.api.Input;
import org.ow2.easywsdl.extensions.sawsdl.api.InterfaceType;
import org.ow2.easywsdl.extensions.sawsdl.api.Operation;
import org.ow2.easywsdl.extensions.sawsdl.api.Output;
import org.ow2.easywsdl.extensions.sawsdl.api.SAWSDLException;
import org.ow2.easywsdl.extensions.sawsdl.api.Service;
import org.ow2.easywsdl.extensions.sawsdl.api.Types;
import org.ow2.easywsdl.extensions.sawsdl.api.schema.Element;
import org.ow2.easywsdl.extensions.sawsdl.api.schema.Enumeration;
import org.ow2.easywsdl.extensions.sawsdl.api.schema.Restriction;
import org.ow2.easywsdl.extensions.sawsdl.api.schema.Schema;
import org.ow2.easywsdl.extensions.sawsdl.api.schema.SimpleType;
import org.ow2.easywsdl.extensions.sawsdl.api.schema.Type;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;

public class SAWSDLDescriptorTest
extends TestCase {
    public void testReaderSAWSDLForWSDL20() throws URISyntaxException, WSDLException, IOException {
        URL sawsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/purchase.wsdl");
        Assert.assertNotNull((String)"Source SAWSDL not found.", (Object)sawsdlURL);
        org.ow2.easywsdl.wsdl.api.Description wsdlDesc = WSDLFactory.newInstance().newWSDLReader().read(sawsdlURL);
        Description sawsdlDesc = SAWSDLFactory.newInstance().addSAWSDLElmt2Description((AbsItfDescription)wsdlDesc);
        Assert.assertNotNull((Object)sawsdlDesc);
        Assert.assertEquals((String)"[http://www.w3.org/2002/ws/sawsdl/spec/ontology/purchaseorder#OrderConfirmation]", (String)((Service)sawsdlDesc.getServices().get(0)).getModelReference().toString());
        Assert.assertEquals((String)"[http://www.w3.org/2002/ws/sawsdl/spec/ontology/purchaseorder#OrderConfirmation]", (String)((Binding)sawsdlDesc.getBindings().get(0)).getModelReference().toString());
        Assert.assertEquals((String)"[http://example.org/categorization/products/electronics]", (String)((InterfaceType)sawsdlDesc.getInterfaces().get(0)).getModelReference().toString());
        Assert.assertEquals((String)"[http://www.w3.org/2002/ws/sawsdl/spec/ontology/purchaseorder#OrderConfirmation]", (String)((Binding)sawsdlDesc.getBindings().get(0)).getModelReference().toString());
        Assert.assertEquals((String)"[http://www.w3.org/2002/ws/sawsdl/spec/ontology/purchaseorder#OrderConfirmation]", (String)((Types)sawsdlDesc.getTypes()).getModelReference().toString());
        Assert.assertEquals((String)"[http://example.org/categorization/products/electronics]", (String)((Endpoint)((Service)sawsdlDesc.getServices().get(0)).getEndpoints().get(0)).getModelReference().toString());
        Assert.assertEquals((String)"[http://www.w3.org/2002/ws/sawsdl/spec/ontology/purchaseorder#RequestPurchaseOrder]", (String)((Operation)((InterfaceType)sawsdlDesc.getInterfaces().get(0)).getOperations().get(0)).getModelReference().toString());
        Assert.assertEquals((String)"[http://www.w3.org/2002/ws/sawsdl/spec/ontology/purchaseorder#OrderConfirmation]", (String)((BindingOperation)((Binding)sawsdlDesc.getBindings().get(0)).getBindingOperations().get(0)).getModelReference().toString());
        Assert.assertEquals((String)"[http://www.w3.org/2002/ws/sawsdl/spec/ontology/purchaseorder#OrderConfirmation]", (String)((Input)((Operation)((InterfaceType)sawsdlDesc.getInterfaces().get(0)).getOperations().get(0)).getInput()).getModelReference().toString());
        Assert.assertEquals((String)"[http://www.w3.org/2002/ws/sawsdl/spec/ontology/purchaseorder#OrderConfirmation]", (String)((Output)((Operation)((InterfaceType)sawsdlDesc.getInterfaces().get(0)).getOperations().get(0)).getOutput()).getModelReference().toString());
        Assert.assertEquals((String)"[http://www.w3.org/2002/ws/sawsdl/spec/ontology/purchaseorder#OrderRequest]", (String)((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(0)).getModelReference().toString());
        Assert.assertEquals((String)"[http://www.w3.org/2002/ws/sawsdl/spec/mapping/RDFOnt2Request.xml]", (String)((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(0)).getLoweringSchemaMapping().toString());
        Assert.assertEquals((String)"[http://www.w3.org/2002/ws/sawsdl/spec/ontology/purchaseorder#OrderConfirmation]", (String)((Type)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getTypes().get(1)).getModelReference().toString());
        Assert.assertEquals((String)"[http://www.w3.org/2002/ws/sawsdl/spec/ontology/purchaseorder#ConfirmationConfirmed]", (String)((Enumeration)((Restriction)((SimpleType)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getTypes().get(1)).getRestriction()).getEnumerations().get(0)).getModelReference().toString());
        Assert.assertEquals((String)"[]", (String)((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(1)).getModelReference().toString());
        ((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(1)).addModelReference(new URI("http://www.w3.org/2002/ws/sawsdl/spec/mapping/RDFOnt2Request.xml"));
        Assert.assertEquals((String)"[http://www.w3.org/2002/ws/sawsdl/spec/mapping/RDFOnt2Request.xml]", (String)((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(1)).getModelReference().toString());
        ((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(1)).removeModelReference(new URI("http://www.w3.org/2002/ws/sawsdl/spec/mapping/RDFOnt2Request.xml"));
        Assert.assertEquals((String)"[]", (String)((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(1)).getModelReference().toString());
        ((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(0)).addModelReference(new URI("http://www.w3.org/2002/ws/sawsdl/spec/mapping/RDFOnt2Request.xml"));
        Assert.assertEquals((String)"[http://www.w3.org/2002/ws/sawsdl/spec/ontology/purchaseorder#OrderRequest, http://www.w3.org/2002/ws/sawsdl/spec/mapping/RDFOnt2Request.xml]", (String)((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(0)).getModelReference().toString());
        ((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(0)).removeAllModelReferences();
        Assert.assertEquals((String)"[]", (String)((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(0)).getModelReference().toString());
        Assert.assertEquals((String)"[]", (String)((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(1)).getLoweringSchemaMapping().toString());
        ((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(1)).addLoweringSchemaMapping(new URI("http://www.w3.org/2002/ws/sawsdl/spec/mapping/RDFOnt2Request.xml"));
        Assert.assertEquals((String)"[http://www.w3.org/2002/ws/sawsdl/spec/mapping/RDFOnt2Request.xml]", (String)((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(1)).getLoweringSchemaMapping().toString());
        ((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(1)).removeLoweringSchemaMapping(new URI("http://www.w3.org/2002/ws/sawsdl/spec/mapping/RDFOnt2Request.xml"));
        Assert.assertEquals((String)"[]", (String)((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(1)).getLoweringSchemaMapping().toString());
        ((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(0)).addLoweringSchemaMapping(new URI("http://www.w3.org/2002/ws/sawsdl/spec/mapping/RDFOnt2Request.xml"));
        Assert.assertEquals((String)"[http://www.w3.org/2002/ws/sawsdl/spec/mapping/RDFOnt2Request.xml, http://www.w3.org/2002/ws/sawsdl/spec/mapping/RDFOnt2Request.xml]", (String)((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(0)).getLoweringSchemaMapping().toString());
        ((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(0)).removeAllLoweringSchemaMappings();
        Assert.assertEquals((String)"[]", (String)((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(0)).getLoweringSchemaMapping().toString());
        Assert.assertEquals((String)"[]", (String)((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(1)).getLiftingSchemaMapping().toString());
        ((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(1)).addLiftingSchemaMapping(new URI("http://www.w3.org/2002/ws/sawsdl/spec/mapping/RDFOnt2Request.xml"));
        Assert.assertEquals((String)"[http://www.w3.org/2002/ws/sawsdl/spec/mapping/RDFOnt2Request.xml]", (String)((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(1)).getLiftingSchemaMapping().toString());
        ((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(1)).removeLiftingSchemaMapping(new URI("http://www.w3.org/2002/ws/sawsdl/spec/mapping/RDFOnt2Request.xml"));
        Assert.assertEquals((String)"[]", (String)((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(1)).getLiftingSchemaMapping().toString());
        ((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(0)).addLiftingSchemaMapping(new URI("http://www.w3.org/2002/ws/sawsdl/spec/mapping/RDFOnt2Request.xml"));
        Assert.assertEquals((String)"[http://www.w3.org/2002/ws/sawsdl/spec/mapping/RDFOnt2Request.xml]", (String)((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(0)).getLiftingSchemaMapping().toString());
        ((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(0)).removeAllLiftingSchemaMappings();
        Assert.assertEquals((String)"[]", (String)((Element)((Schema)((Types)sawsdlDesc.getTypes()).getSchemas().get(0)).getElements().get(0)).getLiftingSchemaMapping().toString());
        Assert.assertNotNull((Object)((Operation)((InterfaceType)sawsdlDesc.getInterfaces().get(0)).getOperations().get(0)).getSignature());
    }

    public void testReaderSAWSDLForWSDL11() throws URISyntaxException, WSDLException, IOException {
        URL sawsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/processArtifacts.wsdl");
        Assert.assertNotNull((String)"Source SAWSDL not found.", (Object)sawsdlURL);
        Assert.assertNotNull((String)"Source SAWSDL not found.", (Object)sawsdlURL);
        org.ow2.easywsdl.wsdl.api.Description wsdlDesc = WSDLFactory.newInstance().newWSDLReader().read(sawsdlURL);
        Description sawsdlDesc = SAWSDLFactory.newInstance().addSAWSDLElmt2Description((AbsItfDescription)wsdlDesc);
        Assert.assertNotNull((Object)sawsdlDesc);
        Assert.assertEquals((String)"[http://www.w3.org/2002/ws/sawsdl/spec/ontology/purchaseorder#OrderConfirmation]", (String)sawsdlDesc.getAttrExtensions().getModelReference().toString());
        Assert.assertEquals((String)"[http://www.w3.org/2002/ws/sawsdl/spec/ontology/purchaseorder#OrderConfirmation]", (String)((InterfaceType)sawsdlDesc.getInterfaces().get(0)).getModelReference().toString());
    }

    public void testReaderAndWriterSAWSDL() throws SAWSDLException, URISyntaxException, WSDLException, IOException {
        URL sawsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/purchase.wsdl");
        Assert.assertNotNull((String)"Source SAWSDL not found.", (Object)sawsdlURL);
        Description desc = SAWSDLFactory.newInstance().newSAWSDLReader().read(sawsdlURL);
        String res = SAWSDLFactory.newInstance().newSAWSDLWriter().writeSAWSDL(desc);
        Assert.assertNotNull((Object)res);
    }
}

