/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.extensions.sawsdl.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.extensions.sawsdl.api.AttrExtensions;
import org.ow2.easywsdl.extensions.sawsdl.api.SAWSDLElement;
import org.ow2.easywsdl.extensions.sawsdl.api.SAWSDLException;
import org.ow2.easywsdl.extensions.sawsdl.impl.AttrExtensionsImpl;
import org.ow2.easywsdl.extensions.sawsdl.impl.inout.SAWSDLReaderImpl;
import org.ow2.easywsdl.schema.api.SchemaElement;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import org.ow2.easywsdl.wsdl.org.xmlsoap.schemas.wsdl.TExtensibleDocumented;
import org.w3c.dom.Element;

public class SAWSDLElementImpl<T extends SchemaElement>
implements SAWSDLElement {
    private static final long serialVersionUID = 1L;
    protected T tag;
    private AttrExtensions attrExtensions;

    public SAWSDLElementImpl(T t) throws SAWSDLException {
        this.tag = t;
        this.attrExtensions = null;
        try {
            if (!(this.tag instanceof AttrExtensions)) {
                this.getAttExtensionsInWSDL11Element();
            }
        }
        catch (WSDLException e) {
            throw new SAWSDLException(e);
        }
    }

    private void getAttExtensionsInWSDL11Element() throws WSDLException {
        if (this.tag instanceof AbstractWSDLElementImpl && ((AbstractWSDLElementImpl)this.tag).getModel() instanceof TExtensibleDocumented) {
            Iterator it = ((TExtensibleDocumented)((AbstractWSDLElementImpl)this.tag).getModel()).getAny().iterator();
            Object part = null;
            while (it.hasNext()) {
                part = it.next();
                if (part instanceof Element) {
                    if (!((Element)part).getLocalName().equals("attrExtensions") || !((Element)part).getNamespaceURI().equals("http://www.w3.org/ns/sawsdl")) continue;
                    SAWSDLReaderImpl reader = new SAWSDLReaderImpl();
                    JAXBElement<org.ow2.easywsdl.extensions.sawsdl.org.w3.ns.sawsdl.AttrExtensions> jaxbPlt = reader.convertElement2AttrExtensions(part);
                    ((TExtensibleDocumented)((AbstractWSDLElementImpl)this.tag).getModel()).getAny().remove(part);
                    ((TExtensibleDocumented)((AbstractWSDLElementImpl)this.tag).getModel()).getAny().add(jaxbPlt);
                    this.attrExtensions = new AttrExtensionsImpl((org.ow2.easywsdl.extensions.sawsdl.org.w3.ns.sawsdl.AttrExtensions)jaxbPlt.getValue(), (AbstractWSDLElementImpl)this.tag);
                    continue;
                }
                if (!(part instanceof org.ow2.easywsdl.extensions.sawsdl.org.w3.ns.sawsdl.AttrExtensions)) continue;
                this.attrExtensions = new AttrExtensionsImpl(part, (AbstractWSDLElementImpl)this.tag);
            }
        }
    }

    @Override
    public List<URI> getModelReference() throws SAWSDLException {
        ArrayList<URI> res = new ArrayList<URI>();
        try {
            String val = (String)this.tag.getOtherAttributes().get(new QName("http://www.w3.org/ns/sawsdl", "modelReference"));
            if (val != null && !val.trim().equals("")) {
                StringTokenizer st = new StringTokenizer(val, " ");
                while (st.hasMoreTokens()) {
                    res.add(new URI(st.nextToken()));
                }
            }
        }
        catch (URISyntaxException e) {
            throw new SAWSDLException(e);
        }
        catch (XmlException e) {
            throw new SAWSDLException(e);
        }
        return res;
    }

    @Override
    public void addModelReference(URI uri) throws SAWSDLException {
        try {
            String val = (String)this.tag.getOtherAttributes().get(new QName("http://www.w3.org/ns/sawsdl", "modelReference"));
            val = val != null && !val.trim().equals("") ? val + " " + uri.toString() : uri.toString();
            this.tag.getOtherAttributes().put(new QName("http://www.w3.org/ns/sawsdl", "modelReference"), val);
        }
        catch (XmlException e) {
            throw new SAWSDLException(e);
        }
    }

    @Override
    public List<URI> removeAllModelReferences() throws SAWSDLException {
        List<URI> res = this.getModelReference();
        try {
            this.tag.getOtherAttributes().remove(new QName("http://www.w3.org/ns/sawsdl", "modelReference"));
        }
        catch (XmlException e) {
            throw new SAWSDLException(e);
        }
        return res;
    }

    @Override
    public URI removeModelReference(URI uri) throws SAWSDLException {
        URI res = null;
        try {
            String val = (String)this.tag.getOtherAttributes().get(new QName("http://www.w3.org/ns/sawsdl", "modelReference"));
            if (val != null && !val.trim().equals("")) {
                StringTokenizer st = new StringTokenizer(val, " ");
                String newVal = null;
                String currentToken = null;
                while (st.hasMoreTokens()) {
                    currentToken = st.nextToken();
                    if (uri.toString().equals(currentToken)) {
                        res = new URI(currentToken);
                        continue;
                    }
                    if (newVal == null) {
                        newVal = currentToken;
                        continue;
                    }
                    newVal = newVal + " " + currentToken;
                }
                if (newVal == null) {
                    this.tag.getOtherAttributes().remove(new QName("http://www.w3.org/ns/sawsdl", "modelReference"));
                }
            }
        }
        catch (XmlException e) {
            throw new SAWSDLException(e);
        }
        catch (URISyntaxException e) {
            throw new SAWSDLException(e);
        }
        return res;
    }

    @Override
    public AttrExtensions getAttrExtensions() throws SAWSDLException {
        return this.attrExtensions;
    }
}

