/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.extensions.sawsdl.impl.inout;

import com.ebmwebsourcing.easycommons.xml.Transformers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.ow2.easywsdl.extensions.sawsdl.SAWSDLFactory;
import org.ow2.easywsdl.extensions.sawsdl.api.Description;
import org.ow2.easywsdl.extensions.sawsdl.api.SAWSDLException;
import org.ow2.easywsdl.extensions.sawsdl.api.SAWSDLReader;
import org.ow2.easywsdl.extensions.sawsdl.impl.SAWSDLJAXBContext;
import org.ow2.easywsdl.extensions.sawsdl.org.w3.ns.sawsdl.AttrExtensions;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLReader;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLReaderImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class SAWSDLReaderImpl
implements SAWSDLReader {
    private WSDLReader reader = null;
    private SAWSDLJAXBContext jaxbcontext = null;

    public SAWSDLReaderImpl() throws SAWSDLException {
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            this.jaxbcontext = new SAWSDLJAXBContext();
            this.reader = factory.newWSDLReader();
        }
        catch (WSDLException e) {
            throw new SAWSDLException(e);
        }
    }

    @Override
    public Object getFeature(WSDLReader.FeatureConstants name) {
        return this.reader.getFeature(name);
    }

    @Override
    public Map<WSDLReader.FeatureConstants, Object> getFeatures() {
        return this.reader.getFeatures();
    }

    public void setFeatures(Map<WSDLReader.FeatureConstants, Object> features) {
        ((AbstractWSDLReaderImpl)this.reader).setFeatures(features);
    }

    @Override
    public Description read(URL wsdlURL) throws SAWSDLException, IOException, URISyntaxException {
        try {
            InputSource inputSource = new InputSource(wsdlURL.openStream());
            inputSource.setSystemId(wsdlURL.toString());
            return this.read(inputSource);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("The provided well-formed URL has been detected as malformed !!");
        }
        catch (WSDLException e) {
            throw new SAWSDLException(e);
        }
    }

    @Override
    public Description read(Document wsdlDocument) throws SAWSDLException, URISyntaxException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(baos);
        Transformer transformer = null;
        try {
            transformer = Transformers.takeTransformer();
            transformer.transform(new DOMSource(wsdlDocument), streamResult);
            baos.flush();
            baos.close();
            InputSource documentInputSource = new InputSource(new ByteArrayInputStream(baos.toByteArray()));
            documentInputSource.setSystemId(wsdlDocument.getBaseURI());
            Description description = this.read(documentInputSource);
            return description;
        }
        catch (TransformerException e) {
            throw new SAWSDLException(e);
        }
        catch (IOException e) {
            throw new SAWSDLException(e);
        }
        finally {
            Transformers.releaseTransformer((Transformer)transformer);
        }
    }

    @Override
    public Description read(InputSource wsdlInputSource) throws SAWSDLException, MalformedURLException, URISyntaxException {
        try {
            org.ow2.easywsdl.wsdl.api.Description desc = this.reader.read(wsdlInputSource);
            return SAWSDLFactory.newInstance().addSAWSDLElmt2Description((AbsItfDescription)desc);
        }
        catch (WSDLException e) {
            throw new SAWSDLException(e);
        }
    }

    @Override
    public void setFeature(WSDLReader.FeatureConstants name, Object value) throws WSDLException {
        this.reader.setFeature(name, value);
    }

    public JAXBElement<AttrExtensions> convertElement2AttrExtensions(Element attExtElmt) throws WSDLException {
        JAXBElement res = null;
        try {
            res = this.jaxbcontext.getJaxbContext().createUnmarshaller().unmarshal((Node)attExtElmt, AttrExtensions.class);
        }
        catch (JAXBException e) {
            throw new WSDLException("Failed to build Java bindings from WSDL descriptor XML document", (Throwable)e);
        }
        return res;
    }
}

