/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.schema.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.ow2.easywsdl.schema.SchemaFactory;
import org.ow2.easywsdl.schema.api.All;
import org.ow2.easywsdl.schema.api.ComplexType;
import org.ow2.easywsdl.schema.api.Element;
import org.ow2.easywsdl.schema.api.Import;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.Sequence;
import org.ow2.easywsdl.schema.api.SimpleType;
import org.ow2.easywsdl.schema.api.Type;
import org.ow2.easywsdl.schema.api.absItf.AbsItfEnumeration;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSimpleType;
import org.ow2.easywsdl.schema.api.absItf.AbsItfType;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.ow2.easywsdl.schema.test.Environement;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ReadSchemaDescriptorTestCase
extends TestCase {
    public void testReaderSchema_FromURL() throws URISyntaxException, SchemaException, IOException {
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/sample.xsd");
        Assert.assertNotNull((String)"XMLSchema 'descriptors/sample.xsd' not found in the classpath.", (Object)xsdUrl);
        Schema schema = SchemaFactory.newInstance().newSchemaReader().read(xsdUrl);
        this.assertSampleXSD(schema);
    }

    public void testReaderSchema_FromDocument() throws URISyntaxException, SchemaException, IOException, SAXException, ParserConfigurationException {
        InputStream xsdInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("descriptors/sample.xsd");
        Assert.assertNotNull((String)"XMLSchema 'descriptors/sample.xsd' not found in the classpath.", (Object)xsdInputStream);
        Document xsdDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xsdInputStream);
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/sample.xsd");
        Assert.assertNotNull((String)"XMLSchema 'descriptors/sample.xsd' not found in the classpath.", (Object)xsdUrl);
        xsdDocument.setDocumentURI(xsdUrl.toString());
        Schema schema = SchemaFactory.newInstance().newSchemaReader().read(xsdDocument);
        this.assertSampleXSD(schema);
    }

    public void testReaderSchema_FromInputSource() throws URISyntaxException, SchemaException, IOException {
        InputStream xsdInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("descriptors/sample.xsd");
        Assert.assertNotNull((String)"XMLSchema 'descriptors/sample.xsd' not found in the classpath.", (Object)xsdInputStream);
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/sample.xsd");
        Assert.assertNotNull((String)"XMLSchema 'descriptors/sample.xsd' not found in the classpath.", (Object)xsdUrl);
        InputSource xsdInputSource = new InputSource(xsdInputStream);
        xsdInputSource.setSystemId(xsdUrl.toString());
        Schema schema = SchemaFactory.newInstance().newSchemaReader().read(xsdInputSource);
        this.assertSampleXSD(schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReaderSchemaWithImport_FromJarURL() throws URISyntaxException, SchemaException, IOException {
        File jarFile = File.createTempFile("testReaderSchemaWithImport_FromJarURL", ".jar");
        JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(jarFile));
        String[] filesToJar = new String[]{"descriptors/reservationList.xsd", "descriptors/reservationDetails.xsd", "descriptors/wsdl20-instance.xsd"};
        ClassLoader currentClassloader = Thread.currentThread().getContextClassLoader();
        for (String fileToJar : filesToJar) {
            int nRead;
            String entryName = fileToJar.replace("descriptors", "descriptors-in-jar");
            JarEntry jarEntry = new JarEntry(entryName);
            jarOutputStream.putNextEntry(jarEntry);
            InputStream entryInputStream = currentClassloader.getResourceAsStream(fileToJar);
            Assert.assertNotNull((String)"File to jar not found.", (Object)entryInputStream);
            byte[] buffer = new byte[1024];
            do {
                if ((nRead = entryInputStream.read(buffer)) <= 0) continue;
                jarOutputStream.write(buffer, 0, nRead);
            } while (nRead != -1);
            entryInputStream.close();
            jarOutputStream.closeEntry();
        }
        jarOutputStream.close();
        URLClassLoader newClassloader = new URLClassLoader(new URL[]{jarFile.toURI().toURL()}, currentClassloader);
        Thread.currentThread().setContextClassLoader(newClassloader);
        try {
            URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors-in-jar/reservationList.xsd");
            Assert.assertNotNull((String)"XMLSchema 'descriptors-in-jar/reservationList.xsd' not found in the classpath.", (Object)xsdUrl);
            Schema schema = SchemaFactory.newInstance().newSchemaReader().read(xsdUrl);
            this.assertReservationListXSD(schema);
            jarFile.delete();
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassloader);
        }
    }

    public void testReaderSchema_EltRefWithoutImport_FromURL() throws URISyntaxException, SchemaException, IOException {
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/element-ref without import.xsd");
        Assert.assertNotNull((String)"XMLSchema 'descriptors/element-ref without import.xsd' not found in the classpath.", (Object)xsdUrl);
        Schema schema = SchemaFactory.newInstance().newSchemaReader().read(xsdUrl);
        Assert.assertNotNull((Object)schema);
        Element myElt = (Element)schema.getElement(Environement.EltRefWithoutImport.MYELT_ELT);
        Assert.assertNotNull((String)("The element " + Environement.EltRefWithoutImport.MYELT_ELT.toString() + " is missing in XSD '" + "descriptors/element-ref without import.xsd" + "'."), (Object)myElt);
        Assert.assertEquals((Object)Environement.EltRefWithoutImport.MYELT_ELT, (Object)myElt.getQName());
        Type myEltType = (Type)myElt.getType();
        Assert.assertNotNull((String)("The element " + Environement.EltRefWithoutImport.MYELT_ELT.toString() + " has no type in XSD '" + "descriptors/element-ref without import.xsd" + "'."), (Object)myEltType);
        Assert.assertTrue((String)("The type of the element " + Environement.EltRefWithoutImport.MYELT_ELT.toString() + " is not a complex type."), (boolean)(myEltType instanceof ComplexType));
        ComplexType myEltCplType = (ComplexType)myEltType;
        Sequence myEltSeq = (Sequence)myEltCplType.getSequence();
        Assert.assertNotNull((String)("The complex type of the element " + Environement.EltRefWithoutImport.MYELT_ELT.toString() + " does not contain a sequence."), (Object)myEltSeq);
        List myEltSeqElts = myEltSeq.getElements();
        Assert.assertNotNull((String)("The sequence of the complex type of the element " + Environement.EltRefWithoutImport.MYELT_ELT.toString() + " does not contain element."), (Object)myEltSeqElts);
        Assert.assertEquals((String)("The expected element number isn't correct in the sequence of the complex type of the element " + Environement.EltRefWithoutImport.MYELT_ELT.toString() + "'."), (int)1, (int)myEltSeqElts.size());
        Assert.assertEquals((String)("The expected element isn't the correct one in the sequence of the complex type of the element " + Environement.EltRefWithoutImport.MYELT_ELT.toString() + "'."), (Object)Environement.EltRefWithoutImport.SCHEMA_ELT, (Object)((Element)myEltSeqElts.get(0)).getQName());
    }

    private void assertSampleXSD(Schema schema) {
        Assert.assertNotNull((Object)schema);
        Assert.assertEquals((int)5, (int)schema.getTypes().size());
        Assert.assertEquals((String)"PurchaseOrderType", (String)((Type)schema.getTypes().get(0)).getQName().getLocalPart());
        Assert.assertEquals((String)"USAddress", (String)((Type)schema.getTypes().get(1)).getQName().getLocalPart());
        Assert.assertEquals((String)"Items", (String)((Type)schema.getTypes().get(2)).getQName().getLocalPart());
        Assert.assertEquals((String)"SKU", (String)((Type)schema.getTypes().get(3)).getQName().getLocalPart());
        Assert.assertEquals((String)"string", (String)((AbsItfSimpleType)schema.getTypes().get(3)).getRestriction().getBase().getLocalPart());
        Assert.assertEquals((String)"123-AB", (String)((AbsItfEnumeration)((AbsItfSimpleType)schema.getTypes().get(3)).getRestriction().getEnumerations().get(1)).getValue());
        Assert.assertEquals((String)"PurchaseAllOrderType", (String)((Type)schema.getTypes().get(4)).getQName().getLocalPart());
        ComplexType seqType = (ComplexType)schema.getTypes().get(0);
        Assert.assertEquals((int)4, (int)((Sequence)seqType.getSequence()).getElements().size());
        ComplexType allType = (ComplexType)schema.getTypes().get(4);
        Assert.assertEquals((int)4, (int)((All)allType.getAll()).getElements().size());
        Assert.assertEquals((int)2, (int)schema.getElements().size());
        Assert.assertEquals((String)"purchaseOrder", (String)((Element)schema.getElements().get(0)).getQName().getLocalPart());
        Assert.assertEquals((String)"comment", (String)((Element)schema.getElements().get(1)).getQName().getLocalPart());
    }

    public void testImportSchema_FromURL() throws URISyntaxException, SchemaException, IOException {
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/reservationList.xsd");
        Assert.assertNotNull((String)"XMLSchema 'descriptors/reservationList.xsd' not found in the classpath.", (Object)xsdUrl);
        Schema schema = SchemaFactory.newInstance().newSchemaReader().read(xsdUrl);
        this.assertReservationListXSD(schema);
    }

    public void testImportSchema_FromInputSource() throws URISyntaxException, SchemaException, IOException {
        InputStream xsdInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("descriptors/reservationList.xsd");
        Assert.assertNotNull((String)"XMLSchema 'descriptors/reservationList.xsd' not found in the classpath.", (Object)xsdInputStream);
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/reservationList.xsd");
        Assert.assertNotNull((String)"XMLSchema 'descriptors/reservationList.xsd' not found in the classpath.", (Object)xsdUrl);
        InputSource xsdInputSource = new InputSource(xsdInputStream);
        xsdInputSource.setSystemId(xsdUrl.toString());
        Schema schema = SchemaFactory.newInstance().newSchemaReader().read(xsdInputSource);
        this.assertReservationListXSD(schema);
    }

    private void assertReservationListXSD(Schema schema) {
        Assert.assertNotNull((String)"The description returned is null.", (Object)schema);
        Assert.assertEquals((String)"The expected import number isn't correct in the XSD 'descriptors/reservationList.xsd'.", (int)2, (int)schema.getImports().size());
        Assert.assertEquals((String)"The expected type number isn't correct in the XSD 'descriptors/reservationList.xsd'.", (int)1, (int)schema.getTypes().size());
        Assert.assertEquals((String)"The expected element number isn't correct in the XSD 'descriptors/reservationList.xsd'.", (int)8, (int)schema.getElements().size());
        Assert.assertEquals((String)"The expected attribute number isn't correct in the XSD 'descriptors/reservationList.xsd'.", (int)1, (int)schema.getAttributes().size());
        List importsReservationDetails = schema.getImports("http://greath.example.com/2004/schemas/reservationDetails");
        Assert.assertEquals((int)1, (int)importsReservationDetails.size());
        Import importReservationDetails = (Import)importsReservationDetails.get(0);
        Schema importedSchemaReservationDetails = (Schema)importReservationDetails.getSchema();
        Assert.assertNotNull((String)"No schema in import 'http://greath.example.com/2004/schemas/reservationDetails'.", (Object)importedSchemaReservationDetails);
        Assert.assertEquals((String)"The expected type number isn't correct in the imported XSD 'http://greath.example.com/2004/schemas/reservationDetails'.", (int)1, (int)importedSchemaReservationDetails.getTypes().size());
        Assert.assertEquals((String)"The expected element number isn't correct in the imported XSD 'http://greath.example.com/2004/schemas/reservationDetails'.", (int)6, (int)importedSchemaReservationDetails.getElements().size());
        Element reservationElt = (Element)schema.getElement(Environement.RESERVATIONLIST_RESERVATION_ELT);
        Assert.assertNotNull((String)("The element " + Environement.RESERVATIONLIST_RESERVATION_ELT.toString() + " is missing in import '" + "http://greath.example.com/2004/schemas/reservationList" + "'."), (Object)reservationElt);
        Assert.assertEquals((Object)Environement.RESERVATIONLIST_RESERVATION_ELT, (Object)reservationElt.getQName());
        Type reservationEltType = (Type)reservationElt.getType();
        Assert.assertNotNull((String)("The element " + Environement.RESERVATIONLIST_RESERVATION_ELT.toString() + " has no type in import '" + "http://greath.example.com/2004/schemas/reservationList" + "'."), (Object)reservationEltType);
        Assert.assertTrue((String)("The type of the element " + Environement.RESERVATIONLIST_RESERVATION_ELT.toString() + " is not a complex type."), (boolean)(reservationEltType instanceof ComplexType));
        ComplexType reservationEltCplType = (ComplexType)reservationEltType;
        Sequence reservationEltSeq = (Sequence)reservationEltCplType.getSequence();
        Assert.assertNotNull((String)("The complex type of the element " + Environement.RESERVATIONLIST_RESERVATION_ELT.toString() + " does not contain a sequence."), (Object)reservationEltSeq);
        List reservationEltSeqElts = reservationEltSeq.getElements();
        Assert.assertNotNull((String)("The sequence of the complex type of the element " + Environement.RESERVATIONLIST_RESERVATION_ELT.toString() + " does not contain element."), (Object)reservationEltSeqElts);
        Assert.assertEquals((String)("The expected element number isn't correct in the sequence of the complex type of the element " + Environement.RESERVATIONLIST_RESERVATION_ELT.toString() + "'."), (int)4, (int)reservationEltSeqElts.size());
        boolean foundConfNumber = false;
        for (Element reservationEltSeqElt : reservationEltSeqElts) {
            if (!reservationEltSeqElt.getQName().equals(Environement.RESERVATIONDETAILS_CONFNUMBER_ELT)) continue;
            foundConfNumber = true;
            break;
        }
        Assert.assertTrue((String)("The sequence of the complex type of the element " + Environement.RESERVATIONLIST_RESERVATION_ELT.toString() + " does not contain element '" + Environement.RESERVATIONDETAILS_CONFNUMBER_ELT + "'."), (boolean)foundConfNumber);
    }

    public void testReaderSchemaEquals() throws URISyntaxException, SchemaException, IOException {
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/sample.xsd");
        URL xsdUrl2 = Thread.currentThread().getContextClassLoader().getResource("descriptors/sample_equals.xsd");
        Assert.assertNotNull((String)"XMLSchema 'descriptors/sample.xsd' not found in the classpath.", (Object)xsdUrl);
        Schema schema1 = SchemaFactory.newInstance().newSchemaReader().read(xsdUrl);
        Schema schema2 = SchemaFactory.newInstance().newSchemaReader().read(xsdUrl);
        Assert.assertTrue((boolean)schema1.equals(schema2));
        Assert.assertTrue((boolean)((AbstractSchemaElementImpl)schema1.getElements().get(0)).equals(schema2.getElements().get(0)));
        Schema schema3 = SchemaFactory.newInstance().newSchemaReader().read(xsdUrl);
        schema3.setTargetNamespace("http://easywsdl.ow2.org/namespace/toto");
        Assert.assertFalse((boolean)schema1.equals(schema3));
        Schema schema4 = SchemaFactory.newInstance().newSchemaReader().read(xsdUrl);
        SimpleType st = (SimpleType)schema4.createSimpleType();
        st.setQName(new QName("http://namespace", "test"));
        schema4.addType((AbsItfType)st);
        Assert.assertFalse((boolean)schema1.equals(schema4));
        Schema schema5 = SchemaFactory.newInstance().newSchemaReader().read(xsdUrl2);
        Assert.assertTrue((boolean)schema1.equals(schema5));
    }
}

