/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.schema.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.ow2.easywsdl.schema.SchemaFactory;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.w3c.dom.Document;

public class WriteSchemaDescriptorTestCase
extends TestCase {
    public void testWriterSchema_Document() throws SchemaException, URISyntaxException, SchemaException, IOException {
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/sample.xsd");
        Assert.assertNotNull((String)"XMLSchema 'descriptors/sample.xsd' not found in the classpath.", (Object)xsdUrl);
        Schema desc = SchemaFactory.newInstance().newSchemaReader().read(xsdUrl);
        Document doc = SchemaFactory.newInstance().newSchemaWriter().getDocument(desc);
        Assert.assertNotNull((Object)doc);
        Assert.assertFalse((String)"The DOM document base URI contains unencoded spaces", (boolean)doc.getDocumentURI().contains(" "));
    }

    public void testWriterSchema_DocumentBaseURIContainingSpaces() throws SchemaException, URISyntaxException, SchemaException, IOException {
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/sample with space in its name.xsd");
        Assert.assertNotNull((String)"XMLSchema 'descriptors/sample with space in its name.xsd' not found in the classpath.", (Object)xsdUrl);
        Schema desc = SchemaFactory.newInstance().newSchemaReader().read(xsdUrl);
        Document doc = SchemaFactory.newInstance().newSchemaWriter().getDocument(desc);
        Assert.assertNotNull((Object)doc);
        Assert.assertFalse((String)"The DOM document base URI contains unencoded spaces", (boolean)doc.getDocumentURI().contains(" "));
    }

    public void testWriterSchema_OutputStream() throws SchemaException, URISyntaxException, SchemaException, IOException {
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("descriptors/sample.xsd");
        Assert.assertNotNull((String)"XMLSchema 'descriptors/sample.xsd' not found in the classpath.", (Object)xsdUrl);
        Schema desc = SchemaFactory.newInstance().newSchemaReader().read(xsdUrl);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SchemaFactory.newInstance().newSchemaWriter().writeSchema(desc, (OutputStream)baos);
        String xsd = baos.toString();
        Assert.assertTrue((String)"Nothing has been written.", (xsd.length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Not enough bytes written.", (xsd.length() > 3000 ? 1 : 0) != 0);
    }
}

