/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.tooling.java2wsdl;

import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.ejb.Remote;
import org.ow2.easywsdl.tooling.java2wsdl.BadParameterException;
import org.ow2.easywsdl.tooling.java2wsdl.JavaToEasyWSDL;
import org.ow2.easywsdl.tooling.java2wsdl.WSDLGenerationContext;
import org.ow2.easywsdl.tooling.java2wsdl.util.XMLSorter;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Main {
    private static final String TOOL_NAME = "EJB2WSDL";
    private static final String TARGET_WSDL_FLAG = "-o";
    private static final String NS_PREFIX_MAPPING = "-m";
    private static final String VERBOSE_FLAG = "-verbose";
    private static final String VERSION_FLAG = "-version";
    private static final String CONSOLE_FLAG = "-console";
    private static final String POLYMORPH_PARAMETERS = "-poly";
    private static final String POLYMORPH_CLASSES = "-polyClasses";
    private String targetWSDLFile;
    private boolean console;
    private boolean verbose;
    private boolean version;
    private List<String> files = new ArrayList<String>();
    private List<String> polymorphClasses = new ArrayList<String>();
    private String targetMapping;
    private boolean customNS = false;
    private boolean polymorph;

    public void setPolymorphClasses(List<String> polymorphClasses) {
        this.polymorphClasses = polymorphClasses;
    }

    public void setPolymorph(boolean polymorph) {
        this.polymorph = polymorph;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setWSDL(String wsdl) {
        this.targetWSDLFile = wsdl;
    }

    public void setServiceClass(String serviceClassName) {
        this.files.add(serviceClassName);
    }

    public void setCustomNS(boolean customNS) {
        this.customNS = customNS;
    }

    public void setTargetMapping(String targetMapping) {
        this.targetMapping = targetMapping;
    }

    public void generateWSDL() {
        this.process();
    }

    public static void main(String[] args) {
        Main main = new Main();
        String[] args2 = (String[])args.clone();
        try {
            if (args2.length == 0) {
                main.printUsage();
                System.exit(-1);
            }
            main.processFlags(args2);
            main.process();
        }
        catch (BadParameterException bpe) {
            System.out.println("Unkown or malformed option : " + bpe.getMessage());
            main.printUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() {
        if (this.version) {
            this.printVersion();
        }
        if (this.files.size() == 0) {
            if (this.verbose) {
                System.out.println("No class to process");
            }
        } else {
            JavaToEasyWSDL transformer = new JavaToEasyWSDL(this.verbose);
            List<Class<?>> classes = this.computeClassList(this.files);
            try {
                WSDLGenerationContext context = transformer.generateWSDL(classes, this.polymorph, this.polymorphClasses);
                Description desc = context.processWSDL();
                WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
                if (this.customNS) {
                    StringTokenizer tok = new StringTokenizer(this.targetMapping, ",");
                    String[] cNS = new String[tok.countTokens()];
                    int cpt = 0;
                    while (tok.hasMoreTokens()) {
                        cNS[cpt++] = tok.nextToken();
                    }
                }
                Document doc = writer.getDocument(desc);
                Document doc2 = XMLSorter.sortNodes(doc);
                String res = XMLPrettyPrinter.prettyPrint((Node)doc2, (String)"utf8");
                if (this.targetWSDLFile != null && this.targetWSDLFile.length() > 0) {
                    File file = new File(this.targetWSDLFile);
                    if (this.verbose) {
                        System.out.println("Writing result to file " + file.getAbsolutePath());
                    }
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(file);
                        fos.write(res.getBytes());
                    }
                    finally {
                        fos.close();
                    }
                }
                if (this.console) {
                    if (this.verbose) {
                        System.out.println("WSDL-----------");
                    }
                    System.out.println(res);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (WSDLException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private List<Class<?>> computeClassList(List<String> files2) {
        ArrayList res = new ArrayList();
        for (String string : files2) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            res.add(clazz);
            if (!this.verbose) continue;
            if (clazz.getAnnotation(Remote.class) != null) {
                System.out.println("Found remote EJB3 Interface ==> Generate WSDL for " + clazz.getName());
                continue;
            }
            System.out.println("Generate WSDL for POJO " + clazz.getName());
        }
        return res;
    }

    private void printVersion() {
        System.out.println("VERSION NOT IMPLEMENTED");
    }

    private void processFlags(String[] args) throws BadParameterException {
        for (int i = 0; i < args.length; ++i) {
            String flag = args[i];
            if (flag.startsWith("-")) {
                if (TARGET_WSDL_FLAG.equals(flag)) {
                    if (++i < args.length) {
                        this.targetWSDLFile = args[i];
                        continue;
                    }
                    throw new BadParameterException(flag);
                }
                if (VERBOSE_FLAG.equals(flag)) {
                    this.verbose = true;
                    continue;
                }
                if (VERSION_FLAG.equals(flag)) {
                    this.version = true;
                    continue;
                }
                if (CONSOLE_FLAG.equals(flag)) {
                    this.console = true;
                    continue;
                }
                if (POLYMORPH_PARAMETERS.equals(flag)) {
                    this.polymorph = true;
                    continue;
                }
                if (POLYMORPH_CLASSES.equals(flag)) {
                    this.polymorph = true;
                    if (++i < args.length) {
                        this.polymorphClasses = this.csvAsList(args[i]);
                        continue;
                    }
                    throw new BadParameterException(flag);
                }
                if (NS_PREFIX_MAPPING.equals(flag)) {
                    this.customNS = true;
                    if (++i < args.length) {
                        this.targetMapping = args[i];
                        continue;
                    }
                    throw new BadParameterException(flag);
                }
                throw new BadParameterException(flag);
            }
            this.files.add(flag);
        }
    }

    private List<String> csvAsList(String classList) {
        ArrayList<String> res = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(classList, ",;");
        while (tok.hasMoreTokens()) {
            res.add(tok.nextToken());
        }
        return res;
    }

    protected void printUsage() {
        System.out.println("EJB2WSDL usage:");
        System.out.println(" -?         Display the online help for this utility.");
        System.out.println(" -help");
        System.out.println(" -h");
        System.out.println(" -o         Specifies the name of the generated WSDL file");
        System.out.println(" -poly Specifies wether or not parameter and return types must be processed as an object tree in the Schema");
        System.out.println(" -polyClasses [comma seperated list of additional polymorphic classes] Specifies a list of arbitrary classes to add in the schemas to handle polymorphism");
        System.out.println(" -verbose   Displays information during processing");
        System.out.println(" -version   Displays EJB2WSDL version");
        System.out.println(" -console   Prints results to standard console");
        System.out.println(" -m prefix1,ns1,prefix2,ns2...     Force the generation of the namespace mapping between prefix1 and ns1, prefix2 and ns2, and so on...");
    }
}

