/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.tooling.java2wsdl.ant;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.tools.ant.Task;
import org.ow2.easywsdl.tooling.java2wsdl.Main;

public class Java2WSDLTask
extends Task {
    private String output;
    private String serviceClass;
    private String nsMapping;
    private boolean verbose;
    private boolean polymorph = false;
    private String polyclasses = "";

    public String getNsMapping() {
        return this.nsMapping;
    }

    public void setNsMapping(String nsMapping) {
        this.nsMapping = nsMapping;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(String serviceClass) {
        this.serviceClass = serviceClass;
    }

    public boolean isPolymorph() {
        return this.polymorph;
    }

    public void setPolymorph(boolean polymorph) {
        this.polymorph = polymorph;
    }

    public String getPolyclasses() {
        return this.polyclasses;
    }

    public void setPolyclasses(String polyclasses) {
        this.polyclasses = polyclasses;
    }

    public void execute() {
        System.out.println("Generating wsdl for class " + this.serviceClass + ".");
        Main java2EasyWsdl = new Main();
        java2EasyWsdl.setVerbose(this.verbose);
        java2EasyWsdl.setWSDL(this.output);
        java2EasyWsdl.setServiceClass(this.serviceClass);
        java2EasyWsdl.setPolymorph(this.polymorph);
        if (this.nsMapping != null && !"".equals(this.nsMapping)) {
            java2EasyWsdl.setCustomNS(true);
            java2EasyWsdl.setTargetMapping(this.nsMapping);
        }
        if (this.polymorph && !"".equals(this.polyclasses)) {
            ArrayList<String> res = new ArrayList<String>();
            StringTokenizer tok = new StringTokenizer(this.polyclasses, ",;");
            while (tok.hasMoreTokens()) {
                res.add(tok.nextToken());
            }
            java2EasyWsdl.setPolymorphClasses(res);
        }
        java2EasyWsdl.generateWSDL();
    }

    public static void main(String[] args) {
        System.out.println("starting...");
        Java2WSDLTask task = new Java2WSDLTask();
        task.setVerbose(true);
        task.setOutput("testejb.wsdl");
        task.setServiceClass("fr.mbe.test.ComplexTestEJBImpl");
        task.execute();
    }
}

