/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.tooling.java2wsdl.util;

import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XMLSorter {
    public static String sort(Document xmlDocument, String encoding) {
        String result = "";
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            XMLSorter.sort(xmlDocument, outStream, encoding);
            result = outStream.toString(encoding);
        }
        catch (Exception e) {
            System.err.println("write_dom failed:" + e);
        }
        return result;
    }

    public static String sort(Document xmlDocument) {
        return XMLSorter.sort(xmlDocument, XMLSorter.getEncoding(xmlDocument));
    }

    public static Document sortNodes(Document xml) {
        String tempXML = XMLSorter.sort(xml);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc2 = builder.parse(new InputSource(new StringReader(tempXML)));
            return doc2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return xml;
        }
    }

    public static void sort(Node node, OutputStream out, String encoding) throws Exception {
        DOMSource source = new DOMSource(node);
        Source stylesheetSource = XMLSorter.getStyleSheetSource();
        Transformer transformer = XMLPrettyPrinter.getTransformer((Source)stylesheetSource);
        transformer.setOutputProperty("encoding", encoding);
        transformer.transform(source, new StreamResult(out));
    }

    public static String getEncoding(Document xmlDocument) {
        String encoding = xmlDocument.getInputEncoding();
        if (encoding == null) {
            encoding = xmlDocument.getXmlEncoding();
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    private static Source getStyleSheetSource() {
        return new StreamSource(XMLSorter.class.getResourceAsStream("/test/classify.xsl"));
    }
}

