/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.test.util;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.ow2.easywsdl.wsdl.util.InputStreamForker;

public class InputStreamForkerTest
extends TestCase {
    private static final String AVAILABLE_FILE = "org/ow2/easywsdl/wsdl/test/util/inputstreamforker/available-file.txt";

    public void testAvailableWithReading() {
        try {
            InputStream isOriginal = Thread.currentThread().getContextClassLoader().getResourceAsStream(AVAILABLE_FILE);
            InputStreamForker isf = new InputStreamForker(isOriginal);
            InputStream isOne = isf.getInputStreamOne();
            byte[] bufferOne = new byte[3];
            int bytesRead = isOne.read(bufferOne);
            TestCase.assertEquals((int)3, (int)bytesRead);
            TestCase.assertEquals((String)"Hi,", (String)new String(bufferOne));
            int availableOne = isOne.available();
            int availableTwo = isf.getInputStreamTwo().available();
            TestCase.assertEquals((int)24, (int)availableOne);
            TestCase.assertEquals((int)27, (int)availableTwo);
        }
        catch (IOException e) {
            e.printStackTrace();
            TestCase.fail();
        }
    }

    public void testReadFullAtOnce() {
        try {
            InputStream isOriginal = Thread.currentThread().getContextClassLoader().getResourceAsStream(AVAILABLE_FILE);
            InputStreamForker isf = new InputStreamForker(isOriginal);
            InputStream isOne = isf.getInputStreamOne();
            byte[] bufferOne = new byte[1024];
            int bytesReadOne = isOne.read(bufferOne);
            TestCase.assertEquals((int)27, (int)bytesReadOne);
            TestCase.assertEquals((int)0, (int)isOne.available());
            TestCase.assertEquals((int)27, (int)isf.getInputStreamTwo().available());
            InputStream isTwo = isf.getInputStreamTwo();
            byte[] bufferTwo = new byte[1024];
            int bytesReadTwo = isTwo.read(bufferTwo);
            TestCase.assertEquals((int)27, (int)bytesReadTwo);
            TestCase.assertEquals((int)0, (int)isOne.available());
            TestCase.assertEquals((int)0, (int)isf.getInputStreamTwo().available());
        }
        catch (IOException e) {
            e.printStackTrace();
            TestCase.fail();
        }
    }

    public void testReadPartial() {
        try {
            InputStream isOriginal = Thread.currentThread().getContextClassLoader().getResourceAsStream(AVAILABLE_FILE);
            InputStreamForker isf = new InputStreamForker(isOriginal);
            InputStream isOne = isf.getInputStreamOne();
            InputStream isTwo = isf.getInputStreamTwo();
            byte[] bufferOneOne = new byte[10];
            int bytesReadOneOne = isOne.read(bufferOneOne);
            TestCase.assertEquals((int)10, (int)bytesReadOneOne);
            TestCase.assertEquals((int)17, (int)isOne.available());
            TestCase.assertEquals((int)27, (int)isTwo.available());
            byte[] bufferOneTwo = new byte[10];
            int bytesReadOneTwo = isOne.read(bufferOneTwo);
            TestCase.assertEquals((int)10, (int)bytesReadOneTwo);
            TestCase.assertEquals((int)7, (int)isOne.available());
            TestCase.assertEquals((int)27, (int)isTwo.available());
            byte[] bufferOneThree = new byte[10];
            int bytesReadOneThree = isOne.read(bufferOneThree);
            TestCase.assertEquals((int)7, (int)bytesReadOneThree);
            TestCase.assertEquals((int)0, (int)isOne.available());
            TestCase.assertEquals((int)27, (int)isTwo.available());
            TestCase.assertEquals((String)"Hi,\n\nMy length is 27 bytes.", (String)(new String(bufferOneOne) + new String(bufferOneTwo) + new String(bufferOneThree, 0, bytesReadOneThree)));
            byte[] bufferTwoOne = new byte[15];
            int bytesReadTwoOne = isTwo.read(bufferTwoOne);
            TestCase.assertEquals((int)15, (int)bytesReadTwoOne);
            TestCase.assertEquals((int)12, (int)isTwo.available());
            byte[] bufferTwoTwo = new byte[15];
            int bytesReadTwoTwo = isTwo.read(bufferTwoTwo);
            TestCase.assertEquals((int)12, (int)bytesReadTwoTwo);
            TestCase.assertEquals((int)0, (int)isTwo.available());
            TestCase.assertEquals((String)"Hi,\n\nMy length is 27 bytes.", (String)(new String(bufferTwoOne) + new String(bufferTwoTwo, 0, bytesReadTwoTwo)));
            byte[] bufferTwoThree = new byte[150];
            int bytesReadTwoThree = isTwo.read(bufferTwoThree);
            TestCase.assertEquals((String)"EOF must be reached", (int)-1, (int)bytesReadTwoThree);
        }
        catch (IOException e) {
            e.printStackTrace();
            TestCase.fail();
        }
    }

    public void testPartialReadAndClose() {
        try {
            InputStream isOriginal = Thread.currentThread().getContextClassLoader().getResourceAsStream(AVAILABLE_FILE);
            InputStreamForker isf = new InputStreamForker(isOriginal);
            InputStream isOne = isf.getInputStreamOne();
            InputStream isTwo = isf.getInputStreamTwo();
            byte[] bufferOneOne = new byte[10];
            int bytesReadOneOne = isOne.read(bufferOneOne);
            TestCase.assertEquals((int)10, (int)bytesReadOneOne);
            TestCase.assertEquals((int)17, (int)isOne.available());
            TestCase.assertEquals((int)27, (int)isTwo.available());
            byte[] bufferOneTwo = new byte[10];
            int bytesReadOneTwo = isOne.read(bufferOneTwo);
            TestCase.assertEquals((int)10, (int)bytesReadOneTwo);
            TestCase.assertEquals((int)7, (int)isOne.available());
            isOne.close();
            TestCase.assertEquals((int)0, (int)isOne.available());
            TestCase.assertEquals((int)27, (int)isTwo.available());
            TestCase.assertEquals((int)27, (int)isTwo.available());
            TestCase.assertEquals((String)"Hi,\n\nMy length is 27", (String)(new String(bufferOneOne) + new String(bufferOneTwo)));
            byte[] bufferTwoOne = new byte[15];
            int bytesReadTwoOne = isTwo.read(bufferTwoOne);
            TestCase.assertEquals((int)15, (int)bytesReadTwoOne);
            TestCase.assertEquals((int)12, (int)isTwo.available());
            byte[] bufferTwoTwo = new byte[15];
            int bytesReadTwoTwo = isTwo.read(bufferTwoTwo);
            TestCase.assertEquals((int)12, (int)bytesReadTwoTwo);
            TestCase.assertEquals((int)0, (int)isTwo.available());
            TestCase.assertEquals((String)"Hi,\n\nMy length is 27 bytes.", (String)(new String(bufferTwoOne) + new String(bufferTwoTwo, 0, bytesReadTwoTwo)));
        }
        catch (IOException e) {
            e.printStackTrace();
            TestCase.fail();
        }
    }

    public void testClosedInputStreamNoException() {
        try {
            InputStream isOriginal = Thread.currentThread().getContextClassLoader().getResourceAsStream(AVAILABLE_FILE);
            InputStreamForker isf = new InputStreamForker(isOriginal);
            InputStream isOne = isf.getInputStreamOne();
            InputStream isTwo = isf.getInputStreamTwo();
            byte[] bufferOneOne = new byte[1024];
            int bytesReadOneOne = isOne.read(bufferOneOne);
            TestCase.assertEquals((int)27, (int)bytesReadOneOne);
            TestCase.assertEquals((int)0, (int)isOne.available());
            TestCase.assertEquals((int)27, (int)isTwo.available());
            TestCase.assertEquals((String)"Hi,\n\nMy length is 27 bytes.", (String)new String(bufferOneOne, 0, bytesReadOneOne));
            isOriginal.close();
            byte[] bufferTwoOne = new byte[27];
            int bytesReadTwoOne = isTwo.read(bufferTwoOne);
            TestCase.assertEquals((int)27, (int)bytesReadTwoOne);
            try {
                TestCase.assertEquals((int)0, (int)isTwo.available());
                TestCase.assertEquals((String)"Not thrown IOException", (boolean)true, (boolean)false);
            }
            catch (IOException e) {
                // empty catch block
            }
            TestCase.assertEquals((String)"Hi,\n\nMy length is 27 bytes.", (String)new String(bufferTwoOne, 0, bytesReadTwoOne));
        }
        catch (IOException e) {
            e.printStackTrace();
            TestCase.fail();
        }
    }

    public void testClosedInputStreamWithException() {
        try {
            InputStream isOriginal = Thread.currentThread().getContextClassLoader().getResourceAsStream(AVAILABLE_FILE);
            InputStreamForker isf = new InputStreamForker(isOriginal);
            InputStream isOne = isf.getInputStreamOne();
            InputStream isTwo = isf.getInputStreamTwo();
            byte[] bufferOneOne = new byte[10];
            int bytesReadOneOne = isOne.read(bufferOneOne);
            TestCase.assertEquals((int)10, (int)bytesReadOneOne);
            TestCase.assertEquals((int)17, (int)isOne.available());
            TestCase.assertEquals((int)27, (int)isTwo.available());
            TestCase.assertEquals((String)"Hi,\n\nMy le", (String)new String(bufferOneOne, 0, bytesReadOneOne));
            isOriginal.close();
            byte[] bufferTwoOne = new byte[1024];
            isTwo.read(bufferTwoOne);
            TestCase.assertEquals((String)"Not thrown IOException", (boolean)true, (boolean)false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

