/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.api.abstractElmt;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ow2.easywsdl.schema.DefaultSchema;
import org.ow2.easywsdl.schema.SchemaFactory;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.absItf.AbsItfImport;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaImpl;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfTypes;

public abstract class AbstractTypesImpl<E, S extends Schema, Impt extends AbsItfImport>
extends AbstractWSDLElementImpl<E>
implements AbsItfTypes<S, Impt> {
    private static final long serialVersionUID = 1L;
    protected AbsItfDescription desc;
    protected List<S> schemas = new ArrayList<S>();
    protected List<Impt> importedSchemas = new ArrayList<Impt>();

    public AbstractTypesImpl(E model, AbstractWSDLElementImpl parent) {
        super(model, parent);
    }

    protected void addImportedSchemasInAllList() {
        for (AbsItfImport impt : this.importedSchemas) {
            if (impt.getSchema() == null) continue;
            this.schemas.add((Schema)impt.getSchema());
        }
    }

    @Override
    public List<S> getSchemas() {
        if (this.schemas == null) {
            this.schemas = new ArrayList<S>();
        }
        return this.schemas;
    }

    @Override
    public List<Impt> getImportedSchemas() {
        if (this.importedSchemas == null) {
            this.importedSchemas = new ArrayList<Impt>();
        }
        return this.importedSchemas;
    }

    protected void setAllNamespacesInAllSchemas() {
        for (Schema schema : this.schemas) {
            Map ns = this.desc.getNamespaces().getNamespaces();
            for (Map.Entry entry : ns.entrySet()) {
                schema.getAllNamespaces().addNamespace((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    @Override
    public String toString() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public void addSchema(S schema) {
        this.schemas.add(schema);
    }

    protected void reloadAllListInAllSchema() {
        ArrayList<Object> alls = new ArrayList<Object>();
        for (Schema schema : this.schemas) {
            if (!alls.contains(schema)) {
                alls.add(schema);
            }
            for (AbsItfImport impt : schema.getImports()) {
                if (impt.getSchema() == null || alls.contains(impt.getSchema())) continue;
                alls.add(impt.getSchema());
            }
        }
        for (AbsItfSchema absItfSchema : alls) {
            ((AbstractSchemaImpl)absItfSchema).addImportElementsInAllList();
            ((AbstractSchemaImpl)absItfSchema).addIncludeElementsInAllList();
            ((AbstractSchemaImpl)absItfSchema).addRedefineElementsInAllList();
        }
    }

    protected void setSchemaInAllImport() {
        boolean found = false;
        for (Schema s : this.schemas) {
            for (AbsItfImport impt : s.getImports()) {
                if (impt.getSchema() != null) continue;
                impt.setSchema(this.findSchema(impt.getNamespaceURI()));
                found = true;
            }
        }
        if (found) {
            this.reloadAllListInAllSchema();
        }
    }

    protected AbsItfSchema findSchema(String namespaceURI) {
        DefaultSchema res = null;
        if ("http://www.w3.org/2001/XMLSchema".equals(namespaceURI)) {
            res = SchemaFactory.getDefaultSchema();
        } else {
            for (Schema s : this.schemas) {
                if (s == null || s.getTargetNamespace() == null || !s.getTargetNamespace().equals(namespaceURI)) continue;
                res = s;
                break;
            }
        }
        return res;
    }
}

