/****************************************************************************
 *
 * Copyright (c) 2011-2012, EBM WebSourcing
 * This code is not made public and should not be shared outside EBM WebSourcing. 
 *
 *****************************************************************************/
 
package org.ow2.petals.groovycommons.util;


public class LinuxProcess {

    def static kill(pattern, signal=15) {
        def processNamePattern = ~/.*${pattern}.*/;
        def pidPattern = ~/[0-9]{1,5}/;
        def processEntryMatcher = processNamePattern.matcher(getCurrentProcessesSnapshot());
        while(processEntryMatcher.find()) {
            def line = processEntryMatcher.group();
            println "Process entry found : ${line}";

            def pidMatcher = pidPattern.matcher(line);
            pidMatcher.find();
            def pid = pidMatcher.group();

            println "--> Kill process with signal ${signal}:[${pid}]";
            nativeKillByPID(pid,signal);
        }
    }

    def static String getCurrentProcessesSnapshot() {
        return "ps -eo pid,cmd".execute().text;
    }

    def static nativeKillByProcessName(processName, signal=15) {
        return "pkill -${signal} ${processName}*".execute().text ;
    }

    def static nativeKillByPID(pid, signal=15) {
        return "kill -${signal} ${pid}".execute().text ;
    }
}
