/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.plugin.jbiplugin;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import junitx.framework.Assert;
import org.junit.Test;
import org.ow2.petals.jbi.descriptor.original.JBIDescriptorBuilder;
import org.ow2.petals.jbi.descriptor.original.generated.ClassPath;
import org.ow2.petals.jbi.descriptor.original.generated.Component;
import org.ow2.petals.jbi.descriptor.original.generated.Identification;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.plugin.jbiplugin.JBIAbstractTestMojo;
import org.ow2.petals.plugin.jbiplugin.JBIPackageMojo;
import org.ow2.petals.plugin.jbiplugin.environement.ComponentWithUpdateOnAlreadyProvidedClasspathElt;
import org.ow2.petals.plugin.jbiplugin.environement.ComponentWithUpdateOnEmptyClasspathElt;
import org.ow2.petals.plugin.jbiplugin.environement.ComponentWithUpdateOnEmptyProvidedDescription;
import org.ow2.petals.plugin.jbiplugin.environement.ComponentWithUpdateOnExtraClasspathElt;
import org.ow2.petals.plugin.jbiplugin.environement.ComponentWithUpdateOnNotProvidedClasspathElt;
import org.ow2.petals.plugin.jbiplugin.environement.ComponentWithUpdateOnNotProvidedDescription;
import org.ow2.petals.plugin.jbiplugin.environement.ComponentWithUpdateOnProvidedDescription;

public class JBIPackageWithUpdateMojoTest
extends JBIAbstractTestMojo {
    @Test
    public void testPackageComponentWithUpdateOnProvidedDescription() throws Exception {
        File componentPomFile = new File(ComponentWithUpdateOnProvidedDescription.SRC_HOME, "pom.xml");
        JBIPackageMojo packageMojo = this.getPackageMojo(componentPomFile);
        packageMojo.execute();
        ZipFile packagedComponentFile = new ZipFile(new File(ComponentWithUpdateOnProvidedDescription.TARGET_HOME, "component-with-update-on-provided-description-1.0.0-TEST.zip"));
        ZipEntry jbiEntry = packagedComponentFile.getEntry("META-INF/jbi.xml");
        Assert.assertNotNull((String)"The JBI descriptor is missing in the packaged JBI component", (Object)jbiEntry);
        Jbi jbiDescriptor = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)packagedComponentFile.getInputStream(jbiEntry));
        Component jbiComponent = jbiDescriptor.getComponent();
        Assert.assertNotNull((String)"The section 'component' is missing in the JBI descriptor.", (Object)jbiComponent);
        Identification jbiIdent = jbiComponent.getIdentification();
        Assert.assertNotNull((String)"The identification is missing in the section 'component' in the JBI descriptor.", (Object)jbiIdent);
        Assert.assertEquals((String)"Incorrect description found in the JBI decsriptor", (String)"Description provided by the POM file", (String)jbiIdent.getDescription());
    }

    @Test
    public void testPackageComponentWithUpdateOnEmptyProvidedDescription() throws Exception {
        File componentPomFile = new File(ComponentWithUpdateOnEmptyProvidedDescription.SRC_HOME, "pom.xml");
        JBIPackageMojo packageMojo = this.getPackageMojo(componentPomFile);
        packageMojo.execute();
        ZipFile packagedComponentFile = new ZipFile(new File(ComponentWithUpdateOnEmptyProvidedDescription.TARGET_HOME, "component-with-update-on-empty-provided-description-1.0.0-TEST.zip"));
        ZipEntry jbiEntry = packagedComponentFile.getEntry("META-INF/jbi.xml");
        Assert.assertNotNull((String)"The JBI descriptor is missing in the packaged JBI component", (Object)jbiEntry);
        Jbi jbiDescriptor = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)packagedComponentFile.getInputStream(jbiEntry));
        Component jbiComponent = jbiDescriptor.getComponent();
        Assert.assertNotNull((String)"The section 'component' is missing in the JBI descriptor.", (Object)jbiComponent);
        Identification jbiIdent = jbiComponent.getIdentification();
        Assert.assertNotNull((String)"The identification is missing in the section 'component' in the JBI descriptor.", (Object)jbiIdent);
        Assert.assertEquals((String)"Incorrect description found in the JBI decsriptor", (String)"Description provided by the original JBI descriptor", (String)jbiIdent.getDescription());
    }

    @Test
    public void testPackageComponentWithUpdateOnNotProvidedDescription() throws Exception {
        File componentPomFile = new File(ComponentWithUpdateOnNotProvidedDescription.SRC_HOME, "pom.xml");
        JBIPackageMojo packageMojo = this.getPackageMojo(componentPomFile);
        packageMojo.execute();
        ZipFile packagedComponentFile = new ZipFile(new File(ComponentWithUpdateOnNotProvidedDescription.TARGET_HOME, "component-with-update-on-not-provided-description-1.0.0-TEST.zip"));
        ZipEntry jbiEntry = packagedComponentFile.getEntry("META-INF/jbi.xml");
        Assert.assertNotNull((String)"The JBI descriptor is missing in the packaged JBI component", (Object)jbiEntry);
        Jbi jbiDescriptor = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)packagedComponentFile.getInputStream(jbiEntry));
        Component jbiComponent = jbiDescriptor.getComponent();
        Assert.assertNotNull((String)"The section 'component' is missing in the JBI descriptor.", (Object)jbiComponent);
        Identification jbiIdent = jbiComponent.getIdentification();
        Assert.assertNotNull((String)"The identification is missing in the section 'component' in the JBI descriptor.", (Object)jbiIdent);
        Assert.assertEquals((String)"Incorrect description found in the JBI decsriptor", (String)"Description provided by the original JBI descriptor", (String)jbiIdent.getDescription());
    }

    @Test
    public void testPackageComponentWithUpdateOnAlreadyProvidedClasspathElt() throws Exception {
        File componentPomFile = new File(ComponentWithUpdateOnAlreadyProvidedClasspathElt.SRC_HOME, "pom.xml");
        JBIPackageMojo packageMojo = this.getPackageMojo(componentPomFile);
        packageMojo.execute();
        ZipFile packagedComponentFile = new ZipFile(new File(ComponentWithUpdateOnAlreadyProvidedClasspathElt.TARGET_HOME, "component-with-update-on-already-provided-classpath-elt-1.0.0-TEST.zip"));
        ZipEntry jbiEntry = packagedComponentFile.getEntry("META-INF/jbi.xml");
        Assert.assertNotNull((String)"The JBI descriptor is missing in the packaged JBI component", (Object)jbiEntry);
        Jbi jbiDescriptor = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)packagedComponentFile.getInputStream(jbiEntry));
        Component jbiComponent = jbiDescriptor.getComponent();
        Assert.assertNotNull((String)"The section 'component' is missing in the JBI descriptor.", (Object)jbiComponent);
        ClassPath jbiClassPath = jbiComponent.getBootstrapClassPath();
        Assert.assertNotNull((String)"The boostrap classpath is missing in the section 'component' in the JBI descriptor.", (Object)jbiComponent);
        List jbiClassPathElts = jbiClassPath.getPathElement();
        Assert.assertNotNull((String)"The boostrap classpath is empty in the section 'component' in the JBI descriptor.", (Object)jbiClassPathElts);
        Assert.assertNotEquals((String)"The boostrap classpath is empty in the section 'component' in the JBI descriptor.", (int)0, (int)jbiClassPathElts.size());
        Assert.assertTrue((String)"The dependency is missing in bootstrap classpath in the JBI descriptor", (boolean)jbiClassPathElts.contains("test-1.0.jar"));
        Assert.assertTrue((String)"The component JAR is missing in bootstrap classpath in the JBI descriptor", (boolean)jbiClassPathElts.contains("component.jar"));
        jbiClassPath = jbiComponent.getComponentClassPath();
        Assert.assertNotNull((String)"The component classpath is missing in the section 'component' in the JBI descriptor.", (Object)jbiComponent);
        jbiClassPathElts = jbiClassPath.getPathElement();
        Assert.assertNotNull((String)"The component classpath is empty in the section 'component' in the JBI descriptor.", (Object)jbiClassPathElts);
        Assert.assertNotEquals((String)"The component classpath is empty in the section 'component' in the JBI descriptor.", (int)0, (int)jbiClassPathElts.size());
        Assert.assertTrue((String)"The dependency is missing in component classpath in the JBI descriptor", (boolean)jbiClassPathElts.contains("test-1.0.jar"));
        Assert.assertTrue((String)"The component JAR  is missing in component classpath in the JBI descriptor", (boolean)jbiClassPathElts.contains("component.jar"));
    }

    @Test
    public void testPackageComponentWithUpdateOnNotProvidedClasspathElt() throws Exception {
        File componentPomFile = new File(ComponentWithUpdateOnNotProvidedClasspathElt.SRC_HOME, "pom.xml");
        JBIPackageMojo packageMojo = this.getPackageMojo(componentPomFile);
        packageMojo.execute();
        ZipFile packagedComponentFile = new ZipFile(new File(ComponentWithUpdateOnNotProvidedClasspathElt.TARGET_HOME, "component-with-update-on-not-provided-classpath-elt-1.0.0-TEST.zip"));
        ZipEntry jbiEntry = packagedComponentFile.getEntry("META-INF/jbi.xml");
        Assert.assertNotNull((String)"The JBI descriptor is missing in the packaged JBI component", (Object)jbiEntry);
        Jbi jbiDescriptor = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)packagedComponentFile.getInputStream(jbiEntry));
        Component jbiComponent = jbiDescriptor.getComponent();
        Assert.assertNotNull((String)"The section 'component' is missing in the JBI descriptor.", (Object)jbiComponent);
        ClassPath jbiClassPath = jbiComponent.getBootstrapClassPath();
        Assert.assertNotNull((String)"The boostrap classpath is missing in the section 'component' in the JBI descriptor.", (Object)jbiComponent);
        List jbiClassPathElts = jbiClassPath.getPathElement();
        Assert.assertNotNull((String)"The boostrap classpath is empty in the section 'component' in the JBI descriptor.", (Object)jbiClassPathElts);
        Assert.assertNotEquals((String)"The boostrap classpath is empty in the section 'component' in the JBI descriptor.", (int)0, (int)jbiClassPathElts.size());
        Assert.assertTrue((String)"The dependency is missing in bootstrap classpath in the JBI descriptor", (boolean)jbiClassPathElts.contains("test-1.0.jar"));
        Assert.assertTrue((String)"The dependency is missing in bootstrap classpath in the JBI descriptor", (boolean)jbiClassPathElts.contains("transitive-test-1.0.jar"));
        Assert.assertTrue((String)"The component JAR is missing in bootstrap classpath in the JBI descriptor", (boolean)jbiClassPathElts.contains("component.jar"));
        jbiClassPath = jbiComponent.getComponentClassPath();
        Assert.assertNotNull((String)"The component classpath is missing in the section 'component' in the JBI descriptor.", (Object)jbiComponent);
        jbiClassPathElts = jbiClassPath.getPathElement();
        Assert.assertNotNull((String)"The component classpath is empty in the section 'component' in the JBI descriptor.", (Object)jbiClassPathElts);
        Assert.assertNotEquals((String)"The component classpath is empty in the section 'component' in the JBI descriptor.", (int)0, (int)jbiClassPathElts.size());
        Assert.assertTrue((String)"The dependency is missing in component classpath in the JBI descriptor", (boolean)jbiClassPathElts.contains("test-1.0.jar"));
        Assert.assertTrue((String)"The dependency is missing in bootstrap classpath in the JBI descriptor", (boolean)jbiClassPathElts.contains("transitive-test-1.0.jar"));
        Assert.assertTrue((String)"The component JAR  is missing in component classpath in the JBI descriptor", (boolean)jbiClassPathElts.contains("component.jar"));
    }

    @Test
    public void testPackageComponentWithUpdateOnExtraClasspathElt() throws Exception {
        File componentPomFile = new File(ComponentWithUpdateOnExtraClasspathElt.SRC_HOME, "pom.xml");
        JBIPackageMojo packageMojo = this.getPackageMojo(componentPomFile);
        packageMojo.execute();
        ZipFile packagedComponentFile = new ZipFile(new File(ComponentWithUpdateOnExtraClasspathElt.TARGET_HOME, "component-with-update-on-extra-classpath-elt-1.0.0-TEST.zip"));
        ZipEntry jbiEntry = packagedComponentFile.getEntry("META-INF/jbi.xml");
        Assert.assertNotNull((String)"The JBI descriptor is missing in the packaged JBI component", (Object)jbiEntry);
        Jbi jbiDescriptor = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)packagedComponentFile.getInputStream(jbiEntry));
        Component jbiComponent = jbiDescriptor.getComponent();
        Assert.assertNotNull((String)"The section 'component' is missing in the JBI descriptor.", (Object)jbiComponent);
        ClassPath jbiClassPath = jbiComponent.getBootstrapClassPath();
        Assert.assertNotNull((String)"The boostrap classpath is missing in the section 'component' in the JBI descriptor.", (Object)jbiComponent);
        List jbiClassPathElts = jbiClassPath.getPathElement();
        Assert.assertNotNull((String)"The boostrap classpath is empty in the section 'component' in the JBI descriptor.", (Object)jbiClassPathElts);
        Assert.assertNotEquals((String)"The boostrap classpath is empty in the section 'component' in the JBI descriptor.", (int)0, (int)jbiClassPathElts.size());
        Assert.assertTrue((String)"The dependency is missing in bootstrap classpath in the JBI descriptor", (boolean)jbiClassPathElts.contains("test-1.0.jar"));
        Assert.assertTrue((String)"The dependency is missing in bootstrap classpath in the JBI descriptor", (boolean)jbiClassPathElts.contains("transitive-test-1.0.jar"));
        Assert.assertTrue((String)"The component JAR is missing in bootstrap classpath in the JBI descriptor", (boolean)jbiClassPathElts.contains("component.jar"));
        Assert.assertTrue((String)"The extra classpath element is missing in component classpath in the JBI descriptor", (boolean)jbiClassPathElts.contains("extra.jar"));
        jbiClassPath = jbiComponent.getComponentClassPath();
        Assert.assertNotNull((String)"The component classpath is missing in the section 'component' in the JBI descriptor.", (Object)jbiComponent);
        jbiClassPathElts = jbiClassPath.getPathElement();
        Assert.assertNotNull((String)"The component classpath is empty in the section 'component' in the JBI descriptor.", (Object)jbiClassPathElts);
        Assert.assertNotEquals((String)"The component classpath is empty in the section 'component' in the JBI descriptor.", (int)0, (int)jbiClassPathElts.size());
        Assert.assertTrue((String)"The dependency is missing in component classpath in the JBI descriptor", (boolean)jbiClassPathElts.contains("test-1.0.jar"));
        Assert.assertTrue((String)"The dependency is missing in bootstrap classpath in the JBI descriptor", (boolean)jbiClassPathElts.contains("transitive-test-1.0.jar"));
        Assert.assertTrue((String)"The component JAR  is missing in component classpath in the JBI descriptor", (boolean)jbiClassPathElts.contains("component.jar"));
        Assert.assertTrue((String)"The extra classpath element is missing in component classpath in the JBI descriptor", (boolean)jbiClassPathElts.contains("extra.jar"));
    }

    @Test
    public void testPackageComponentWithUpdateOnEmptyClasspathElt() throws Exception {
        File componentPomFile = new File(ComponentWithUpdateOnEmptyClasspathElt.SRC_HOME, "pom.xml");
        JBIPackageMojo packageMojo = this.getPackageMojo(componentPomFile);
        packageMojo.execute();
        ZipFile packagedComponentFile = new ZipFile(new File(ComponentWithUpdateOnEmptyClasspathElt.TARGET_HOME, "component-with-update-on-empty-classpath-elt-1.0.0-TEST.zip"));
        ZipEntry jbiEntry = packagedComponentFile.getEntry("META-INF/jbi.xml");
        Assert.assertNotNull((String)"The JBI descriptor is missing in the packaged JBI component", (Object)jbiEntry);
        Jbi jbiDescriptor = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)packagedComponentFile.getInputStream(jbiEntry));
        Component jbiComponent = jbiDescriptor.getComponent();
        Assert.assertNotNull((String)"The section 'component' is missing in the JBI descriptor.", (Object)jbiComponent);
        ClassPath jbiClassPath = jbiComponent.getBootstrapClassPath();
        Assert.assertNotNull((String)"The boostrap classpath is missing in the section 'component' in the JBI descriptor.", (Object)jbiComponent);
        List jbiClassPathElts = jbiClassPath.getPathElement();
        Assert.assertNotNull((String)"The boostrap classpath is empty in the section 'component' in the JBI descriptor.", (Object)jbiClassPathElts);
        Assert.assertNotEquals((String)"The boostrap classpath is empty in the section 'component' in the JBI descriptor.", (int)0, (int)jbiClassPathElts.size());
        for (String jbiClassPathElt : jbiClassPathElts) {
            Assert.assertFalse((String)"An empty classpath element exists in the bootstrap classpath in the JBI descriptor", (jbiClassPathElt.trim().length() == 0 ? 1 : 0) != 0);
        }
        jbiClassPath = jbiComponent.getComponentClassPath();
        Assert.assertNotNull((String)"The component classpath is missing in the section 'component' in the JBI descriptor.", (Object)jbiComponent);
        jbiClassPathElts = jbiClassPath.getPathElement();
        Assert.assertNotNull((String)"The component classpath is empty in the section 'component' in the JBI descriptor.", (Object)jbiClassPathElts);
        Assert.assertNotEquals((String)"The component classpath is empty in the section 'component' in the JBI descriptor.", (int)0, (int)jbiClassPathElts.size());
        for (String jbiClassPathElt : jbiClassPathElts) {
            Assert.assertFalse((String)"An empty classpath element exists in the component classpath in the JBI descriptor", (jbiClassPathElt.trim().length() == 0 ? 1 : 0) != 0);
        }
    }
}

