/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.plugin.jbiplugin;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.util.interpolation.MapBasedValueSource;
import org.codehaus.plexus.util.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.util.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.util.interpolation.ValueSource;
import org.ow2.petals.jbi.descriptor.original.generated.Component;
import org.ow2.petals.plugin.jbiplugin.JBIAbstractMojo;
import org.ow2.petals.plugin.jbiplugin.util.PropertiesInterpolationValueSource;

public abstract class JBIAbstractConfigurableMojo
extends JBIAbstractMojo {
    protected static final String JBIDESCRIPTOR_ZIPENTRY_NAME = "META-INF/jbi.xml";
    protected boolean includeConfiguration;
    protected String sharedLibraryNameMappingInComponent;
    protected String jbiIdentifiersMappingFile;
    protected URL jbiIdentifiersMappingFileURL;
    private final Properties jbiIdentifiersMappingExpressions = new Properties();
    protected String jbiSharedLibrariesMappingFile;
    protected URL jbiSharedLibrariesMappingFileURL;
    private final Properties jbiSharedLibrariesMappingExpressions = new Properties();
    protected String jbiVersionsMappingFile;
    protected URL jbiVersionsMappingFileURL;
    private final Properties jbiVersionsMappingExpressions = new Properties();
    protected String jbiExtraComponentClasspathMappingFile;
    protected URL jbiExtraComponentClasspathMappingFileURL;
    private final Properties jbiExtraComponentClasspathMappingExpressions = new Properties();
    protected String jbiExtraBootstrapClasspathMappingFile;
    protected URL jbiExtraBootstrapClasspathMappingFileURL;
    private final Properties jbiExtraBootstrapClasspathMappingExpressions = new Properties();

    protected String evaluateJBIIdentifier(String expression, Artifact artifact) throws MojoExecutionException {
        String artifactJBIIdentifier = null;
        if (this.includeConfiguration) {
            artifactJBIIdentifier = this.getJbiDescriptorValue(artifact, this.jbiIdentifiersMappingExpressions);
        }
        if (artifactJBIIdentifier == null) {
            artifactJBIIdentifier = this.evaluateFileNameMapping(expression, artifact);
        }
        return artifactJBIIdentifier;
    }

    protected String evaluateJBIVersion(String expression, Artifact artifact) throws MojoExecutionException {
        String artifactJBIIdentifier = null;
        if (this.includeConfiguration) {
            artifactJBIIdentifier = this.getJbiDescriptorValue(artifact, this.jbiVersionsMappingExpressions);
        }
        if (artifactJBIIdentifier == null) {
            artifactJBIIdentifier = this.evaluateFileNameMapping(expression, artifact);
        }
        return artifactJBIIdentifier;
    }

    protected List<Component.SharedLibrary> evaluateSharedLibraries(Artifact artifact) throws MojoExecutionException {
        List<Component.SharedLibrary> sharedLibraries = null;
        if (this.includeConfiguration) {
            this.debug("Use shared libraries defined at configuration level.");
            sharedLibraries = this.getSharedLibraries(artifact);
        }
        if (sharedLibraries == null) {
            this.debug("Use shared libraries defined at project level.");
            sharedLibraries = this.getSharedLibrariesFromProject();
        }
        return sharedLibraries;
    }

    protected final List<Artifact> evaluateBootstrapClasspathElts(Artifact artifact) throws MojoExecutionException {
        return this.evaluateClasspathElts(artifact, this.jbiExtraBootstrapClasspathMappingExpressions);
    }

    protected final List<Artifact> evaluateComponentClasspathElts(Artifact artifact) throws MojoExecutionException {
        return this.evaluateClasspathElts(artifact, this.jbiExtraComponentClasspathMappingExpressions);
    }

    private List<Artifact> evaluateClasspathElts(Artifact artifact, Properties extraClasspathMappingExpression) throws MojoExecutionException {
        try {
            LinkedList<Artifact> extraClasspathEltsAsArtifact = new LinkedList<Artifact>();
            if (this.includeConfiguration) {
                List<String> extraClasspathElts = JBIAbstractConfigurableMojo.getClasspathMappingExpression(artifact, extraClasspathMappingExpression);
                for (String extraClasspathElt : extraClasspathElts) {
                    StringTokenizer st = new StringTokenizer(extraClasspathElt, ":");
                    if (st.countTokens() < 3) {
                        throw new MojoExecutionException("Missing field in the extra classpath element definition, 3 fields are mandatory: " + extraClasspathElt);
                    }
                    String groupId = st.nextToken();
                    String artifactId = st.nextToken();
                    String version = st.nextToken();
                    String packaging = "jar";
                    try {
                        packaging = st.nextToken();
                    }
                    catch (NoSuchElementException e) {
                        // empty catch block
                    }
                    Artifact extraClasspathEltArtifact = this.artifactFactory.createDependencyArtifact(groupId, artifactId, VersionRange.createFromVersionSpec((String)version), packaging, null, null);
                    this.artifactResolver.resolve(extraClasspathEltArtifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
                    extraClasspathEltsAsArtifact.add(extraClasspathEltArtifact);
                    this.addClasspathEltDependencies(extraClasspathEltArtifact, extraClasspathEltsAsArtifact);
                }
            }
            return extraClasspathEltsAsArtifact;
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void addClasspathEltDependencies(Artifact extraClasspathEltArtifact, List<Artifact> extraClasspathEltsAsArtifact) throws ProjectBuildingException, ArtifactResolutionException, ArtifactNotFoundException, InvalidVersionSpecificationException {
        MavenProject dependencyProject = this.buildProjectFromArtifact(extraClasspathEltArtifact);
        List subDependencies = dependencyProject.getDependencies();
        for (Dependency dependencyDependency : subDependencies) {
            String scope = dependencyDependency.getScope();
            if (scope == null || !"test".equals(scope) && !"provided".equals(scope)) {
                this.debug("Required     : " + dependencyDependency.getGroupId() + ":" + dependencyDependency.getArtifactId() + ":" + dependencyDependency.getVersion() + " (transitive dependency of " + extraClasspathEltArtifact.getArtifactId() + ":" + extraClasspathEltArtifact.getVersion() + ")");
                Artifact dependencyArtifact = this.createDependencyArtifact(dependencyDependency);
                this.artifactResolver.resolve(dependencyArtifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
                extraClasspathEltsAsArtifact.add(dependencyArtifact);
                this.addClasspathEltDependencies(dependencyArtifact, extraClasspathEltsAsArtifact);
                continue;
            }
            this.debug("Not required : " + dependencyDependency.getGroupId() + ":" + dependencyDependency.getArtifactId() + ":" + dependencyDependency.getVersion() + " (transitive dependency of " + extraClasspathEltArtifact.getArtifactId() + ":" + extraClasspathEltArtifact.getVersion() + ")");
        }
    }

    protected abstract MavenProject getMavenProject();

    private String evaluateFileNameMapping(String expression, Artifact artifact) {
        Properties props = new Properties();
        String artifactVersion = artifact.getVersion();
        if (artifactVersion.contains(".")) {
            props.put("version.major", artifactVersion.substring(0, artifactVersion.indexOf(46)));
        } else if (artifactVersion.contains("-")) {
            props.put("version.major", artifactVersion.substring(artifactVersion.indexOf(45)));
        } else {
            props.put("version.major", artifactVersion);
        }
        return this.evaluateFileNameMapping(expression, artifact, props);
    }

    private String evaluateFileNameMapping(String expression, Artifact artifact, Properties properties) {
        this.debug("Evaluating expression: " + expression);
        String value = expression.replaceAll("\\$\\{dollarSign\\}", "\\$");
        artifact.isSnapshot();
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        if (artifact != null) {
            interpolator.addValueSource((ValueSource)new ObjectBasedValueSource((Object)artifact));
            interpolator.addValueSource((ValueSource)new ObjectBasedValueSource((Object)artifact.getArtifactHandler()));
        }
        if (properties != null) {
            interpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)properties));
        }
        Properties classifierMask = new Properties();
        classifierMask.setProperty("classifier", "");
        interpolator.addValueSource((ValueSource)new PropertiesInterpolationValueSource(classifierMask));
        value = interpolator.interpolate(value, "__artifact");
        this.debug("Expression evaluated to: " + value);
        return value;
    }

    private String getJbiDescriptorValue(Artifact artifact, Properties jbiMappingExpressions) throws MojoExecutionException {
        String res = null;
        String mappingExpr = JBIAbstractConfigurableMojo.getMappingExpression(artifact, jbiMappingExpressions);
        if (mappingExpr != null) {
            res = this.evaluateFileNameMapping(mappingExpr, artifact);
        }
        return res;
    }

    private List<Component.SharedLibrary> getSharedLibraries(Artifact artifact) throws MojoExecutionException {
        try {
            List<String> sharedLibrariesStr = this.getSharedLibrariesMappingExpression(artifact);
            if (sharedLibrariesStr != null) {
                ArrayList<Component.SharedLibrary> sharedLibraries = new ArrayList<Component.SharedLibrary>();
                for (String sharedLibraryStr : sharedLibrariesStr) {
                    StringTokenizer st = new StringTokenizer(sharedLibraryStr, ":");
                    if (st.countTokens() < 3) {
                        throw new MojoExecutionException("Missing field in the shared library definition, 3 fields are mandatory: " + sharedLibraryStr);
                    }
                    String groupId = st.nextToken();
                    String artifactId = st.nextToken();
                    String version = st.nextToken();
                    Artifact sharedLibraryArtifact = this.artifactFactory.createDependencyArtifact(groupId, artifactId, VersionRange.createFromVersionSpec((String)version), "jbi-shared-library", null, null);
                    sharedLibraries.add(this.artifactToSharedLibrary(sharedLibraryArtifact));
                }
                return sharedLibraries;
            }
            return null;
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private List<Component.SharedLibrary> getSharedLibrariesFromProject() throws MojoExecutionException {
        try {
            MavenProject artifactProject = this.getMavenProject();
            List<Artifact> slDependencies = this.getSharedLibraries(artifactProject);
            ArrayList<Component.SharedLibrary> sharedLibraries = new ArrayList<Component.SharedLibrary>();
            for (Artifact slDependency : slDependencies) {
                Artifact sharedLibraryArtifact = this.artifactFactory.createDependencyArtifact(slDependency.getGroupId(), slDependency.getArtifactId(), VersionRange.createFromVersionSpec((String)slDependency.getVersion()), "jbi-shared-library", null, null);
                sharedLibraries.add(this.artifactToSharedLibrary(sharedLibraryArtifact));
            }
            return sharedLibraries;
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected Component.SharedLibrary artifactToSharedLibrary(Artifact artifact) throws MojoExecutionException {
        Component.SharedLibrary sharedLibrary = new Component.SharedLibrary();
        String slContent = this.evaluateJBIIdentifier(this.sharedLibraryNameMappingInComponent, artifact);
        sharedLibrary.setContent(slContent);
        sharedLibrary.setVersion(this.evaluateJBIVersion(artifact.getVersion(), artifact));
        return sharedLibrary;
    }

    private static String getMappingExpression(Artifact artifact, Properties jbiMappingExpressions) throws MojoExecutionException {
        String[] artifactKeys;
        for (String artifactKey : artifactKeys = JBIAbstractConfigurableMojo.getArtifactPatternWithPackaging(artifact)) {
            if (!jbiMappingExpressions.containsKey(artifactKey)) continue;
            return jbiMappingExpressions.getProperty(artifactKey);
        }
        return null;
    }

    private List<String> getSharedLibrariesMappingExpression(Artifact artifact) throws MojoExecutionException {
        String[] artifactKeys = JBIAbstractConfigurableMojo.getArtifactPatternWithoutPackaging(artifact);
        ArrayList<String> sharedLibraries = new ArrayList<String>();
        for (String artifactKey : artifactKeys) {
            ArrayList<String> removedKeys = new ArrayList<String>();
            for (Object keyObj : this.jbiSharedLibrariesMappingExpressions.keySet()) {
                String key = (String)keyObj;
                if (!key.substring(0, key.lastIndexOf(58)).equals(artifactKey)) continue;
                sharedLibraries.add(this.jbiSharedLibrariesMappingExpressions.getProperty(key));
                removedKeys.add(key);
            }
            for (String key : removedKeys) {
                this.jbiSharedLibrariesMappingExpressions.remove(key);
            }
            removedKeys.clear();
        }
        return sharedLibraries.size() == 0 ? null : sharedLibraries;
    }

    private static final List<String> getClasspathMappingExpression(Artifact artifact, Properties extraClasspathMappingExpression) throws MojoExecutionException {
        String[] artifactKeys = JBIAbstractConfigurableMojo.getArtifactPatternWithoutPackaging(artifact);
        ArrayList<String> classpathElts = new ArrayList<String>();
        Properties localExtraClasspathMappingExpression = new Properties();
        localExtraClasspathMappingExpression.putAll((Map<?, ?>)extraClasspathMappingExpression);
        for (String artifactKey : artifactKeys) {
            ArrayList<String> removedKeys = new ArrayList<String>();
            for (Map.Entry<Object, Object> entry : localExtraClasspathMappingExpression.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.substring(0, key.lastIndexOf(58)).equals(artifactKey)) continue;
                classpathElts.add(localExtraClasspathMappingExpression.getProperty(key));
                removedKeys.add(key);
            }
            for (String key : removedKeys) {
                localExtraClasspathMappingExpression.remove(key);
            }
            removedKeys.clear();
        }
        return classpathElts;
    }

    private static String[] getArtifactPatternWithPackaging(Artifact artifact) {
        return new String[]{artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ":" + artifact.getType(), artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ":" + "*", artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + "*" + ":" + artifact.getType(), artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + "*" + ":" + "*", artifact.getGroupId() + ":" + "*" + ":" + artifact.getVersion() + ":" + artifact.getType(), artifact.getGroupId() + ":" + "*" + ":" + artifact.getVersion() + ":" + "*", artifact.getGroupId() + ":" + "*" + ":" + "*" + ":" + artifact.getType(), artifact.getGroupId() + ":" + "*" + ":" + "*" + ":" + "*", "*:" + artifact.getArtifactId() + ":" + artifact.getVersion() + ":" + artifact.getType(), "*:" + artifact.getArtifactId() + ":" + artifact.getVersion() + ":" + "*", "*:" + artifact.getArtifactId() + ":" + "*" + ":" + artifact.getType(), "*:" + artifact.getArtifactId() + ":" + "*" + ":" + "*", "*:*:" + artifact.getVersion() + ":" + artifact.getType(), "*:*:" + artifact.getVersion() + ":" + "*", "*:*:*:" + artifact.getType(), "*:*:*:*"};
    }

    private static String[] getArtifactPatternWithoutPackaging(Artifact artifact) {
        return new String[]{artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion(), artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion(), artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + "*", artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + "*", artifact.getGroupId() + ":" + "*" + ":" + artifact.getVersion(), artifact.getGroupId() + ":" + "*" + ":" + artifact.getVersion(), artifact.getGroupId() + ":" + "*" + ":" + "*", artifact.getGroupId() + ":" + "*" + ":" + "*", "*:" + artifact.getArtifactId() + ":" + artifact.getVersion(), "*:" + artifact.getArtifactId() + ":" + artifact.getVersion(), "*:" + artifact.getArtifactId() + ":" + "*", "*:" + artifact.getArtifactId() + ":" + "*", "*:*:" + artifact.getVersion(), "*:*:" + artifact.getVersion(), "*:*:*", "*:*:*"};
    }

    protected void readConfigurationFiles() throws MojoExecutionException {
        this.readJbiIdentifiersMappingFile();
        this.readJbiSharedLibrariesMappingFile();
        this.readJbiVersionsMappingFile();
        this.readJbiExtraComponentClasspathMappingFile();
        this.readJbiExtraBootstrapClasspathMappingFile();
    }

    private void readJbiIdentifiersMappingFile() throws MojoExecutionException {
        try {
            this.debug("JBI identifiers mapping configuration file: " + this.jbiIdentifiersMappingFile);
            InputStream isJbiIdentifiersMappingFile = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.jbiIdentifiersMappingFile);
            if (isJbiIdentifiersMappingFile == null) {
                this.debug("JBI identifiers mapping configuration URL: " + this.jbiIdentifiersMappingFileURL);
                if (this.jbiIdentifiersMappingFileURL != null) {
                    isJbiIdentifiersMappingFile = this.jbiIdentifiersMappingFileURL.openStream();
                }
            }
            if (isJbiIdentifiersMappingFile == null) {
                this.info("JBI identifiers mapping files not found: " + this.jbiIdentifiersMappingFile + ", URL: " + this.jbiIdentifiersMappingFileURL);
            } else {
                this.jbiIdentifiersMappingExpressions.load(isJbiIdentifiersMappingFile);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void readJbiSharedLibrariesMappingFile() throws MojoExecutionException {
        try {
            this.debug("JBI shared libraries mapping configuration file: " + this.jbiSharedLibrariesMappingFile);
            InputStream isJbiSharedLibrariesMappingFile = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.jbiSharedLibrariesMappingFile);
            if (isJbiSharedLibrariesMappingFile == null) {
                this.debug("JBI shared libraries mapping configuration URL: " + this.jbiSharedLibrariesMappingFileURL);
                if (this.jbiSharedLibrariesMappingFileURL != null) {
                    isJbiSharedLibrariesMappingFile = this.jbiSharedLibrariesMappingFileURL.openStream();
                }
            }
            if (isJbiSharedLibrariesMappingFile == null) {
                this.info("JBI shared libraries mapping files not found: " + this.jbiIdentifiersMappingFile + ", URL: " + this.jbiSharedLibrariesMappingFileURL);
            } else {
                this.jbiSharedLibrariesMappingExpressions.load(isJbiSharedLibrariesMappingFile);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void readJbiVersionsMappingFile() throws MojoExecutionException {
        try {
            this.debug("JBI versions mapping configuration file: " + this.jbiVersionsMappingFile);
            InputStream isJbiVersionsMappingFile = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.jbiVersionsMappingFile);
            if (isJbiVersionsMappingFile == null) {
                this.debug("JBI versions mapping configuration URL: " + this.jbiVersionsMappingFileURL);
                if (this.jbiVersionsMappingFileURL != null) {
                    isJbiVersionsMappingFile = this.jbiVersionsMappingFileURL.openStream();
                }
            }
            if (isJbiVersionsMappingFile == null) {
                this.info("JBI versions mapping files not found: " + this.jbiVersionsMappingFile + ", URL: " + this.jbiVersionsMappingFileURL);
            } else {
                this.jbiVersionsMappingExpressions.load(isJbiVersionsMappingFile);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void readJbiExtraComponentClasspathMappingFile() throws MojoExecutionException {
        try {
            this.debug("Extra component classpath elements list mapping configuration file: " + this.jbiExtraComponentClasspathMappingFile);
            InputStream isExtraComponentClasspathMappingFile = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.jbiExtraComponentClasspathMappingFile);
            if (isExtraComponentClasspathMappingFile == null) {
                this.debug("Extra component classpath elements list mapping configuration URL: " + this.jbiExtraComponentClasspathMappingFileURL);
                if (this.jbiExtraComponentClasspathMappingFileURL != null) {
                    isExtraComponentClasspathMappingFile = this.jbiExtraComponentClasspathMappingFileURL.openStream();
                }
            }
            if (isExtraComponentClasspathMappingFile == null) {
                this.info("Extra component classpath elements list mapping configuration files not found: " + this.jbiExtraComponentClasspathMappingFile + ", URL: " + this.jbiExtraComponentClasspathMappingFileURL);
            } else {
                this.jbiExtraComponentClasspathMappingExpressions.load(isExtraComponentClasspathMappingFile);
                if (this.jbiExtraComponentClasspathMappingExpressions.size() > 0) {
                    this.debug("Extra component classpath: " + this.jbiExtraComponentClasspathMappingExpressions.toString());
                    JBIAbstractConfigurableMojo.checkExpressionKeysArtifactWithOrder(this.jbiExtraComponentClasspathMappingExpressions);
                } else {
                    this.warn("The extra component classpath elements list mapping configuration is empty.");
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void readJbiExtraBootstrapClasspathMappingFile() throws MojoExecutionException {
        try {
            this.debug("Extra bootstrap classpath elements list mapping configuration file: " + this.jbiExtraBootstrapClasspathMappingFile);
            InputStream isExtraBootstrapClasspathMappingFile = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.jbiExtraBootstrapClasspathMappingFile);
            if (isExtraBootstrapClasspathMappingFile == null) {
                this.debug("Extra bootstrap classpath elements list mapping configuration URL: " + this.jbiExtraBootstrapClasspathMappingFileURL);
                if (this.jbiExtraBootstrapClasspathMappingFileURL != null) {
                    isExtraBootstrapClasspathMappingFile = this.jbiExtraBootstrapClasspathMappingFileURL.openStream();
                }
            }
            if (isExtraBootstrapClasspathMappingFile == null) {
                this.info("Extra bootstrap classpath elements list mapping configuration files not found: " + this.jbiExtraBootstrapClasspathMappingFile + ", URL: " + this.jbiExtraBootstrapClasspathMappingFileURL);
            } else {
                this.jbiExtraBootstrapClasspathMappingExpressions.load(isExtraBootstrapClasspathMappingFile);
                if (this.jbiExtraBootstrapClasspathMappingExpressions.size() > 0) {
                    this.debug("Extra bootstrap classpath: " + this.jbiExtraBootstrapClasspathMappingExpressions.toString());
                    JBIAbstractConfigurableMojo.checkExpressionKeysArtifactWithOrder(this.jbiExtraBootstrapClasspathMappingExpressions);
                } else {
                    this.warn("The extra bootstrap classpath elements list mapping configuration is empty.");
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private static final void checkExpressionKeysArtifactWithOrder(Properties expressionValues) throws MojoExecutionException {
        for (Map.Entry<Object, Object> entry : expressionValues.entrySet()) {
            String key = (String)entry.getKey();
            StringTokenizer st = new StringTokenizer(key, ":");
            if (st.countTokens() < 4) {
                throw new MojoExecutionException("Missing field in the extra classpath element key, 4 fields are mandatory for entry: " + key + "=" + entry.getValue().toString());
            }
            st.nextToken();
            st.nextToken();
            st.nextToken();
            try {
                Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException e) {
                throw new MojoExecutionException("Ordering number field of the extra classpath element key is not a number (entry: " + key + "=" + entry.getValue().toString() + ").");
            }
        }
    }
}

