/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.plugin.jbiplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.maven.plugin.MojoExecutionException;
import org.ow2.petals.jbi.descriptor.original.generated.Component;
import org.ow2.petals.jbi.descriptor.original.generated.Identification;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.descriptor.original.generated.ServiceAssembly;
import org.ow2.petals.jbi.descriptor.original.generated.ServiceUnit;
import org.ow2.petals.jbi.descriptor.original.generated.Target;
import org.ow2.petals.plugin.jbiplugin.JBIAbstractMojo;

public abstract class JBIAbstractJMXMojo
extends JBIAbstractMojo {
    protected String host;
    protected Integer port;
    protected String username;
    protected String password;
    protected Boolean force;
    protected Logger log = Logger.getLogger(JBIAbstractJMXMojo.class.getName());

    protected String getComponentNameFromJBIDescriptor(Jbi jbiDescriptor) throws MojoExecutionException {
        Component componentDescription = jbiDescriptor.getComponent();
        if (componentDescription == null) {
            throw new MojoExecutionException("JBI Component descriptor is null");
        }
        Identification identification = componentDescription.getIdentification();
        if (identification == null) {
            throw new MojoExecutionException("JBI Component descriptor: <identification> is null");
        }
        return identification.getName();
    }

    protected String getServiceAssemblyNameFromJBIDescriptor(Jbi jbiDescriptor) throws MojoExecutionException {
        ServiceAssembly serviceAssemblyDescription = jbiDescriptor.getServiceAssembly();
        if (serviceAssemblyDescription == null) {
            throw new MojoExecutionException("JBI Service assembly descriptor is null");
        }
        Identification identification = serviceAssemblyDescription.getIdentification();
        if (identification == null) {
            throw new MojoExecutionException("JBI Service assembly descriptor: <identification> is null");
        }
        return identification.getName();
    }

    protected String getSharedLibraryNameFromJBIDescriptor(Jbi jbiDescriptor) throws MojoExecutionException {
        Jbi.SharedLibrary sharedLibraryDescription = jbiDescriptor.getSharedLibrary();
        if (sharedLibraryDescription == null) {
            throw new MojoExecutionException("JBI Service assembly descriptor is null");
        }
        Identification identification = sharedLibraryDescription.getIdentification();
        if (identification == null) {
            throw new MojoExecutionException("JBI Shared-library descriptor: <identification> is null");
        }
        return identification.getName();
    }

    protected List<String> getComponentsFromServiceAssemblyJBIDescriptor(Jbi jbiDescriptor) throws MojoExecutionException {
        ServiceAssembly serviceAssemblyDescription = jbiDescriptor.getServiceAssembly();
        if (serviceAssemblyDescription == null) {
            throw new MojoExecutionException("JBI Service assembly descriptor is null");
        }
        ArrayList<String> usedComponents = new ArrayList<String>();
        List serviceUnits = serviceAssemblyDescription.getServiceUnit();
        for (ServiceUnit serviceUnit : serviceUnits) {
            Target target = serviceUnit.getTarget();
            String componentName = target.getComponentName();
            if (usedComponents.contains(componentName)) continue;
            usedComponents.add(componentName);
        }
        return usedComponents;
    }

    protected List<String> getSharedLibrariesFromComponentJBIDescriptor(Jbi jbiDEscriptor) throws MojoExecutionException {
        Component componentDescription = jbiDEscriptor.getComponent();
        if (componentDescription == null) {
            throw new MojoExecutionException("JBI component descriptor is null");
        }
        ArrayList<String> usedSharedLibraies = new ArrayList<String>();
        List sharedLibraries = componentDescription.getSharedLibraryList();
        for (Component.SharedLibrary sharedLibrary : sharedLibraries) {
            String sharedLibraryName = sharedLibrary.getContent();
            if (usedSharedLibraies.contains(sharedLibraryName)) continue;
            usedSharedLibraies.add(sharedLibraryName);
        }
        return usedSharedLibraies;
    }
}

