/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.plugin.jbiplugin;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jmx.ComponentClient;
import org.ow2.petals.jmx.DeploymentServiceClient;
import org.ow2.petals.jmx.JMXClient;
import org.ow2.petals.jmx.exception.ComponentDoesNotExistException;
import org.ow2.petals.jmx.exception.ComponentErrorException;
import org.ow2.petals.jmx.exception.ConnectionErrorException;
import org.ow2.petals.jmx.exception.DeploymentServiceDoesNotExistException;
import org.ow2.petals.jmx.exception.DeploymentServiceErrorException;
import org.ow2.petals.plugin.jbiplugin.JBIAbstractJMXMojo;

public class JBIStartMojo
extends JBIAbstractJMXMojo {
    @Override
    public void executeMojo() throws MojoExecutionException, MojoFailureException {
        try {
            File artifactFile = this.project.getArtifact().getFile();
            if (artifactFile == null) {
                this.attachedJBIArchive(this.project.getArtifact());
            }
            Jbi jbiDescriptor = this.readJbiDescriptor(this.project.getArtifact());
            this.getLog().info((CharSequence)("Using JMX Petals server located at: " + this.host + ":" + this.port));
            JMXClient petalsJMXClient = new JMXClient(this.host, this.port, this.username, this.password);
            if ("jbi-component".equals(this.project.getPackaging())) {
                this.startComponent(petalsJMXClient, jbiDescriptor);
            } else if ("jbi-service-assembly".equals(this.project.getPackaging())) {
                this.startServiceAssembly(petalsJMXClient, jbiDescriptor);
            } else if ("jbi-service-unit".equals(this.project.getPackaging())) {
                this.info("Start a service-unit has no sens. This goal is skipped.");
            } else if ("jbi-shared-library".equals(this.project.getPackaging())) {
                this.info("Start a shared-libarary has no sens. This goal is skipped.");
            }
        }
        catch (ConnectionErrorException e) {
            throw new MojoExecutionException("Error", (Exception)((Object)e));
        }
    }

    private void startComponent(JMXClient petalsJMXClient, Jbi jbiDescriptor) throws MojoExecutionException {
        try {
            String componentName = this.getComponentNameFromJBIDescriptor(jbiDescriptor);
            ComponentClient pccc = null;
            pccc = petalsJMXClient.getComponentClient(componentName);
            if ("Started".equals(pccc.getState())) {
                throw new MojoExecutionException("The component is already started.");
            }
            if ("Shutdown".equals(pccc.getState()) || "Stopped".equals(pccc.getState())) {
                this.info("Starting the component.");
                pccc.start();
                this.info("The component is started.");
            }
        }
        catch (ComponentDoesNotExistException e1) {
            throw new MojoExecutionException("The component is not installed.");
        }
        catch (ComponentErrorException e) {
            throw new MojoExecutionException("Error", (Exception)((Object)e));
        }
        catch (ConnectionErrorException e) {
            throw new MojoExecutionException("Error", (Exception)((Object)e));
        }
    }

    private void startServiceAssembly(JMXClient petalsJMXClient, Jbi jbiDescriptor) throws MojoExecutionException {
        block7: {
            try {
                String serviceAssemblyName = this.getServiceAssemblyNameFromJBIDescriptor(jbiDescriptor);
                DeploymentServiceClient pdsc = petalsJMXClient.getDeploymentServiceClient();
                this.info("Checking service assembly state.");
                if (pdsc.isServiceAssemblyDeployed(serviceAssemblyName)) {
                    this.info("The service assembly is deployed.");
                    if ("Shutdown".equals(pdsc.getState(serviceAssemblyName)) || "Stopped".equals(pdsc.getState(serviceAssemblyName))) {
                        this.info("Starting the service assembly.");
                        String result = pdsc.start(serviceAssemblyName);
                        this.info("The service assembly is started: " + result);
                        break block7;
                    }
                    if ("Started".equals(pdsc.getState(serviceAssemblyName))) {
                        this.info("The service assembly is already started.");
                        break block7;
                    }
                    throw new MojoExecutionException("Error, the service assembly " + serviceAssemblyName + " is in the following state: " + pdsc.getState(serviceAssemblyName));
                }
                throw new MojoExecutionException("The service-assembly " + serviceAssemblyName + " is not deployed.");
            }
            catch (DeploymentServiceDoesNotExistException e) {
                throw new MojoExecutionException("Error", (Exception)((Object)e));
            }
            catch (DeploymentServiceErrorException e) {
                throw new MojoExecutionException("Error", (Exception)((Object)e));
            }
            catch (ConnectionErrorException e) {
                throw new MojoExecutionException("Error", (Exception)((Object)e));
            }
        }
    }
}

