/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.plugin.jbiplugin.util;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;

public class ZipUtil {
    private ZipUtil() {
    }

    public static final void addFile(ZipOutputStream zipOutputStream, InputStream inputStream, String zipEntryName) throws IOException {
        ZipEntry zipEntry = new ZipEntry(zipEntryName);
        ZipUtil.putFileEntry(zipOutputStream, inputStream, zipEntry);
    }

    public static final void addFile(ZipOutputStream zipOutputStream, InputStream inputStream, String zipEntryName, long zipEntryTime) throws IOException {
        ZipEntry zipEntry = new ZipEntry(zipEntryName);
        zipEntry.setTime(zipEntryTime);
        ZipUtil.putFileEntry(zipOutputStream, inputStream, zipEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void putFileEntry(ZipOutputStream zipOutputStream, InputStream inputStream, ZipEntry zipEntry) throws IOException {
        DataInputStream dis = new DataInputStream(inputStream);
        try {
            byte[] content = new byte[dis.available()];
            dis.readFully(content);
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(content);
            zipOutputStream.closeEntry();
        }
        finally {
            dis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyAndUpdateZipFile(ZipFile zipInputFile, ZipOutputStream zipOutputStream, ZipEntryCallback callback) throws IOException, MojoExecutionException {
        Enumeration<? extends ZipEntry> zipEntries = zipInputFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            ZipEntry newZipEntry = new ZipEntry(zipEntry.getName());
            newZipEntry.setComment(zipEntry.getComment());
            newZipEntry.setTime(zipEntry.getTime());
            ZipUtil.putFileEntry(zipOutputStream, callback.onZipEntry(newZipEntry, zipInputFile.getInputStream(zipEntry)), newZipEntry);
        }
        for (Artifact newArtifact : callback.getExtraEntryToAdd()) {
            ZipEntry newZipEntry = new ZipEntry(newArtifact.getFile().getName());
            newZipEntry.setComment("");
            newZipEntry.setTime(newArtifact.getFile().lastModified());
            FileInputStream isArtifact = new FileInputStream(newArtifact.getFile());
            try {
                ZipUtil.putFileEntry(zipOutputStream, isArtifact, newZipEntry);
            }
            finally {
                ((InputStream)isArtifact).close();
            }
        }
    }

    public static final void addDirectory(ZipOutputStream zipOutputStream, String zipEntryName) throws IOException {
        ZipEntry zipEntry = new ZipEntry(zipEntryName + "/");
        ZipUtil.putDirectoryEntry(zipOutputStream, zipEntry);
    }

    private static void putDirectoryEntry(ZipOutputStream zipOutputStream, ZipEntry zipEntry) throws IOException {
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.closeEntry();
    }

    public static interface ZipEntryCallback {
        public InputStream onZipEntry(ZipEntry var1, InputStream var2) throws IOException, MojoExecutionException;

        public List<Artifact> getExtraEntryToAdd();
    }
}

