/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.notification;

import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.notification.NotificationBrokerController;
import org.ow2.petals.component.framework.api.notification.StatusListener;
import org.ow2.petals.component.framework.jbidescriptor.generated.Component;
import org.ow2.petals.component.framework.notification.AsyncSender;
import org.ow2.petals.component.framework.notification.ComponentNotificationBrokerController;
import org.ow2.petals.component.framework.notification.NotificationContext;
import org.ow2.petals.component.framework.notification.NotificationStorageService;
import org.ow2.petals.component.framework.notification.Sender;
import org.ow2.petals.component.framework.notification.WrappedSender;
import org.ow2.petals.component.framework.util.UtilFactory;

public class NotificationService
implements org.ow2.petals.component.framework.api.notification.NotificationService {
    private final AbstractComponent component;
    private final NotificationContext notificationContext;
    private NotificationStorageService notificationStorageService;
    private Set<StatusListener> statusListeners;
    @Deprecated
    protected NotificationBrokerController notificationBrokerController;
    private Map<String, ServiceEndpoint> endpointCache;
    private final Logger logger;
    private boolean active;
    private WrappedSender sender;

    public NotificationService(AbstractComponent component) throws WSNotificationException, MessagingException {
        this.component = component;
        this.notificationContext = new NotificationContext();
        this.logger = this.component.getLogger();
        this.statusListeners = new HashSet<StatusListener>();
    }

    public void init() throws PEtALSCDKException {
        this.endpointCache = new HashMap<String, ServiceEndpoint>();
        Component componentDescriptor = this.component.getComponentConfiguration();
        if (componentDescriptor.getNotifRetryPolicyMax() != null) {
            this.notificationContext.setMaxDelay(componentDescriptor.getNotifRetryPolicyMax().getValue());
        }
        if (componentDescriptor.getNotifRetryPolicyMin() != null) {
            this.notificationContext.setMinDelay(componentDescriptor.getNotifRetryPolicyMin().getValue());
        }
        if (componentDescriptor.getNotifRetryPolicyFactor() != null) {
            this.notificationContext.setDelayFactor(componentDescriptor.getNotifRetryPolicyFactor().getValue());
        }
        if (componentDescriptor.getNotifRetryPolicyFactor() != null) {
            this.notificationContext.setNbRetry(componentDescriptor.getNotifRetryPolicyNb().getValue());
        }
        try {
            this.notificationStorageService = new NotificationStorageService(this.component.getContext().getWorkspaceRoot(), new Sender(this.component.getContext()), this.notificationContext, this.logger);
            this.notificationStorageService.init();
        }
        catch (Exception e) {
            throw new PEtALSCDKException("Can't init notification storage service", (Throwable)e);
        }
        try {
            this.sender = new WrappedSender(this.component.getContext(), this, this.notificationStorageService, this.notificationContext, this.logger);
            this.sender.init();
        }
        catch (Exception e) {
            throw new PEtALSCDKException("Can't init notification sender", (Throwable)e);
        }
        this.active = this.component != null && this.component.getComponentConfiguration().getNotifications() != null && this.component.getComponentConfiguration().getNotifications().isValue();
        try {
            this.notificationBrokerController = new ComponentNotificationBrokerController(this.logger, this.component.getContext(), this);
        }
        catch (Exception e) {
            throw new PEtALSCDKException((Throwable)e);
        }
    }

    public void start() throws PEtALSCDKException {
        this.logger.fine("Starting the notification service");
        this.notificationStorageService.start();
        this.sender.start();
        if (!this.active) {
            this.logger.fine("Notification feature is not active");
            return;
        }
        this.activate();
    }

    public void stop() throws PEtALSCDKException {
        this.logger.fine("Stopping the notification service");
        this.notificationStorageService.stop();
        this.unactivate();
        this.sender.stop();
    }

    public NotificationBrokerController getNotificationBrokerController() {
        return this.notificationBrokerController;
    }

    protected void unregisterFromBroker() throws PEtALSCDKException {
        if (!this.active) {
            this.logger.fine("Notifications are not active, do not unregister on broker");
            return;
        }
        if (this.notificationBrokerController != null) {
            try {
                this.notificationBrokerController.destroyRegistration();
            }
            catch (Exception e) {
                this.logger.warning("unable to destroy the registration of the publisher: the broker could try to send me subscriptions");
                this.logger.fine("detail on the error: " + e.getMessage());
            }
        }
    }

    protected void registerNotificationPublisherOnBroker() throws PEtALSCDKException {
        if (this.notificationBrokerController != null) {
            try {
                this.notificationBrokerController.registerPublisher();
            }
            catch (Exception e) {
                this.logger.warning("unable to register the publisher: no notification will be sent");
                this.logger.fine("detail on the error: " + e.getMessage());
                this.notificationBrokerController = null;
            }
        }
    }

    public NotificationContext getNotificationContext() {
        return this.notificationContext;
    }

    public WrappedSender getSender() {
        return this.sender;
    }

    public org.ow2.petals.component.framework.api.notification.AsyncSender getAsyncSender(StatusListener listener) {
        return new AsyncSender(this.getSender(), listener);
    }

    public synchronized void setActive(boolean status) throws PEtALSCDKException {
        if (status && !this.active) {
            this.activate();
        } else if (this.active && !status) {
            this.unactivate();
        } else {
            this.logger.fine("Incoherent setActive change");
        }
        if (this.active != status) {
            this.active = status;
        }
    }

    private void activate() throws PEtALSCDKException {
        this.activateEndpoints();
        this.restorePreviousState();
    }

    private void restorePreviousState() throws PEtALSCDKException {
        RegisterPublisherResponse publisherReg;
        try {
            publisherReg = this.notificationStorageService.restorePublisherRegistration();
        }
        catch (WSNotificationException e) {
            throw new PEtALSCDKException((Throwable)e);
        }
        if (publisherReg != null) {
            this.notificationBrokerController.processRegisterPublisherResponse(publisherReg);
        } else {
            this.registerNotificationPublisherOnBroker();
        }
    }

    private void activateEndpoints() throws PEtALSCDKException {
        QName serviceName = null;
        String endpointName = null;
        ServiceEndpoint se = null;
        List endpointList = null;
        try {
            if (this.getNotificationBrokerController() != null) {
                Endpoint endpoint;
                Iterator iterator;
                if (this.getNotificationBrokerController().getNotificationProducer() != null && (endpointList = UtilFactory.getWSDLUtil().getEndpointList(this.getNotificationBrokerController().getNotificationProducer().getWsdl().getDescription())) != null && (iterator = endpointList.iterator()) != null) {
                    while (iterator.hasNext()) {
                        endpoint = (Endpoint)iterator.next();
                        if (endpoint == null) continue;
                        serviceName = ((Service)endpoint.getService()).getQName();
                        endpointName = endpoint.getName();
                        se = this.component.activateEndpoint(serviceName, endpointName);
                        this.endpointCache.put(endpointName, se);
                    }
                }
                if (this.getNotificationBrokerController().getNotificationConsumer() != null && (endpointList = UtilFactory.getWSDLUtil().getEndpointList(this.getNotificationBrokerController().getNotificationConsumer().getWsdl().getDescription())) != null && (iterator = endpointList.iterator()) != null) {
                    while (iterator.hasNext()) {
                        endpoint = (Endpoint)iterator.next();
                        if (endpoint == null) continue;
                        serviceName = ((Service)endpoint.getService()).getQName();
                        endpointName = endpoint.getName();
                        se = this.component.activateEndpoint(serviceName, endpointName);
                        this.endpointCache.put(endpointName, se);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new PEtALSCDKException("Unable to activate the notification endpoints managed by the component", (Throwable)e);
        }
    }

    private void unactivate() throws PEtALSCDKException {
        this.unregisterFromBroker();
        this.deactivateEndpoints();
    }

    private void deactivateEndpoints() throws PEtALSCDKException {
        for (ServiceEndpoint serviceEndpoint : this.endpointCache.values()) {
            this.deactivateEndpoint(serviceEndpoint);
        }
    }

    private void deactivateEndpoint(ServiceEndpoint serviceEndpoint) throws PEtALSCDKException {
        try {
            this.component.deactivateEndpoint(serviceEndpoint);
        }
        catch (JBIException e) {
            throw new PEtALSCDKException("Can not deactivate notification endpoint", (Throwable)e);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void addListener(StatusListener listener) {
        if (listener != null) {
            this.statusListeners.add(listener);
        }
    }

    public void onRegistered(RegisterPublisherResponse response) {
        for (StatusListener listener : this.statusListeners) {
            try {
                listener.onRegistered(response);
            }
            catch (PEtALSCDKException e) {
                this.logger.log(Level.WARNING, "Listener raised an exception on onRegistered call", e);
            }
        }
    }

    public void onUnregistered(DestroyRegistrationResponse response) {
        for (StatusListener listener : this.statusListeners) {
            try {
                listener.onUnregistered(response);
            }
            catch (PEtALSCDKException e) {
                this.logger.log(Level.WARNING, "Listener raised an exception on onUnregistered call", e);
            }
        }
    }

    public void onSubscribed(SubscribeResponse response) throws PEtALSCDKException {
        for (StatusListener listener : this.statusListeners) {
            try {
                listener.onSubscribed(response);
            }
            catch (PEtALSCDKException e) {
                this.logger.log(Level.WARNING, "Listener raised an exception on onSubscribed call", e);
            }
        }
    }

    public void onUnsubscribed(UnsubscribeResponse response) throws PEtALSCDKException {
        for (StatusListener listener : this.statusListeners) {
            try {
                listener.onUnsubscribed(response);
            }
            catch (PEtALSCDKException e) {
                this.logger.log(Level.WARNING, "Listener raised an exception on onUnsubscribed call", e);
            }
        }
    }

    public void onException(Exception e) {
        for (StatusListener listener : this.statusListeners) {
            listener.onException(e);
        }
    }

    public NotificationStorageService getNotificationStorageService() {
        return this.notificationStorageService;
    }
}

