/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.process;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.petals.component.framework.AbstractComponent;

public class JBIProcessorThreadFactory
implements ThreadFactory {
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String componentName;
    private final AbstractComponent component;
    private final Logger logger;

    public JBIProcessorThreadFactory(AbstractComponent component, Logger logger) {
        this.component = component;
        this.componentName = this.component.getComponentConfiguration().getIdentification().getName();
        this.logger = logger;
    }

    @Override
    public Thread newThread(Runnable r) {
        String name = this.componentName + " - MessageExchange Processor thread #" + Integer.toString(this.threadNumber.getAndIncrement());
        this.logger.log(Level.FINE, "Creating new JBI Processor Thread : " + name);
        return new Thread(Thread.currentThread().getThreadGroup(), r, name);
    }
}

