/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.process;

import java.util.logging.Logger;
import org.apache.commons.pool.PoolableObjectFactory;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;
import org.ow2.petals.component.framework.process.MessageExchangeProcessor;
import org.ow2.petals.component.framework.util.StringHelper;

public class MessageExchangeProcessorObjectFactory
implements PoolableObjectFactory {
    private final AbstractComponent component;
    private final Logger logger;

    public MessageExchangeProcessorObjectFactory(AbstractComponent component, Logger logger) {
        this.component = component;
        this.logger = logger;
    }

    public void activateObject(Object arg0) throws Exception {
    }

    public void destroyObject(Object arg0) throws Exception {
    }

    public Object makeObject() throws Exception {
        AbstractJBIListener jbiListener = this.createAndInitJBIListener();
        MessageExchangeProcessor jbiProcessor = new MessageExchangeProcessor(this.component, jbiListener, this.logger);
        return jbiProcessor;
    }

    public void passivateObject(Object arg0) throws Exception {
    }

    public boolean validateObject(Object arg0) {
        return true;
    }

    private AbstractJBIListener createAndInitJBIListener() throws PEtALSCDKException {
        AbstractJBIListener jbiListener;
        String jbiListenerClassNameValue = this.component.getComponentConfiguration().getJbiListenerClassName();
        String jbiListenerClassName = jbiListenerClassNameValue.replaceAll("\\s", "");
        if (!StringHelper.isNullOrEmpty(jbiListenerClassName)) {
            try {
                ClassLoader componentClassLoader = this.getClass().getClassLoader();
                Class<?> clazz = componentClassLoader.loadClass(jbiListenerClassName);
                jbiListener = (AbstractJBIListener)clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new PEtALSCDKException("Can't instanciate JBIListener : " + jbiListenerClassName, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new PEtALSCDKException("Can't instanciate JBIListener : " + jbiListenerClassName, (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new PEtALSCDKException("Can't find JBIListener class : " + jbiListenerClassName, (Throwable)e);
            }
        } else {
            throw new PEtALSCDKException("JBIListener class name can not be empty");
        }
        jbiListener.init(this.component);
        jbiListener.init();
        return jbiListener;
    }
}

