/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.databinding.jaxb.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.ow2.petals.databinding.jaxb.DataBindingException;
import org.ow2.petals.databinding.jaxb.service.Message;
import org.ow2.petals.databinding.jaxb.service.Operation;
import org.ow2.petals.databinding.jaxb.tools.Util;
import org.w3c.dom.Document;

public class ServiceUnmarshaller {
    private ClassLoader serviceClassLoader;
    private ClassLoader jaxbClassLoader;

    public Object[] unmarshallMethodParam(Operation serviceOperation, Source source) throws DataBindingException {
        Object[] methodParams = null;
        try {
            Message inputMessage = serviceOperation.getInputMessage();
            Unmarshaller unmarshaller = serviceOperation.getServiceOfOperation().getRegistry().getUnmarshaller(inputMessage.getMessageTypeName().getNamespaceURI());
            Object jaxbMessageObject = null;
            try {
                jaxbMessageObject = source instanceof StreamSource ? unmarshaller.unmarshal(((StreamSource)source).getInputStream()) : unmarshaller.unmarshal(source);
            }
            catch (UnmarshalException e) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                StreamResult result = new StreamResult(outputStream);
                TransformerFactory tsfF = TransformerFactory.newInstance();
                Transformer trsf = tsfF.newTransformer();
                trsf.transform(source, result);
                jaxbMessageObject = unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
            }
            if (jaxbMessageObject instanceof JAXBElement) {
                JAXBElement jaxbElement = (JAXBElement)jaxbMessageObject;
                jaxbMessageObject = jaxbElement.getValue();
            }
            if (serviceOperation.getParameterTypes() != null && serviceOperation.getParameterTypes().length == 1 && serviceOperation.getParameterTypes()[0].getName().equalsIgnoreCase(inputMessage.getMessageJaxbClass().getName())) {
                return new Object[]{this.createOriginalBean(jaxbMessageObject, serviceOperation.getParameterTypes()[0])};
            }
            Map<String, Class<?>> messageParts = inputMessage.getMessageParts();
            methodParams = new Object[inputMessage.getMessageParts().size()];
            Class<?> messageJaxbClass = jaxbMessageObject.getClass();
            Class<?>[] methodParamTypes = serviceOperation.getParameterTypes();
            Type[] genericParamTypes = serviceOperation.getGenericParameterTypes();
            int paramIndex = 0;
            for (String messgePartName : messageParts.keySet()) {
                Comparable<Calendar> date;
                XMLGregorianCalendar jaxbDate;
                Method getValueMethod;
                String getValueMethodName;
                Field field = messageJaxbClass.getDeclaredField(messgePartName);
                String getterMethodName = null;
                getterMethodName = !field.getType().equals(Boolean.TYPE) && !field.getType().equals(Boolean.class) ? "get" + Util.upperFirstCase(messgePartName) : "is" + Util.upperFirstCase(messgePartName);
                Method getterMethod = messageJaxbClass.getDeclaredMethod(getterMethodName, new Class[0]);
                if (methodParamTypes[paramIndex].isPrimitive() || Util.isSimpleType(methodParamTypes[paramIndex])) {
                    getValueMethodName = "getValue";
                    getValueMethod = null;
                    if (field.getType().equals(JAXBElement.class)) {
                        getValueMethod = field.getType().getDeclaredMethod(getValueMethodName, new Class[0]);
                        methodParams[paramIndex] = getValueMethod.invoke(getterMethod.invoke(jaxbMessageObject, new Object[0]), new Object[0]);
                    } else {
                        methodParams[paramIndex] = getterMethod.invoke(jaxbMessageObject, new Object[0]);
                    }
                } else if (methodParamTypes[paramIndex].getName().equals("java.util.Calendar")) {
                    getValueMethodName = "getValue";
                    getValueMethod = null;
                    if (field.getType().equals(JAXBElement.class)) {
                        getValueMethod = field.getType().getDeclaredMethod(getValueMethodName, new Class[0]);
                        jaxbDate = (XMLGregorianCalendar)getValueMethod.invoke(getterMethod.invoke(jaxbMessageObject, new Object[0]), new Object[0]);
                    } else {
                        jaxbDate = (XMLGregorianCalendar)getterMethod.invoke(jaxbMessageObject, new Object[0]);
                    }
                    date = null;
                    if (jaxbDate != null) {
                        date = jaxbDate.toGregorianCalendar();
                    }
                    methodParams[paramIndex] = date;
                } else if (methodParamTypes[paramIndex].getName().equals("java.util.Date")) {
                    getValueMethodName = "getValue";
                    getValueMethod = null;
                    if (field.getType().equals(JAXBElement.class)) {
                        getValueMethod = field.getType().getDeclaredMethod(getValueMethodName, new Class[0]);
                        jaxbDate = (XMLGregorianCalendar)getValueMethod.invoke(getterMethod.invoke(jaxbMessageObject, new Object[0]), new Object[0]);
                    } else {
                        jaxbDate = (XMLGregorianCalendar)getterMethod.invoke(jaxbMessageObject, new Object[0]);
                    }
                    date = null;
                    if (jaxbDate != null) {
                        date = jaxbDate.toGregorianCalendar().getTime();
                    }
                    methodParams[paramIndex] = date;
                } else if (Collection.class.isAssignableFrom(methodParamTypes[paramIndex]) || methodParamTypes[paramIndex].isArray()) {
                    Object jaxbArrayObject = getterMethod.invoke(jaxbMessageObject, new Object[0]);
                    if (jaxbArrayObject.getClass().isArray()) {
                        methodParams[paramIndex] = jaxbArrayObject;
                    } else {
                        Collection jaxbList;
                        if (!Collection.class.isAssignableFrom(jaxbArrayObject.getClass())) {
                            Method getListMethod = jaxbArrayObject.getClass().getDeclaredMethods()[0];
                            jaxbList = (Collection)getListMethod.invoke(jaxbArrayObject, new Object[0]);
                        } else {
                            jaxbList = (Collection)jaxbArrayObject;
                        }
                        if (!methodParamTypes[paramIndex].isArray()) {
                            methodParams[paramIndex] = this.createOriginalList(jaxbList, genericParamTypes[paramIndex]);
                        } else {
                            Collection<?> originalList = this.createOriginalList(jaxbList, genericParamTypes[paramIndex]);
                            Class<?> elementType = methodParamTypes[paramIndex].getComponentType();
                            try {
                                Object[] tab = (Object[])Array.newInstance(elementType, originalList.size());
                                methodParams[paramIndex] = originalList.toArray(tab);
                            }
                            catch (ClassCastException e) {
                                methodParams[paramIndex] = Util.ListToprimitiveArray((List)originalList, elementType);
                            }
                        }
                    }
                } else {
                    getValueMethodName = "getValue";
                    getValueMethod = null;
                    if (field.getType().equals(JAXBElement.class)) {
                        getValueMethod = field.getType().getDeclaredMethod(getValueMethodName, new Class[0]);
                        methodParams[paramIndex] = this.createOriginalBean(getValueMethod.invoke(getterMethod.invoke(jaxbMessageObject, new Object[0]), new Object[0]), methodParamTypes[paramIndex]);
                    } else {
                        methodParams[paramIndex] = this.createOriginalBean(getterMethod.invoke(jaxbMessageObject, new Object[0]), methodParamTypes[paramIndex]);
                    }
                }
                ++paramIndex;
            }
        }
        catch (Exception e) {
            throw new DataBindingException(e);
        }
        return methodParams;
    }

    public Object unmarshallMethodResult(Operation serviceOperation, Source source) throws DataBindingException {
        Object[] methodResult = null;
        try {
            Message outputMessage = serviceOperation.getOutputMessage();
            Unmarshaller unmarshaller = serviceOperation.getServiceOfOperation().getRegistry().getUnmarshaller(outputMessage.getMessageName().getNamespaceURI());
            Object jaxbMessageObject = null;
            try {
                jaxbMessageObject = source instanceof StreamSource ? unmarshaller.unmarshal(((StreamSource)source).getInputStream()) : unmarshaller.unmarshal(source);
            }
            catch (UnmarshalException e) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                StreamResult result = new StreamResult(outputStream);
                TransformerFactory tsfF = TransformerFactory.newInstance();
                Transformer trsf = tsfF.newTransformer();
                trsf.transform(source, result);
                jaxbMessageObject = unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
            }
            if (jaxbMessageObject instanceof JAXBElement) {
                JAXBElement jaxbElement = (JAXBElement)jaxbMessageObject;
                jaxbMessageObject = jaxbElement.getValue();
            }
            if (serviceOperation.getReturnType() != null && serviceOperation.getReturnType().getName().equalsIgnoreCase(outputMessage.getMessageJaxbClass().getName())) {
                return this.createOriginalBean(jaxbMessageObject, serviceOperation.getReturnType());
            }
            Map<String, Class<?>> messageParts = outputMessage.getMessageParts();
            methodResult = new Object[outputMessage.getMessageParts().size()];
            Class<?> messageJaxbClass = jaxbMessageObject.getClass();
            Class<?> methodReturnType = serviceOperation.getReturnType();
            Type genericReturnType = serviceOperation.getGenericReturnType();
            int paramIndex = 0;
            for (String messgePartName : messageParts.keySet()) {
                Comparable<Calendar> date;
                XMLGregorianCalendar jaxbDate;
                Method getValueMethod;
                String getValueMethodName;
                String jaxbFieldName = messgePartName;
                if (jaxbFieldName.equals("return")) {
                    jaxbFieldName = "_return";
                }
                Field field = messageJaxbClass.getDeclaredField(jaxbFieldName);
                String getterMethodName = null;
                getterMethodName = !field.getType().equals(Boolean.TYPE) && !field.getType().equals(Boolean.class) ? "get" + Util.upperFirstCase(messgePartName) : "is" + Util.upperFirstCase(messgePartName);
                Method getterMethod = messageJaxbClass.getDeclaredMethod(getterMethodName, new Class[0]);
                if (methodReturnType.isPrimitive() || Util.isSimpleType(methodReturnType)) {
                    getValueMethodName = "getValue";
                    getValueMethod = null;
                    if (field.getType().equals(JAXBElement.class)) {
                        getValueMethod = field.getType().getDeclaredMethod(getValueMethodName, new Class[0]);
                        methodResult[paramIndex] = getValueMethod.invoke(getterMethod.invoke(jaxbMessageObject, new Object[0]), new Object[0]);
                    } else {
                        methodResult[paramIndex] = getterMethod.invoke(jaxbMessageObject, new Object[0]);
                    }
                } else if (methodReturnType.getName().equals("java.util.Calendar")) {
                    getValueMethodName = "getValue";
                    getValueMethod = null;
                    if (field.getType().equals(JAXBElement.class)) {
                        getValueMethod = field.getType().getDeclaredMethod(getValueMethodName, new Class[0]);
                        jaxbDate = (XMLGregorianCalendar)getValueMethod.invoke(getterMethod.invoke(jaxbMessageObject, new Object[0]), new Object[0]);
                    } else {
                        jaxbDate = (XMLGregorianCalendar)getterMethod.invoke(jaxbMessageObject, new Object[0]);
                    }
                    date = null;
                    if (jaxbDate != null) {
                        date = jaxbDate.toGregorianCalendar();
                    }
                    methodResult[paramIndex] = date;
                } else if (methodReturnType.getName().equals("java.util.Date")) {
                    getValueMethodName = "getValue";
                    getValueMethod = null;
                    if (field.getType().equals(JAXBElement.class)) {
                        getValueMethod = field.getType().getDeclaredMethod(getValueMethodName, new Class[0]);
                        jaxbDate = (XMLGregorianCalendar)getValueMethod.invoke(getterMethod.invoke(jaxbMessageObject, new Object[0]), new Object[0]);
                    } else {
                        jaxbDate = (XMLGregorianCalendar)getterMethod.invoke(jaxbMessageObject, new Object[0]);
                    }
                    date = null;
                    if (jaxbDate != null) {
                        date = jaxbDate.toGregorianCalendar().getTime();
                    }
                    methodResult[paramIndex] = date;
                } else if (Collection.class.isAssignableFrom(methodReturnType) || methodReturnType.isArray()) {
                    Object jaxbArrayObject = getterMethod.invoke(jaxbMessageObject, new Object[0]);
                    if (jaxbArrayObject.getClass().isArray()) {
                        methodResult[paramIndex] = jaxbArrayObject;
                    } else {
                        Collection jaxbList;
                        if (!Collection.class.isAssignableFrom(jaxbArrayObject.getClass())) {
                            Method getListMethod = jaxbArrayObject.getClass().getDeclaredMethods()[0];
                            jaxbList = (Collection)getListMethod.invoke(jaxbArrayObject, new Object[0]);
                        } else {
                            jaxbList = (Collection)jaxbArrayObject;
                        }
                        if (!methodReturnType.isArray()) {
                            methodResult[paramIndex] = this.createOriginalList(jaxbList, genericReturnType);
                        } else {
                            Collection<?> originalList = this.createOriginalList(jaxbList, genericReturnType);
                            Class<?> elementType = methodReturnType.getComponentType();
                            try {
                                Object[] tab = (Object[])Array.newInstance(elementType, originalList.size());
                                methodResult[paramIndex] = originalList.toArray(tab);
                            }
                            catch (ClassCastException e) {
                                methodResult[paramIndex] = Util.ListToprimitiveArray((List)originalList, elementType);
                            }
                        }
                    }
                } else {
                    getValueMethodName = "getValue";
                    getValueMethod = null;
                    if (field.getType().equals(JAXBElement.class)) {
                        getValueMethod = field.getType().getDeclaredMethod(getValueMethodName, new Class[0]);
                        methodResult[paramIndex] = this.createOriginalBean(getValueMethod.invoke(getterMethod.invoke(jaxbMessageObject, new Object[0]), new Object[0]), methodReturnType);
                    } else {
                        methodResult[paramIndex] = this.createOriginalBean(getterMethod.invoke(jaxbMessageObject, new Object[0]), methodReturnType);
                    }
                }
                ++paramIndex;
            }
        }
        catch (Exception e) {
            throw new DataBindingException(e);
        }
        return methodResult[0];
    }

    public Object unmarshallException(Operation serviceOperation, Source source) throws DataBindingException {
        try {
            List<Message> operationFaults = serviceOperation.getOperationFaults();
            Message faultMessage = null;
            for (Message fault : operationFaults) {
                if (!fault.getMessageName().getLocalPart().equalsIgnoreCase(Util.createDocument(source).getFirstChild().getLocalName())) continue;
                faultMessage = fault;
            }
            if (faultMessage == null) {
                throw new DataBindingException(" The received message is not described in the WSDL ");
            }
            Class<?> exceptionClass = null;
            for (Class<?> clazz : serviceOperation.getExceptionType()) {
                if (!clazz.getSimpleName().equalsIgnoreCase(faultMessage.getMessageName().getLocalPart()) && !clazz.getSimpleName().equalsIgnoreCase(faultMessage.getMessageTypeName().getLocalPart())) continue;
                exceptionClass = clazz;
            }
            if (exceptionClass == null) {
                throw new DataBindingException(" There is no exception in the JAVA interface matching : with this WSDL fault " + faultMessage.getMessageName().toString());
            }
            Unmarshaller unmarshaller = serviceOperation.getServiceOfOperation().getRegistry().getUnmarshaller(faultMessage.getMessageName().getNamespaceURI());
            Object jaxbMessageObject = null;
            try {
                jaxbMessageObject = source instanceof StreamSource ? unmarshaller.unmarshal(((StreamSource)source).getInputStream()) : unmarshaller.unmarshal(source);
            }
            catch (UnmarshalException e) {
                Document messageDocument = Util.createDocument(source);
                if (messageDocument.getFirstChild().getFirstChild() != null) {
                    jaxbMessageObject = unmarshaller.unmarshal(messageDocument.getFirstChild().getFirstChild());
                }
                return exceptionClass.newInstance();
            }
            if (jaxbMessageObject instanceof JAXBElement) {
                JAXBElement jaxbElement = (JAXBElement)jaxbMessageObject;
                jaxbMessageObject = jaxbElement.getValue();
            }
            if (exceptionClass.getSimpleName().equalsIgnoreCase(faultMessage.getMessageName().getLocalPart()) && exceptionClass.getDeclaredFields() != null && exceptionClass.getDeclaredFields().length == 1 && exceptionClass.getDeclaredFields()[0].getName().equalsIgnoreCase(faultMessage.getMessageTypeName().getLocalPart())) {
                Object exception = this.createOriginalBean(jaxbMessageObject, exceptionClass.getDeclaredFields()[0].getType());
                Object exceptionInstance = exceptionClass.newInstance();
                exceptionClass.getDeclaredMethod("set" + Util.upperFirstCase(exceptionClass.getDeclaredFields()[0].getName()), exceptionClass.getDeclaredFields()[0].getType()).invoke(exceptionInstance, exception);
                return exceptionInstance;
            }
            return this.createOriginalBean(jaxbMessageObject, exceptionClass);
        }
        catch (Exception e) {
            throw new DataBindingException(" Error occurs while unmarshalling the operation fault ", e);
        }
    }

    private Object createOriginalBean(Object jaxbBeanInstance, Class<?> originalBeanClazz) throws DataBindingException {
        if (jaxbBeanInstance == null) {
            return null;
        }
        Object originalBeanInstance = null;
        try {
            Class<?> originalBeanClass = null;
            try {
                System.out.println("Loading JAX-B class " + jaxbBeanInstance.getClass().getName());
                originalBeanClass = this.serviceClassLoader.loadClass(jaxbBeanInstance.getClass().getName());
            }
            catch (Exception e) {
                if (originalBeanClazz != null) {
                    originalBeanClass = this.serviceClassLoader.loadClass(originalBeanClazz.getName());
                }
                throw new DataBindingException(e);
            }
            originalBeanInstance = originalBeanClass.newInstance();
            for (Field originalBeanField : Util.getFieldFormBeanClassAndSuperClass(originalBeanClass)) {
                Comparable<Calendar> date;
                XMLGregorianCalendar jaxbDate;
                Field[] jaxbBeanFields;
                Field jaxbField;
                String fieldName = originalBeanField.getName();
                if (fieldName.equals("serialVersionUID") || (jaxbField = Util.getJaxbField(fieldName, jaxbBeanFields = Util.getFieldFormBeanClassAndSuperClass(jaxbBeanInstance.getClass()))) == null) continue;
                String getterMethodName = null;
                Method getterMethod = null;
                XmlElement xmlElement = jaxbField.getAnnotation(XmlElement.class);
                getterMethodName = xmlElement != null && !xmlElement.name().equals("##default") ? "get" + Util.upperFirstCase(xmlElement.name()) : "get" + Util.upperFirstCase(jaxbField.getName());
                try {
                    getterMethod = jaxbBeanInstance.getClass().getMethod(getterMethodName, new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    getterMethodName = "is" + Util.upperFirstCase(jaxbField.getName());
                    getterMethod = jaxbBeanInstance.getClass().getMethod(getterMethodName, new Class[0]);
                }
                Object jaxbElement = getterMethod.invoke(jaxbBeanInstance, new Object[0]);
                if (jaxbElement == null) continue;
                Method getValueMethod = null;
                if (jaxbElement instanceof JAXBElement) {
                    getValueMethod = jaxbElement.getClass().getDeclaredMethod("getValue", new Class[0]);
                }
                String setterMethodName = "set" + Util.upperFirstCase(fieldName);
                Method setterMethod = Util.getMethodFomBeanClassOrSuperClass(setterMethodName, originalBeanClass, originalBeanField.getType());
                if ("java.math.BigDecimal".equals(originalBeanField.getType().getName())) {
                    BigDecimal bigDecimalValue = null;
                    if (jaxbElement instanceof String) {
                        bigDecimalValue = new BigDecimal(String.valueOf(jaxbElement));
                    } else if (jaxbElement instanceof BigDecimal) {
                        bigDecimalValue = (BigDecimal)jaxbElement;
                    }
                    if (bigDecimalValue != null) {
                        setterMethod.invoke(originalBeanInstance, bigDecimalValue);
                        continue;
                    }
                    throw new DataBindingException("The original value of a java.math.BigDecimal field could not be retrieved.");
                }
                if (originalBeanField.getType().isPrimitive() || Util.isSimpleType(originalBeanField.getType())) {
                    if (getValueMethod != null) {
                        setterMethod.invoke(originalBeanInstance, getValueMethod.invoke(jaxbElement, new Object[0]));
                        continue;
                    }
                    setterMethod.invoke(originalBeanInstance, jaxbElement);
                    continue;
                }
                if (originalBeanField.getType().getName().equals("java.util.Calendar")) {
                    jaxbDate = (XMLGregorianCalendar)getValueMethod.invoke(jaxbElement, new Object[0]);
                    date = jaxbDate.toGregorianCalendar();
                    setterMethod.invoke(originalBeanInstance, date);
                    continue;
                }
                if (originalBeanField.getType().getName().equals("java.util.Date")) {
                    jaxbDate = (XMLGregorianCalendar)jaxbElement;
                    date = jaxbDate.toGregorianCalendar().getTime();
                    setterMethod.invoke(originalBeanInstance, date);
                    continue;
                }
                if (Collection.class.isAssignableFrom(originalBeanField.getType()) || originalBeanField.getType().isArray()) {
                    Collection jaxbList;
                    Object jaxbArrayObject;
                    if (getValueMethod != null) {
                        jaxbArrayObject = getValueMethod.invoke(jaxbElement, new Object[0]);
                        if (jaxbArrayObject == null) {
                            continue;
                        }
                    } else {
                        jaxbArrayObject = jaxbElement;
                    }
                    if (jaxbArrayObject.getClass().isArray()) {
                        setterMethod.invoke(originalBeanInstance, jaxbArrayObject);
                        continue;
                    }
                    if (!Collection.class.isAssignableFrom(jaxbArrayObject.getClass())) {
                        Method getListMethod = jaxbArrayObject.getClass().getDeclaredMethods()[0];
                        jaxbList = (Collection)getListMethod.invoke(jaxbArrayObject, new Object[0]);
                    } else {
                        jaxbList = (Collection)jaxbArrayObject;
                    }
                    if (!originalBeanField.getType().isArray()) {
                        if (setterMethod != null) {
                            setterMethod.invoke(originalBeanInstance, this.createOriginalList(jaxbList, originalBeanField.getGenericType()));
                            continue;
                        }
                        String originalGetterMethodName = "get" + Util.upperFirstCase(fieldName);
                        Method originalGetterMethod = Util.getMethodFomBeanClassOrSuperClass(originalGetterMethodName, originalBeanClass, new Class[0]);
                        List originalList = (List)this.createOriginalList(jaxbList, originalBeanField.getGenericType());
                        ((List)originalGetterMethod.invoke(originalBeanInstance, new Object[0])).addAll(originalList);
                        continue;
                    }
                    Collection<?> originalList = this.createOriginalList(jaxbList, originalBeanField.getGenericType());
                    Class<?> elementType = originalBeanField.getType().getComponentType();
                    try {
                        Object[] tab = (Object[])Array.newInstance(elementType, originalList.size());
                        setterMethod.invoke(originalBeanInstance, new Object[]{originalList.toArray(tab)});
                    }
                    catch (ClassCastException e) {
                        setterMethod.invoke(originalBeanInstance, Util.ListToprimitiveArray((List)originalList, elementType));
                    }
                    continue;
                }
                if (originalBeanField.getType().isEnum()) {
                    if (getValueMethod != null) {
                        setterMethod.invoke(originalBeanInstance, this.createEnumObject(getValueMethod.invoke(jaxbElement, new Object[0]), originalBeanField.getType()));
                        continue;
                    }
                    setterMethod.invoke(originalBeanInstance, this.createEnumObject(jaxbElement, originalBeanField.getType()));
                    continue;
                }
                if (getValueMethod != null) {
                    setterMethod.invoke(originalBeanInstance, this.createOriginalBean(getValueMethod.invoke(jaxbElement, new Object[0]), originalBeanField.getType()));
                    continue;
                }
                setterMethod.invoke(originalBeanInstance, this.createOriginalBean(jaxbElement, originalBeanField.getType()));
            }
        }
        catch (Exception e) {
            throw new DataBindingException(e);
        }
        return originalBeanInstance;
    }

    private Object createEnumObject(Object jaxbEnumInstance, Class<?> originalEnumClazz) throws Exception {
        Class<?> originalEnumClass = null;
        try {
            originalEnumClass = this.serviceClassLoader.loadClass(jaxbEnumInstance.getClass().getName());
        }
        catch (Exception e) {
            if (originalEnumClazz != null) {
                originalEnumClass = this.serviceClassLoader.loadClass(originalEnumClazz.getName());
            }
            throw new DataBindingException(e);
        }
        Method valueMethod = jaxbEnumInstance.getClass().getDeclaredMethod("value", new Class[0]);
        Method fromValueMethod = originalEnumClass.getDeclaredMethod("fromValue", valueMethod.invoke(jaxbEnumInstance, new Object[0]).getClass());
        return fromValueMethod.invoke(originalEnumClass, valueMethod.invoke(jaxbEnumInstance, new Object[0]));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Collection<?> createOriginalList(Collection<?> jaxbList, Type collectionClass) throws DataBindingException {
        if (jaxbList == null) {
            return null;
        }
        Collection originalList = null;
        try {
            Class genericTypeClass = null;
            Type genericType = null;
            if (collectionClass instanceof Class) {
                if (((Class)collectionClass).isArray()) {
                    originalList = (Collection)ArrayList.class.newInstance();
                    genericTypeClass = ((Class)collectionClass).getComponentType();
                } else {
                    originalList = !((Class)collectionClass).isInterface() ? (Collection)((Class)collectionClass).newInstance() : (Collection)ArrayList.class.newInstance();
                }
            } else {
                if (!(collectionClass instanceof ParameterizedType)) throw new DataBindingException(" Unknown type :  " + collectionClass.getClass().getName());
                ParameterizedType pt = (ParameterizedType)collectionClass;
                Class originalListClass = (Class)pt.getRawType();
                originalList = !originalListClass.isInterface() ? (Collection)originalListClass.newInstance() : (Collection)ArrayList.class.newInstance();
                genericType = pt.getActualTypeArguments()[0];
                if (genericType instanceof Class) {
                    genericTypeClass = (Class)genericType;
                } else {
                    if (!(genericType instanceof ParameterizedType)) throw new DataBindingException(" Unknown type :  " + genericType.getClass().getName());
                    genericTypeClass = (Class)((ParameterizedType)genericType).getRawType();
                }
            }
            for (Object listContent : jaxbList) {
                if (listContent == null) continue;
                if (listContent.getClass().isPrimitive() || Util.isSimpleType(listContent.getClass())) {
                    originalList.addAll(jaxbList);
                    return originalList;
                }
                if (listContent.getClass().getName().equals("javax.xml.datatype.XMLGregorianCalendar")) {
                    XMLGregorianCalendar jaxbDate = (XMLGregorianCalendar)listContent;
                    GregorianCalendar date = null;
                    if (jaxbDate != null) {
                        date = jaxbDate.toGregorianCalendar();
                    }
                    if (genericTypeClass != null && genericTypeClass.getName().equals("java.util.Date")) {
                        originalList.add(date.getTime());
                        continue;
                    }
                    originalList.add(date);
                    continue;
                }
                if (genericTypeClass != null && Collection.class.isAssignableFrom(genericTypeClass)) {
                    originalList.add(this.createOriginalList((Collection)listContent, genericType));
                    continue;
                }
                originalList.add(this.createOriginalBean(listContent, genericTypeClass));
            }
            return originalList;
        }
        catch (Exception e) {
            throw new DataBindingException(e);
        }
    }

    public ClassLoader getServiceClassLoader() {
        return this.serviceClassLoader;
    }

    public void setServiceClassLoader(ClassLoader serviceClassLoader) {
        this.serviceClassLoader = serviceClassLoader;
    }

    public ClassLoader getJaxbClassLoader() {
        return this.jaxbClassLoader;
    }

    public void setJaxbClassLoader(ClassLoader jaxbClassLoader) {
        this.jaxbClassLoader = jaxbClassLoader;
    }
}

