/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.type;

import java.io.Serializable;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.Type;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.ChainedNoSuchInterfaceException;
import org.objectweb.fractal.julia.factory.ChainedInstantiationException;

public class BasicComponentType
implements ComponentType,
Serializable {
    private final InterfaceType[] interfaceTypes;

    public BasicComponentType(InterfaceType[] itfTypes) throws InstantiationException {
        this.interfaceTypes = BasicComponentType.clone(itfTypes);
        int i = 0;
        while (i < this.interfaceTypes.length) {
            String p = this.interfaceTypes[i].getFcItfName();
            boolean collection = this.interfaceTypes[i].isFcCollectionItf();
            int j = i + 1;
            while (j < this.interfaceTypes.length) {
                String q = this.interfaceTypes[j].getFcItfName();
                if (p.equals(q)) {
                    throw new ChainedInstantiationException(null, null, "Two interfaces have the same name '" + q + "'");
                }
                if (collection && q.startsWith(p)) {
                    throw new ChainedInstantiationException(null, null, "The name of the interface '" + q + "' starts with '" + p + "', which is the name of a collection interface");
                }
                if (this.interfaceTypes[j].isFcCollectionItf() && p.startsWith(q)) {
                    throw new ChainedInstantiationException(null, null, "The name of the interface '" + p + "' starts with '" + q + "', which is the name of a collection interface");
                }
                ++j;
            }
            ++i;
        }
    }

    public InterfaceType[] getFcInterfaceTypes() {
        return BasicComponentType.clone(this.interfaceTypes);
    }

    public InterfaceType getFcInterfaceType(String name) throws NoSuchInterfaceException {
        int i = 0;
        while (i < this.interfaceTypes.length) {
            InterfaceType itfType = this.interfaceTypes[i];
            String itfName = itfType.getFcItfName();
            if (itfType.isFcCollectionItf() ? name.startsWith(itfName) : name.equals(itfName)) {
                return itfType;
            }
            ++i;
        }
        throw new ChainedNoSuchInterfaceException(null, null, name);
    }

    public boolean isFcSubTypeOf(Type type) {
        try {
            if (type instanceof ComponentType) {
                InterfaceType i2;
                ComponentType t = (ComponentType)type;
                InterfaceType[] itfs = this.interfaceTypes;
                int i = 0;
                while (i < itfs.length) {
                    InterfaceType i1 = itfs[i];
                    if (i1.isFcClientItf() && !i1.isFcSubTypeOf((Type)(i2 = t.getFcInterfaceType(i1.getFcItfName())))) {
                        return false;
                    }
                    ++i;
                }
                itfs = t.getFcInterfaceTypes();
                int i3 = 0;
                while (i3 < itfs.length) {
                    InterfaceType i1;
                    i2 = itfs[i3];
                    if (!i2.isFcClientItf() && !(i1 = this.getFcInterfaceType(i2.getFcItfName())).isFcSubTypeOf((Type)i2)) {
                        return false;
                    }
                    ++i3;
                }
                return true;
            }
        }
        catch (NoSuchInterfaceException e) {}
        return false;
    }

    private static InterfaceType[] clone(InterfaceType[] types) {
        if (types == null) {
            return new InterfaceType[0];
        }
        InterfaceType[] clone = new InterfaceType[types.length];
        System.arraycopy(types, 0, clone, 0, types.length);
        return clone;
    }

    public String toString() {
        String s = "[";
        InterfaceType[] its = this.getFcInterfaceTypes();
        boolean first = true;
        int i = 0;
        while (i < its.length) {
            if (first) {
                first = false;
            } else {
                s = s + ",";
            }
            s = s + its[i].toString();
            ++i;
        }
        s = s + "]";
        return s;
    }

    public boolean equals(Object o) {
        if (o instanceof ComponentType) {
            InterfaceType[] it = ((ComponentType)o).getFcInterfaceTypes();
            if (this.interfaceTypes.length != it.length) {
                return false;
            }
            int i = 0;
            while (i < it.length) {
                if (!this.interfaceTypes[i].equals(it[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.interfaceTypes.length == 0) {
            return 1;
        }
        int result = this.interfaceTypes[0].hashCode();
        int i = 1;
        while (i < this.interfaceTypes.length) {
            result *= this.interfaceTypes[i].hashCode();
            ++i;
        }
        return result;
    }
}

