/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.compile.jdt;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.SourceFile;
import org.objectweb.fractal.juliac.Utils;
import org.objectweb.fractal.juliac.compile.jdt.BasicCompilationUnit;
import org.objectweb.fractal.juliac.compile.jdt.JDTCompiler;
import org.objectweb.fractal.juliac.conf.JDKLevel;
import org.objectweb.fractal.juliac.conf.JuliacConfig;
import org.objectweb.fractal.juliac.plugin.CompileSupportItf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileSupportImpl
implements CompileSupportItf {
    private Juliac jc;
    private static final Map<JDKLevel, Long> levels = new HashMap<JDKLevel, Long>(){
        private static final long serialVersionUID = -6067687147064920146L;
        {
            this.put(JDKLevel.JDK1_1, 2949123L);
            this.put(JDKLevel.JDK1_2, 0x2E0000L);
            this.put(JDKLevel.JDK1_3, 0x2F0000L);
            this.put(JDKLevel.JDK1_4, 0x300000L);
            this.put(JDKLevel.JDK1_5, 0x310000L);
            this.put(JDKLevel.JDK1_6, 0x320000L);
            this.put(JDKLevel.JDK1_7, 0x330000L);
        }
    };

    public void init(Juliac jc) {
        this.jc = jc;
    }

    public List<String> compile(List<SourceFile> sfs, File classDir) throws IOException {
        JDTCompiler jdtcompiler = this.getJDTCompiler();
        this.compile(jdtcompiler, sfs);
        String path = classDir.getAbsolutePath();
        ArrayList<String> outputFileNames = new ArrayList<String>();
        List<ClassFile> files = jdtcompiler.getClassFiles();
        for (ClassFile f : files) {
            String name = new String(f.fileName()).replace('/', File.separatorChar) + ".class";
            ClassFile.writeToDisk((boolean)true, (String)path, (String)name, (ClassFile)f);
            String filename = new String(f.fileName()) + ".class";
            outputFileNames.add(filename);
        }
        return outputFileNames;
    }

    public void close() {
    }

    public List<CompilationUnitDeclaration> compile(List<SourceFile> sfs) throws IOException {
        JDTCompiler jdtcompiler = this.getJDTCompiler();
        return this.compile(jdtcompiler, sfs);
    }

    private List<CompilationUnitDeclaration> compile(JDTCompiler jdtcompiler, List<SourceFile> sfs) throws IOException {
        Map<ICompilationUnit, SourceFile> units = BasicCompilationUnit.getICompilationUnitMap(sfs);
        jdtcompiler.compile(units);
        CompilationResult result = jdtcompiler.getResult();
        if (result.hasErrors()) {
            String msg = "Compilation error";
            throw new IOException(msg);
        }
        List<CompilationUnitDeclaration> unitds = jdtcompiler.getUnits();
        return unitds;
    }

    private JDTCompiler getJDTCompiler() {
        JuliacConfig jconf = this.jc.getJuliacConfig();
        JDKLevel sourceLevel = jconf.getSourceLevel();
        JDKLevel targetLevel = jconf.getTargetLevel();
        CompilerOptions options = new CompilerOptions();
        options.sourceLevel = levels.get(sourceLevel);
        options.targetJDK = levels.get(targetLevel);
        options.complianceLevel = 0x310000L;
        INameEnvironment environment = this.getClassPathForJDT();
        IErrorHandlingPolicy policy = this.getErrorHandlingPolicy();
        JDTCompiler jdtcompiler = new JDTCompiler(environment, policy, options);
        return jdtcompiler;
    }

    private IErrorHandlingPolicy getErrorHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            public boolean proceedOnErrors() {
                return true;
            }

            public boolean stopOnFirstError() {
                return false;
            }
        };
    }

    private INameEnvironment getClassPathForJDT() {
        ArrayList<String> lst = new ArrayList<String>();
        String bootpath = System.getProperty("sun.boot.class.path");
        for (String s : bootpath.split(File.pathSeparator)) {
            File f = new File(s);
            boolean isRegular = Utils.isRegularClassPathEntry((File)f);
            if (!isRegular) continue;
            String path = f.getAbsolutePath();
            lst.add(path);
        }
        String classpath = System.getProperty("java.class.path");
        for (String s : classpath.split(File.pathSeparator)) {
            File f = new File(s);
            boolean isRegular = Utils.isRegularClassPathEntry((File)f);
            if (!isRegular) continue;
            String path = f.getAbsolutePath();
            lst.add(path);
        }
        JuliacConfig jconf = this.jc.getJuliacConfig();
        List cpes = jconf.getClassPathEntries();
        lst.addAll(cpes);
        String[] classpathNames = lst.toArray(new String[lst.size()]);
        String[] initialFileNames = new String[]{};
        String encoding = System.getProperty("file.encoding");
        FileSystem ret = new FileSystem(classpathNames, initialFileNames, encoding);
        return ret;
    }
}

