/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.fractal.juliac.CompilationRounds;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.SourceFile;
import org.objectweb.fractal.juliac.conf.JuliacConfig;
import org.objectweb.fractal.juliac.plugin.CompileSupportItf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationRound {
    private List<SourceFile> inputFiles = new ArrayList<SourceFile>();
    private List<SourceFile> generatedFiles = new ArrayList<SourceFile>();
    private List<String> outputFiles = new ArrayList<String>();
    private CompilationRounds rounds;
    private JuliacConfig jconf;

    public CompilationRound(CompilationRounds rounds, JuliacConfig jconf) {
        this.rounds = rounds;
        this.jconf = jconf;
    }

    public void addInput(List<SourceFile> sfs) {
        this.inputFiles.addAll(sfs);
    }

    public void addGenerated(SourceFile sf) {
        this.generatedFiles.add(sf);
        Juliac.reportInfo(sf.getQname());
    }

    public boolean contains(SourceFile sf) {
        boolean b = this.generatedFiles.contains(sf);
        return b;
    }

    public void compile(CompileSupportItf compiler) throws IOException {
        ArrayList<SourceFile> sfs = new ArrayList<SourceFile>();
        sfs.addAll(this.inputFiles);
        sfs.addAll(this.generatedFiles);
        File classDir = this.jconf.getClassDir();
        this.outputFiles = compiler.compile(sfs, classDir);
        this.rounds.newCompilationRound();
    }

    public List<SourceFile> getInputFiles() {
        return this.inputFiles;
    }

    public List<SourceFile> getGeneratedFiles() {
        return this.generatedFiles;
    }

    public List<String> getOutputFileNames() {
        return this.outputFiles;
    }

    public File getClassDir() throws IOException {
        return this.jconf.getClassDir();
    }
}

