/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Type;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.Interceptor;
import org.objectweb.fractal.juliac.ClassGenerator;
import org.objectweb.fractal.juliac.FCSourceCodeGeneratorItf;
import org.objectweb.fractal.juliac.ITBasedClassGenerator;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.Utils;
import org.objectweb.fractal.juliac.desc.MembraneDesc;
import org.objectweb.fractal.juliac.visit.ClassSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.MethodSourceCodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitializerClassGenerator<T>
extends ClassGenerator {
    protected Juliac jc;
    protected FCSourceCodeGeneratorItf<T> fcscg;
    protected MembraneDesc<T> membraneDesc;
    protected ComponentType ct;
    protected Object contentDesc;

    public void init(Juliac jc, FCSourceCodeGeneratorItf<T> fcscg, MembraneDesc<T> membraneDesc, ComponentType ct, Object contentDesc) {
        this.jc = jc;
        this.fcscg = fcscg;
        this.membraneDesc = membraneDesc;
        this.ct = ct;
        this.contentDesc = contentDesc;
    }

    protected MembraneDesc<T> getMembraneDesc() {
        return this.membraneDesc;
    }

    @Override
    public String[] getImplementedInterfaceNames() {
        return new String[]{"org.objectweb.fractal.juliac.runtime.Factory"};
    }

    @Override
    public void generateMethods(ClassSourceCodeVisitor cv) {
        this.generateGetFcInstanceTypeMethod(cv);
        this.generateGetFcControllerDescMethod(cv);
        this.generateGetFcContentDescMethod(cv);
        this.generateNewFcContentMethod(cv);
        this.generateNewFcInstanceMethod(cv);
        this.generateNewFcInstanceContentMethod(cv);
        this.generateExtraCode(cv);
    }

    @Override
    public String getTargetClassName() {
        String ctrlDesc = this.membraneDesc.getDescriptor();
        String contentClassName = Utils.getContentClassName(ctrlDesc, this.contentDesc);
        String membraneClassName = this.getMembraneClassName(ctrlDesc, contentClassName);
        String hexhashct = Utils.hexhash((Type)this.ct);
        String initializerClassName = membraneClassName + "FC" + hexhashct;
        return initializerClassName;
    }

    public String getMembraneClassName(Object ctrlDesc, String contentClassName) throws IllegalArgumentException {
        if (!(ctrlDesc instanceof String)) {
            String msg = "ctrlDesc should be a String";
            throw new IllegalArgumentException(msg);
        }
        String ctrlDescStr = ((String)ctrlDesc).replace('/', '_');
        String membraneClassName = contentClassName == null ? Utils.getJuliacGeneratedStrongTypeName(ctrlDescStr) : contentClassName + "FC" + ctrlDescStr;
        String rootedMembraneClassName = this.jc.getRootedClassName(membraneClassName);
        return rootedMembraneClassName;
    }

    protected void generateGetFcInstanceTypeMethod(ClassSourceCodeVisitor cv) {
        MethodSourceCodeVisitor mv = cv.visitMethod(1, null, Type.class.getName(), "getFcInstanceType", null, null);
        mv.visitBegin();
        this.generateGetFcInstanceTypeMethod(mv);
        mv.visitEnd();
    }

    protected void generateGetFcInstanceTypeMethod(MethodSourceCodeVisitor mv) {
        mv.visitln("    try {");
        mv.visit("      return ");
        mv.visit(Utils.javaify(this.ct).toString());
        mv.visitln(";");
        mv.visitln("    }");
        mv.visit("    catch( ");
        mv.visit(InstantiationException.class.getName());
        mv.visitln(" ie ) {");
        mv.visitln("      throw new org.objectweb.fractal.juliac.runtime.RuntimeException(ie);");
        mv.visitln("    }");
    }

    protected void generateGetFcControllerDescMethod(ClassSourceCodeVisitor cv) {
        MethodSourceCodeVisitor mv = cv.visitMethod(1, null, "Object", "getFcControllerDesc", null, null);
        mv.visitBegin();
        this.generateGetFcControllerDescMethod(mv);
        mv.visitEnd();
    }

    protected void generateGetFcControllerDescMethod(MethodSourceCodeVisitor mv) {
        mv.visitln("    throw new UnsupportedOperationException();");
    }

    protected void generateGetFcContentDescMethod(ClassSourceCodeVisitor cv) {
        MethodSourceCodeVisitor mv = cv.visitMethod(1, null, "Object", "getFcContentDesc", null, null);
        mv.visitBegin();
        this.generateGetFcContentDescMethod(mv);
        mv.visitEnd();
    }

    protected void generateGetFcContentDescMethod(MethodSourceCodeVisitor mv) {
        mv.visitln("    throw new UnsupportedOperationException();");
    }

    protected void generateNewFcContentMethod(ClassSourceCodeVisitor cv) {
        MethodSourceCodeVisitor mv = cv.visitMethod(1, null, "Object", "newFcContent", null, new String[]{InstantiationException.class.getName()});
        mv.visitBegin();
        this.generateNewFcContentMethod(mv);
        mv.visitEnd();
    }

    protected void generateNewFcContentMethod(MethodSourceCodeVisitor mv) {
        mv.visitln("    throw new UnsupportedOperationException();");
    }

    protected void generateNewFcInstanceMethod(ClassSourceCodeVisitor cv) {
        MethodSourceCodeVisitor mv = cv.visitMethod(1, null, Component.class.getName(), "newFcInstance", null, new String[]{InstantiationException.class.getName()});
        mv.visitBegin();
        this.generateNewFcInstanceMethod(mv);
        mv.visitEnd();
    }

    protected void generateNewFcInstanceMethod(MethodSourceCodeVisitor mv) {
        mv.visitln("    throw new UnsupportedOperationException();");
    }

    protected void generateNewFcInstanceContentMethod(ClassSourceCodeVisitor cv) {
        MethodSourceCodeVisitor mv = cv.visitMethod(1, null, Component.class.getName(), "newFcInstance", new String[]{"Object content"}, new String[]{InstantiationException.class.getName()});
        mv.visitBegin();
        this.generateNewFcInstanceContentMethod(mv);
        mv.visitEnd();
    }

    protected void generateNewFcInstanceContentMethod(MethodSourceCodeVisitor mv) {
        mv.visitln("    throw new UnsupportedOperationException();");
    }

    protected void generateExtraCode(ClassSourceCodeVisitor cv) {
    }

    protected void generateContentChecks(MethodSourceCodeVisitor mv) {
        String ctrlDesc = this.membraneDesc.getDescriptor();
        String contentClassName = Utils.getContentClassName(ctrlDesc, this.contentDesc);
        if (contentClassName != null) {
            boolean checkForBC = false;
            InterfaceType[] its = this.ct.getFcInterfaceTypes();
            for (int i = 0; i < its.length; ++i) {
                if (its[i].isFcClientItf()) {
                    checkForBC = true;
                    continue;
                }
                String signature = its[i].getFcItfSignature();
                mv.visitln("    if( content!=null && !(content instanceof " + signature + ") ) {");
                mv.visitln("      String msg = \"" + contentClassName + " should implement " + signature + "\";");
                mv.visitln("      throw new " + InstantiationException.class.getName() + "(msg);");
                mv.visitln("    }");
            }
            if (checkForBC) {
                this.generateContentCheckForBC(mv);
            }
        }
    }

    protected void generateContentCheckForBC(MethodSourceCodeVisitor mv) {
        String ctrlDesc = this.membraneDesc.getDescriptor();
        String contentClassName = Utils.getContentClassName(ctrlDesc, this.contentDesc);
        mv.visitln("    if( content!=null && !(content instanceof " + BindingController.class.getName() + ") ) {");
        mv.visitln("      String msg = \"" + contentClassName + " should implement " + BindingController.class.getName() + "\";");
        mv.visitln("      throw new " + InstantiationException.class.getName() + "(msg);");
        mv.visitln("    }");
    }

    public void generateInitializationContextForContent(MethodSourceCodeVisitor mv) {
        String ctrlDesc = this.membraneDesc.getDescriptor();
        mv.visitln("    ic.interfaces.put(\"/content\",content);");
        mv.visitln("    ic.interfaces.put(\"/controllerDesc\",\"" + ctrlDesc + "\");");
        if (ctrlDesc.endsWith("Template")) {
            mv.visit("    ic.content = ");
            mv.visit(Utils.javaifyContentDesc(this.contentDesc).toString());
            mv.visitln(";");
        } else {
            mv.visitln("    ic.content = content;");
        }
    }

    public boolean generateInterceptorCreation(MethodSourceCodeVisitor mv, InterfaceType it, String delegate) {
        ITBasedClassGenerator scg = this.membraneDesc.getInterceptorClassGenerator();
        if (scg == null) {
            return false;
        }
        scg.setInterfaceType(it);
        scg.setMembraneDesc(this.membraneDesc);
        if (!scg.match()) {
            return false;
        }
        String name = scg.getTargetClassName();
        mv.visit("    intercept = new ");
        mv.visit(name);
        mv.visitln("();");
        mv.visitln("    ic.controllers.add(intercept);");
        if (!it.isFcClientItf()) {
            mv.visit("    ((");
            mv.visit(Interceptor.class.getName());
            mv.visit(")intercept).setFcItfDelegate(");
            mv.visit(delegate);
            mv.visitln(");");
        }
        return true;
    }
}

