/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceFile {
    protected File root;
    protected String qname;

    public static SourceFile create(File root, String qname) throws IllegalArgumentException {
        if (root.isDirectory()) {
            SourceFileDir sf = new SourceFileDir(root, qname);
            return sf;
        }
        String name = root.getName();
        if (name.endsWith(".jar")) {
            SourceFileJar sf = new SourceFileJar(root, qname);
            return sf;
        }
        String msg = root + " should be either a directory or a .jar file";
        throw new IllegalArgumentException(msg);
    }

    public static SourceFile create(String qname, String content) {
        SourceFileString sf = new SourceFileString(qname, content);
        return sf;
    }

    protected SourceFile(File file, String qname) {
        this.root = file;
        this.qname = qname;
    }

    public abstract char[] getContent() throws IOException;

    public String getName() {
        String[] names = this.qname.split("[.]");
        String name = names[names.length - 1] + ".java";
        return name;
    }

    public static void addAllJavaFiles(File baseDir, String src, List<SourceFile> sfs) throws IOException {
        File input = new File(baseDir, src);
        if (!input.exists() && !(input = new File(src)).exists()) {
            String msg = "No such file or directory <" + baseDir + "," + src + ">";
            throw new IOException(msg);
        }
        if (input.isDirectory()) {
            SourceFile.addAllJavaFilesInDir(input, input, sfs);
        } else {
            String name = input.getName();
            String ext = name.substring(name.length() - 4);
            if (ext.equals(".jar")) {
                SourceFile.addAllJavaFilesInJar(input, sfs);
            } else {
                String msg = src + " should be a directory or a .jar file";
                throw new IOException(msg);
            }
        }
    }

    private static void addAllJavaFilesInDir(File root, File dir, List<SourceFile> sfs) throws IOException {
        File[] fs = dir.listFiles();
        if (fs == null) {
            String msg = dir.getAbsolutePath() + " was supposed to be a directory";
            throw new IOException(msg);
        }
        int headlength = root.getAbsolutePath().length();
        for (File f : fs) {
            if (f.isDirectory() || !f.getName().endsWith(".java")) continue;
            String fname = f.getAbsolutePath();
            fname = fname.substring(headlength + 1);
            fname = fname.substring(0, fname.length() - 5);
            fname = fname.replace(File.separatorChar, '.');
            SourceFile sf = SourceFile.create(root, fname);
            sfs.add(sf);
        }
        for (File f : fs) {
            if (!f.isDirectory()) continue;
            SourceFile.addAllJavaFilesInDir(root, f, sfs);
        }
    }

    private static void addAllJavaFilesInJar(File jar, List<SourceFile> sfs) throws IOException {
        FileInputStream fis = new FileInputStream(jar);
        JarInputStream jis = new JarInputStream(fis);
        JarEntry je = jis.getNextJarEntry();
        while (je != null) {
            int length;
            String name = je.getName();
            if (je.isDirectory() || !name.endsWith(".java")) {
                je = jis.getNextJarEntry();
                continue;
            }
            String fname = name.substring(0, name.length() - 5);
            fname = fname.replace('/', '.');
            CharArrayWriter caw = new CharArrayWriter();
            byte[] buffer = new byte[1024];
            while ((length = jis.read(buffer, 0, buffer.length)) != -1) {
                for (int i = 0; i < length; ++i) {
                    char c = (char)buffer[i];
                    caw.append(c);
                }
            }
            char[] content = caw.toCharArray();
            SourceFileJar sfj = new SourceFileJar(jar, fname);
            sfj.setContent(content);
            sfs.add(sfj);
            je = jis.getNextJarEntry();
        }
        jis.close();
        fis.close();
    }

    public String getQname() {
        return this.qname;
    }

    public File getRoot() {
        return this.root;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SourceFile)) {
            return false;
        }
        return this.qname.equals(((SourceFile)other).qname);
    }

    public int hashCode() {
        return this.qname.hashCode();
    }

    public String toString() {
        String s = this.root.getAbsolutePath() + File.separatorChar + this.qname.replace('.', File.separatorChar) + ".java";
        return s;
    }

    private static class SourceFileString
    extends SourceFile {
        private char[] content;

        protected SourceFileString(String qname, String content) {
            super(new File("."), qname);
            this.content = content.toCharArray();
        }

        public char[] getContent() {
            return this.content;
        }
    }

    private static class SourceFileJar
    extends SourceFile {
        private char[] content;

        protected SourceFileJar(File root, String qname) {
            super(root, qname);
        }

        protected void setContent(char[] content) {
            this.content = content;
        }

        public char[] getContent() {
            return this.content;
        }
    }

    private static class SourceFileDir
    extends SourceFile {
        protected SourceFileDir(File root, String qname) {
            super(root, qname);
        }

        public char[] getContent() throws IOException {
            String fname = this.qname.replace('.', File.separatorChar) + ".java";
            File f = new File(this.root, fname);
            FileReader fr = new FileReader(f);
            long length = f.length();
            int ilength = (int)length;
            char[] content = new char[ilength];
            fr.read(content);
            fr.close();
            return content;
        }
    }
}

