/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.proxy;

import java.util.Arrays;
import java.util.HashSet;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.InitializationContext;
import org.objectweb.fractal.julia.Interceptor;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.desc.MembraneDesc;
import org.objectweb.fractal.juliac.proxy.AbstractProxyClassGenerator;
import org.objectweb.fractal.juliac.proxy.InterceptorSourceCodeGenerator;
import org.objectweb.fractal.juliac.ucf.UnifiedClass;
import org.objectweb.fractal.juliac.ucf.UnifiedMethod;
import org.objectweb.fractal.juliac.visit.ClassSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.FileSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.MethodSourceCodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorClassGenerator
extends AbstractProxyClassGenerator {
    private InterceptorSourceCodeGenerator[] iscgs;
    private boolean[] matches;

    public InterceptorClassGenerator(InterceptorSourceCodeGenerator[] iscgs, Juliac jc) {
        this.init(iscgs);
        this.setJuliac(jc);
    }

    public InterceptorClassGenerator(InterceptorSourceCodeGenerator[] iscgs, InterfaceType it, MembraneDesc<?> membraneDesc, boolean mergeable, Juliac jc) {
        this.init(iscgs);
        this.setInterfaceType(it);
        this.setMembraneDesc(membraneDesc);
        this.setMergeable(mergeable);
        this.setJuliac(jc);
    }

    private void init(InterceptorSourceCodeGenerator[] iscgs) throws IllegalArgumentException {
        if (iscgs == null || iscgs.length == 0) {
            String msg = "Parameter shouldn't be null or of size 0";
            throw new IllegalArgumentException(msg);
        }
        this.iscgs = iscgs;
        this.matches = new boolean[this.iscgs.length];
    }

    @Override
    public void setInterfaceType(InterfaceType it) {
        this.it = it;
        if (this.iscgs != null) {
            for (InterceptorSourceCodeGenerator iscg : this.iscgs) {
                iscg.setInterfaceType(it);
            }
            this.updateState();
        }
    }

    @Override
    public void setMembraneDesc(MembraneDesc<?> membraneDesc) {
        this.membraneDesc = membraneDesc;
        if (this.iscgs != null) {
            for (InterceptorSourceCodeGenerator iscg : this.iscgs) {
                iscg.setMembraneDesc(membraneDesc);
            }
        }
    }

    @Override
    public void setMergeable(boolean mergeable) {
        this.mergeable = mergeable;
        if (this.iscgs != null) {
            for (InterceptorSourceCodeGenerator iscg : this.iscgs) {
                iscg.setMergeable(mergeable);
            }
        }
    }

    private void updateState() {
        for (int i = 0; i < this.iscgs.length; ++i) {
            this.matches[i] = this.iscgs[i].match();
        }
    }

    @Override
    public void generateImports(FileSourceCodeVisitor fv) {
        for (int i = 0; i < this.matches.length; ++i) {
            if (!this.matches[i]) continue;
            this.iscgs[i].generateImports(fv);
        }
    }

    @Override
    public void generateConstructors(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        if (!this.mergeable) {
            MethodSourceCodeVisitor mv = cv.visitConstructor(1, null, null, null);
            mv.visitBegin();
            mv.visitEnd();
            mv = cv.visitConstructor(1, null, new String[]{"Object obj"}, null);
            mv.visitBegin();
            mv.visitln("    setFcItfDelegate(obj);");
            mv.visitEnd();
        }
    }

    @Override
    public void generateFields(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        this.generateFieldImpl(cv, proxycl);
        for (int i = 0; i < this.matches.length; ++i) {
            if (!this.matches[i]) continue;
            this.iscgs[i].generateFields(cv, proxycl);
        }
    }

    @Override
    public void generateMethods(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        this.generateMethodInitFcController(cv, proxycl);
        this.generateMethodClone(cv, proxycl);
        this.generateMethodGetFcItfDelegate(cv, proxycl);
        this.generateMethodSetFcItfDelegate(cv, proxycl);
        this.generateMethodOthers(cv, proxycl);
    }

    @Override
    public void generateProxyMethodBodyAfterCode(MethodSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
        for (int i = this.iscgs.length - 1; i >= 0; --i) {
            if (!this.matches[i]) continue;
            this.iscgs[i].generateProxyMethodBodyAfterCode(mv, proxycl, proxym);
        }
    }

    @Override
    public void generateProxyMethodBodyBeforeCode(MethodSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
        for (int i = 0; i < this.matches.length; ++i) {
            if (!this.matches[i]) continue;
            this.iscgs[i].generateProxyMethodBodyBeforeCode(mv, proxycl, proxym);
        }
    }

    @Override
    public void generateStaticParts(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        for (int i = 0; i < this.matches.length; ++i) {
            if (!this.matches[i]) continue;
            this.iscgs[i].generateStaticParts(cv, proxycl);
        }
    }

    @Override
    public void generateProxyMethodBodyFinallyCode(MethodSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
        for (int i = this.iscgs.length - 1; i >= 0; --i) {
            if (!this.matches[i]) continue;
            this.iscgs[i].generateProxyMethodBodyFinallyCode(mv, proxycl, proxym);
        }
    }

    @Override
    public String[] getClassGenericTypeParameters() {
        int size = 0;
        boolean allnull = true;
        for (int i = 0; i < this.matches.length; ++i) {
            String[] names;
            if (!this.matches[i] || (names = this.iscgs[i].getClassGenericTypeParameters()) == null) continue;
            allnull = false;
            size += names.length;
        }
        if (allnull) {
            return null;
        }
        String[] result = new String[size];
        int k = 0;
        for (int i = 0; i < this.matches.length; ++i) {
            String[] names;
            if (!this.matches[i] || (names = this.iscgs[i].getClassGenericTypeParameters()) == null) continue;
            System.arraycopy(names, 0, result, k, names.length);
            k += names.length;
        }
        return result;
    }

    @Override
    public int getClassModifiers() {
        int result = 0;
        for (int i = 0; i < this.matches.length; ++i) {
            if (!this.matches[i]) continue;
            int mods = this.iscgs[i].getClassModifiers();
            result |= mods;
        }
        return result;
    }

    @Override
    public String getDelegatingInstance(UnifiedClass proxycl, UnifiedMethod proxym) {
        return this.mergeable ? "this" : "_impl";
    }

    @Override
    public String[] getImplementedInterfaceNames() {
        HashSet<String> all = new HashSet<String>();
        boolean allnull = true;
        if (!this.mergeable) {
            all.add(Interceptor.class.getName());
            allnull = false;
        }
        for (int i = 0; i < this.matches.length; ++i) {
            String[] names;
            if (!this.matches[i] || (names = this.iscgs[i].getImplementedInterfaceNames()) == null) continue;
            allnull = false;
            all.addAll(Arrays.asList(names));
        }
        if (allnull) {
            return null;
        }
        String[] result = all.toArray(new String[all.size()]);
        return result;
    }

    @Override
    public String getClassNameSuffix() {
        StringBuffer sb = new StringBuffer();
        sb.append("Interceptor");
        for (int i = 0; i < this.matches.length; ++i) {
            if (!this.matches[i]) continue;
            String name = this.iscgs[i].getClassNameSuffix();
            sb.append(name);
        }
        return sb.toString();
    }

    @Override
    public String getSuperClassName() throws IllegalArgumentException {
        String superClassName = null;
        for (int i = 0; i < this.matches.length; ++i) {
            String name;
            if (!this.matches[i] || (name = this.iscgs[i].getSuperClassName()) == null) continue;
            if (superClassName == null) {
                superClassName = name;
                continue;
            }
            if (superClassName.equals(name)) continue;
            String msg = "Interceptor class can not extend both " + superClassName + " and " + name;
            throw new IllegalArgumentException(msg);
        }
        return superClassName;
    }

    @Override
    public boolean match() {
        for (int i = 0; i < this.matches.length; ++i) {
            if (!this.matches[i]) continue;
            return true;
        }
        return false;
    }

    public void generateFieldImpl(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        if (!this.mergeable) {
            String signature = this.jc.getInterfaceTypeSignature(this.it);
            cv.visitField(2, signature, "_impl", null);
        }
    }

    public void generateMethodInitFcController(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        if (!this.mergeable) {
            MethodSourceCodeVisitor mv = cv.visitMethod(1, null, "void", "initFcController", new String[]{InitializationContext.class.getName() + " ic"}, new String[]{InstantiationException.class.getName()});
            mv.visitBegin();
            for (int i = 0; i < this.matches.length; ++i) {
                if (!this.matches[i]) continue;
                this.iscgs[i].generateMethodInitFcController(mv, proxycl);
            }
            mv.visitEnd();
        }
    }

    public void generateMethodClone(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        if (!this.mergeable) {
            MethodSourceCodeVisitor mv = cv.visitMethod(1, null, "Object", "clone", null, null);
            mv.visitBegin();
            mv.visit("    ");
            String className = this.getClassName();
            mv.visit(className);
            mv.visit(" clone = new ");
            mv.visit(className);
            mv.visitln("(getFcItfDelegate());");
            for (int i = 0; i < this.matches.length; ++i) {
                if (!this.matches[i]) continue;
                this.iscgs[i].generateMethodClone(mv, proxycl);
            }
            mv.visitln("    return clone;");
            mv.visitEnd();
        }
    }

    public void generateMethodGetFcItfDelegate(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        if (!this.mergeable) {
            MethodSourceCodeVisitor mv = cv.visitMethod(1, null, "Object", "getFcItfDelegate", null, null);
            mv.visitBegin();
            mv.visitln("    return _impl;");
            mv.visitEnd();
        }
    }

    public void generateMethodSetFcItfDelegate(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        if (!this.mergeable) {
            MethodSourceCodeVisitor mv = cv.visitMethod(1, null, "void", "setFcItfDelegate", new String[]{"Object obj"}, null);
            mv.visitBegin();
            mv.visit("    _impl = (");
            mv.visit(this.it.getFcItfSignature());
            mv.visitln(")obj;");
            mv.visitEnd();
        }
    }

    public void generateMethodOthers(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        for (int i = 0; i < this.matches.length; ++i) {
            if (!this.matches[i]) continue;
            this.iscgs[i].generateMethodOthers(cv, proxycl);
        }
    }
}

