/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.proxy;

import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.Interceptor;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.desc.MembraneDesc;
import org.objectweb.fractal.juliac.proxy.AbstractInterceptorSourceCodeGenerator;
import org.objectweb.fractal.juliac.proxy.SimpleSourceCodeGeneratorInterceptionType;
import org.objectweb.fractal.juliac.proxy.SimpleSourceCodeGeneratorMode;
import org.objectweb.fractal.juliac.ucf.UnifiedClass;
import org.objectweb.fractal.juliac.ucf.UnifiedMethod;
import org.objectweb.fractal.juliac.visit.ClassSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.MethodSourceCodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleSourceCodeGenerator
extends AbstractInterceptorSourceCodeGenerator {
    protected abstract SimpleSourceCodeGeneratorMode getMode();

    protected abstract String getControllerInterfaceName();

    protected abstract SimpleSourceCodeGeneratorInterceptionType getInterceptionType(UnifiedMethod var1);

    protected abstract String getPreMethodName();

    protected abstract String getPostMethodName();

    protected abstract Class<?> getContextType();

    protected abstract String getMethodName(UnifiedMethod var1);

    private void checkArguments() throws IllegalArgumentException {
        String postMethodName;
        UnifiedClass ctrlImpl = this.getCtrlImpl();
        Class<?> contextType = this.getContextType();
        UnifiedMethod preMethod = null;
        String preMethodName = this.getPreMethodName();
        try {
            preMethod = ctrlImpl.getMethod(preMethodName, String.class);
        }
        catch (NoSuchMethodException nsme) {
            String msg = "No such method " + preMethodName + "(String) in " + ctrlImpl.getName();
            throw new IllegalArgumentException(msg);
        }
        if (!preMethod.getReturnType().getName().equals(contextType.getName())) {
            String msg = preMethodName + "(String) in " + ctrlImpl.getName() + " should return " + contextType.getName() + " instead of " + preMethod.getReturnType().getName();
            throw new IllegalArgumentException(msg);
        }
        UnifiedMethod[] methods = ctrlImpl.getMethods();
        boolean checkPost = false;
        for (UnifiedMethod method : methods) {
            SimpleSourceCodeGeneratorInterceptionType interceptionType = this.getInterceptionType(method);
            if (interceptionType != SimpleSourceCodeGeneratorInterceptionType.NORMAL && interceptionType != SimpleSourceCodeGeneratorInterceptionType.FINALLY) continue;
            checkPost = true;
        }
        if (checkPost) {
            postMethodName = this.getPostMethodName();
            if (postMethodName == null || postMethodName.length() == 0) {
                String msg = "postMethodName should be non empty";
                throw new IllegalArgumentException(msg);
            }
            if (contextType == Void.TYPE) {
                try {
                    ctrlImpl.getMethod(postMethodName, String.class);
                }
                catch (NoSuchMethodException nsme) {
                    String msg = "No such method " + postMethodName + "(String) in " + ctrlImpl.getName();
                    throw new IllegalArgumentException(msg);
                }
            } else {
                try {
                    ctrlImpl.getMethod(postMethodName, String.class, contextType);
                }
                catch (NoSuchMethodException nsme) {
                    String msg = "No such method " + postMethodName + "(String," + contextType.getName() + ") in " + ctrlImpl.getName();
                    throw new IllegalArgumentException(msg);
                }
            }
        } else {
            postMethodName = this.getPostMethodName();
            if (postMethodName != null) {
                String msg = "A postMethodName (" + postMethodName + ") has been defined but will never be invoked as the " + "interceptionType is EMPTY";
                Juliac.reportWarning(msg);
            }
        }
    }

    protected UnifiedClass getCtrlImpl() throws IllegalArgumentException {
        InterfaceType[] its;
        String name = this.getControllerInterfaceName();
        InterfaceType ctrlItfType = null;
        for (InterfaceType it : its = this.membraneDesc.getCtrlItfTypes()) {
            String itname = it.getFcItfName();
            if (!itname.equals(name)) continue;
            ctrlItfType = it;
        }
        if (ctrlItfType == null) {
            String msg = "No such interface " + name + " in controller descriptor " + this.membraneDesc.getDescriptor();
            throw new IllegalArgumentException(msg);
        }
        String signature = ctrlItfType.getFcItfSignature();
        UnifiedClass ctrlImpl = this.membraneDesc.getCtrlImpl(signature, this.jc);
        return ctrlImpl;
    }

    public SimpleSourceCodeGenerator(InterfaceType it, MembraneDesc<?> membraneImpl, boolean mergeable, Juliac jc) {
        super(it, membraneImpl, mergeable, jc);
    }

    public SimpleSourceCodeGenerator() {
    }

    @Override
    public boolean match() {
        String itname = this.it.getFcItfName();
        if (itname.endsWith("-controller") || itname.equals("component")) {
            return false;
        }
        SimpleSourceCodeGeneratorMode mode = this.getMode();
        boolean match = mode.match(this.it);
        return match;
    }

    @Override
    public void generateFields(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        String preMethodName = this.getPreMethodName();
        if (preMethodName == null || preMethodName.length() == 0) {
            String msg = "preMethodName should be non empty";
            throw new IllegalArgumentException(msg);
        }
        if (!this.mergeable) {
            this.checkArguments();
            UnifiedClass ctrlImpl = this.getCtrlImpl();
            cv.visitField(2, ctrlImpl.getName(), "_ctrl", null);
        }
    }

    @Override
    public void generateMethodInitFcController(MethodSourceCodeVisitor mv, UnifiedClass proxycl) {
        if (!this.mergeable) {
            UnifiedClass ctrlImpl = this.getCtrlImpl();
            mv.visit("    Object octrl = ic.getInterface(\"");
            mv.visit(this.getControllerInterfaceName());
            mv.visitln("\");");
            mv.visit("    if( ! (octrl instanceof ");
            mv.visit(ctrlImpl.getName());
            mv.visitln(") ) {");
            mv.visit("      while( octrl instanceof ");
            mv.visit(Interceptor.class.getName());
            mv.visitln(" ) {");
            mv.visit("        octrl = ((");
            mv.visit(Interceptor.class.getName());
            mv.visitln(")octrl).getFcItfDelegate();");
            mv.visitln("      }");
            mv.visitln("    }");
            mv.visit("    _ctrl = (");
            mv.visit(ctrlImpl.getName());
            mv.visitln(") octrl;");
        }
    }

    @Override
    public void generateMethodClone(MethodSourceCodeVisitor mv, UnifiedClass proxycl) {
        mv.visitln("    clone._ctrl = _ctrl;");
    }

    @Override
    public void generateMethodOthers(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        if (this.mergeable) {
            Class<?> contextType = this.getContextType();
            String preMethodName = this.getPreMethodName();
            String postMethodName = this.getPostMethodName();
            MethodSourceCodeVisitor mv = cv.visitMethod(1025, null, contextType.getName(), "_this_" + preMethodName, new String[]{String.class.getName() + " arg0"}, null);
            mv.visitEnd();
            if (postMethodName != null && postMethodName.length() != 0) {
                String[] stringArray;
                if (contextType == Void.TYPE) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = String.class.getName() + " arg0";
                } else {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = String.class.getName() + " arg0";
                    stringArray = stringArray3;
                    stringArray3[1] = contextType.getName() + " arg1";
                }
                String[] args = stringArray;
                mv = cv.visitMethod(1025, null, "void", "_this_" + postMethodName, args, null);
                mv.visitEnd();
            }
        }
    }

    @Override
    public void generateProxyMethodBodyBeforeCode(MethodSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
        Class<?> contextType = this.getContextType();
        SimpleSourceCodeGeneratorInterceptionType interceptionType = this.getInterceptionType(proxym);
        String preMethodName = this.getPreMethodName();
        mv.visit("    ");
        if (contextType != Void.TYPE) {
            mv.visit(contextType.getName());
            mv.visit(" ctx = ");
        }
        if (this.mergeable) {
            mv.visit("_this_");
        } else {
            mv.visit("_ctrl.");
        }
        mv.visitln(preMethodName + "(\"" + this.getMethodName(proxym) + "\");");
        if (interceptionType == SimpleSourceCodeGeneratorInterceptionType.FINALLY) {
            mv.visitln("    try {");
        }
    }

    @Override
    public void generateProxyMethodBodyAfterCode(MethodSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
        SimpleSourceCodeGeneratorInterceptionType interceptionType = this.getInterceptionType(proxym);
        if (interceptionType == SimpleSourceCodeGeneratorInterceptionType.NORMAL) {
            Class<?> contextType = this.getContextType();
            String postMethodName = this.getPostMethodName();
            if (postMethodName == null || postMethodName.length() == 0) {
                String msg = "postMethodName should be non empty";
                throw new IllegalArgumentException(msg);
            }
            mv.visit("    ");
            if (this.mergeable) {
                mv.visit("_this_");
            } else {
                mv.visit("_ctrl.");
            }
            mv.visit(postMethodName);
            mv.visit("(\"");
            mv.visit(this.getMethodName(proxym));
            mv.visit("\"");
            if (contextType != Void.TYPE) {
                mv.visit(",ctx");
            }
            mv.visitln(");");
        }
    }

    @Override
    public void generateProxyMethodBodyFinallyCode(MethodSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
        SimpleSourceCodeGeneratorInterceptionType interceptionType = this.getInterceptionType(proxym);
        if (interceptionType == SimpleSourceCodeGeneratorInterceptionType.FINALLY) {
            Class<?> contextType = this.getContextType();
            String postMethodName = this.getPostMethodName();
            if (postMethodName == null || postMethodName.length() == 0) {
                String msg = "postMethodName should be non empty";
                throw new IllegalArgumentException(msg);
            }
            mv.visitln("    } finally {");
            mv.visit("    ");
            if (this.mergeable) {
                mv.visit("_this_");
            } else {
                mv.visit("_ctrl.");
            }
            mv.visit(postMethodName);
            mv.visit("(\"");
            mv.visit(this.getMethodName(proxym));
            mv.visit("\"");
            if (contextType != Void.TYPE) {
                mv.visit(",ctx");
            }
            mv.visitln(");");
            mv.visitln("    }");
        }
    }
}

