/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.ucf;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.ucf.UCMethod;
import org.objectweb.fractal.juliac.ucf.UnifiedClass;
import org.objectweb.fractal.juliac.ucf.UnifiedMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UClass
implements UnifiedClass {
    private Class<?> cl;
    private Juliac jc;
    private static final Map<String, Class<?>> primitives = new HashMap<String, Class<?>>(){
        private static final long serialVersionUID = 4126982862148826431L;
        {
            this.put("boolean", Boolean.TYPE);
            this.put("char", Character.TYPE);
            this.put("byte", Byte.TYPE);
            this.put("short", Short.TYPE);
            this.put("int", Integer.TYPE);
            this.put("long", Long.TYPE);
            this.put("float", Float.TYPE);
            this.put("double", Double.TYPE);
            this.put("void", Void.TYPE);
        }
    };
    private static final Map<Class<?>, UClass> boxed = new HashMap<Class<?>, UClass>(){
        private static final long serialVersionUID = 2398856843237335831L;
        {
            this.put(Boolean.TYPE, new UClass(Boolean.class));
            this.put(Character.TYPE, new UClass(Character.class));
            this.put(Byte.TYPE, new UClass(Byte.class));
            this.put(Short.TYPE, new UClass(Short.class));
            this.put(Integer.TYPE, new UClass(Integer.class));
            this.put(Long.TYPE, new UClass(Long.class));
            this.put(Float.TYPE, new UClass(Float.class));
            this.put(Double.TYPE, new UClass(Double.class));
            this.put(Void.TYPE, new UClass(Void.class));
        }
    };
    private static final Map<Class<?>, String> nulvalues = new HashMap<Class<?>, String>(){
        private static final long serialVersionUID = -8428019352784119543L;
        {
            this.put(Boolean.TYPE, "false");
            this.put(Character.TYPE, " ");
            this.put(Byte.TYPE, "0");
            this.put(Short.TYPE, "0");
            this.put(Integer.TYPE, "0");
            this.put(Long.TYPE, "0");
            this.put(Float.TYPE, "0.0");
            this.put(Double.TYPE, "0.0");
        }
    };

    public UClass(String name, Juliac jc) throws ClassNotFoundException {
        this.jc = jc;
        ClassLoader classloader = jc.getJuliacConfig().getClassLoader();
        try {
            this.cl = classloader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            if (primitives.containsKey(name)) {
                this.cl = primitives.get(name);
                this.cl.isPrimitive();
            }
            throw new ClassNotFoundException(name);
        }
    }

    public UClass(Class<?> cl) {
        this.cl = cl;
    }

    @Override
    public UnifiedClass box() {
        if (this.cl.isPrimitive()) {
            UClass b = boxed.get(this.cl);
            return b;
        }
        return this;
    }

    @Override
    public boolean isAssignableFrom(UnifiedClass uc) {
        try {
            UClass other = this.toUClass(uc);
            boolean b = this.cl.isAssignableFrom(other.cl);
            return b;
        }
        catch (ClassNotFoundException ucnfe) {
            boolean b = uc.isAssignableTo(this);
            return b;
        }
    }

    @Override
    public boolean isAssignableTo(UnifiedClass uc) {
        try {
            UClass other = this.toUClass(uc);
            boolean b = other.cl.isAssignableFrom(this.cl);
            return b;
        }
        catch (ClassNotFoundException ucnfe) {
            return false;
        }
    }

    @Override
    public boolean isInterface() {
        boolean isInterface = this.cl.isInterface();
        return isInterface;
    }

    @Override
    public boolean isPrimitive() {
        boolean isPrimitive = this.cl.isPrimitive();
        return isPrimitive;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        A a = this.cl.getAnnotation(annotationType);
        return a;
    }

    @Override
    public UnifiedClass getDeclaringClass() {
        Class<?> dc = this.cl.getDeclaringClass();
        if (dc == null) {
            return null;
        }
        UClass udc = new UClass(dc);
        return udc;
    }

    @Override
    public UnifiedMethod[] getMethods() throws IllegalArgumentException {
        Method[] meths = this.cl.getMethods();
        UnifiedMethod[] umeths = new UnifiedMethod[meths.length];
        for (int i = 0; i < meths.length; ++i) {
            umeths[i] = new UCMethod(meths[i]);
        }
        return umeths;
    }

    @Override
    public UnifiedMethod getMethod(String name, Class<?> ... types) throws NoSuchMethodException {
        Method m = this.cl.getMethod(name, types);
        UCMethod um = new UCMethod(m);
        return um;
    }

    @Override
    public int getModifiers() {
        int mods = this.cl.getModifiers();
        return mods;
    }

    @Override
    public String getName() {
        return UClass.getName(this.cl);
    }

    @Override
    public String getNullValue() {
        if (nulvalues.containsKey(this.cl)) {
            String ret = nulvalues.get(this.cl);
            return ret;
        }
        return "null";
    }

    @Override
    public String[] getTypeParameters() {
        TypeVariable<Class<?>>[] tvs = this.cl.getTypeParameters();
        String[] rets = new String[tvs.length];
        for (int i = 0; i < tvs.length; ++i) {
            StringBuffer sb = new StringBuffer();
            sb.append(tvs[i].toString());
            Type[] bounds = tvs[i].getBounds();
            if (bounds.length != 0 && !bounds[0].equals(Object.class)) {
                sb.append(" extends ");
                for (int j = 0; j < bounds.length; ++j) {
                    if (j != 0) {
                        sb.append(" & ");
                    }
                    Type bound = bounds[j];
                    sb.append(UClass.toString(bound));
                }
            }
            rets[i] = sb.toString();
        }
        return rets;
    }

    @Override
    public String[] getTypeParameterNames() {
        TypeVariable<Class<?>>[] tvs = this.cl.getTypeParameters();
        String[] rets = new String[tvs.length];
        for (int i = 0; i < tvs.length; ++i) {
            rets[i] = tvs[i].toString();
        }
        return rets;
    }

    public String toString() {
        return this.getName();
    }

    public static String getName(Class<?> cl) {
        if (cl.isArray()) {
            Class<?> element = cl.getComponentType();
            return UClass.getName(element) + "[]";
        }
        String name = cl.getName();
        if (name.indexOf(36) != -1) {
            name = name.replace('$', '.');
        }
        return name;
    }

    private UClass toUClass(UnifiedClass uc) throws ClassNotFoundException {
        if (uc instanceof UClass) {
            return (UClass)uc;
        }
        String name = uc.getName();
        UClass other = new UClass(name, this.jc);
        return other;
    }

    static String toString(Type type) {
        if (type instanceof Class) {
            String s = UClass.getName((Class)type);
            return s;
        }
        return type.toString();
    }
}

