/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.ejb.configuration;

import java.util.ArrayList;
import java.util.List;
import org.ow2.petals.bc.ejb.configuration.ConfigurationElement;
import org.ow2.petals.component.framework.util.StringHelper;

public class DatabindingElement
implements ConfigurationElement {
    public static final String CONFIGURATION_ELEMENT_NAME = "databinding";
    private final String wsdlFileName;
    private final String serviceName;

    public DatabindingElement(String wsdlFileName, String serviceName) {
        this.wsdlFileName = wsdlFileName;
        this.serviceName = serviceName;
    }

    public final String getWsdlFileName() {
        return this.wsdlFileName;
    }

    public final String getServiceName() {
        return this.serviceName;
    }

    @Override
    public List<String> findMissingElements() {
        ArrayList<String> missingElements = new ArrayList<String>();
        if (!this.hasWsdlFileName()) {
            missingElements.add("WSDL filename");
        }
        if (!this.hasServiceName()) {
            missingElements.add("Service Name");
        }
        return missingElements;
    }

    @Override
    public List<String> findInvalidElements() {
        return null;
    }

    public String toString() {
        StringBuilder toStringSB = new StringBuilder();
        toStringSB.append("wsdlFileName=" + this.wsdlFileName);
        toStringSB.append(", ");
        toStringSB.append("serviceName=" + this.serviceName);
        return toStringSB.toString();
    }

    private final boolean hasWsdlFileName() {
        return !StringHelper.isNullOrEmpty(this.wsdlFileName);
    }

    private final boolean hasServiceName() {
        return !StringHelper.isNullOrEmpty(this.serviceName);
    }
}

