/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.ejb.configuration;

import org.ow2.petals.bc.ejb.configuration.EjbConfiguration;
import org.ow2.petals.bc.ejb.exceptions.ConfigurationException;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;

public class EjbConfigurationBuilder {
    public static EjbConfiguration buildEjbConfiguration(ConfigurationExtensions extensions, String wsdlFileName, String serviceName) throws ConfigurationException {
        String ejbHomeInterface;
        if (extensions == null) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can't create ConfigurationExtensions from the given ");
            errorSB.append("JBI descriptor content : ");
            errorSB.append(" can't create configuration extensions from the given provides.");
            throw new ConfigurationException(errorSB.toString());
        }
        String javaNamingFactoryInitial = extensions.get((Object)"java.naming.factory.initial");
        if (javaNamingFactoryInitial != null) {
            javaNamingFactoryInitial = javaNamingFactoryInitial.trim();
        }
        String javaNamingProviderUrl = extensions.get((Object)"java.naming.provider.url");
        String javaNamingFactoryUrlPkgs = extensions.get((Object)"java.naming.factory.url.pkgs");
        String ejbJndiName = extensions.get((Object)"ejb.jndi.name");
        if (ejbJndiName != null) {
            ejbJndiName = ejbJndiName.trim();
        }
        if ((ejbHomeInterface = extensions.get((Object)"ejb.home.interface")) != null) {
            ejbHomeInterface = ejbHomeInterface.trim();
        }
        String ejbVersion = extensions.get((Object)"ejb.version");
        String securityName = extensions.get((Object)"security.name");
        String securityPrincipal = extensions.get((Object)"security.principal");
        String securityCredentials = extensions.get((Object)"security.credencials");
        return new EjbConfiguration(ejbJndiName, ejbHomeInterface, ejbVersion, javaNamingFactoryInitial, javaNamingFactoryUrlPkgs, javaNamingProviderUrl, securityName, securityPrincipal, securityCredentials, wsdlFileName, serviceName);
    }
}

