/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.ejb.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.rmi.PortableRemoteObject;
import org.ow2.petals.bc.ejb.configuration.EjbConfiguration;
import org.ow2.petals.bc.ejb.configuration.SecurityElement;
import org.ow2.petals.bc.ejb.exceptions.ConfigurationException;
import org.ow2.petals.bc.ejb.exceptions.ConnectionException;

public class EjbConnection {
    private Logger logger;
    private EjbConfiguration info;
    private ClassLoader classLoader = null;

    public EjbConnection(EjbConfiguration info, ClassLoader classLoader, Logger logger) {
        this.info = info;
        this.logger = Logger.getLogger(logger.getName() + ".EjbConnection");
        this.classLoader = classLoader;
    }

    public Object retrieveObject(EjbConfiguration info) throws ConnectionException, ConfigurationException {
        Object ejb = null;
        Context initialContext = this.createInitialContext();
        String ejbVersion = info.getEjbElement().getEjbVersion();
        if (ejbVersion.equals("2.0") || ejbVersion.equals("2.1")) {
            try {
                Object ref = initialContext.lookup(info.getEjbElement().getEjbJndiName());
                Class<?> homeInterface = this.loadEjbHomeClass(info);
                Object home = PortableRemoteObject.narrow((Object)ref, homeInterface);
                ejb = this.createEjb2x(home);
            }
            catch (NamingException ex) {
                StringBuilder errorSB = new StringBuilder();
                errorSB.append("Can't retrieve EJB 2.x for name : ");
                errorSB.append(info.getEjbElement().getEjbJndiName());
                errorSB.append(" from the given context : ");
                errorSB.append(initialContext.toString());
                this.logger.log(Level.SEVERE, errorSB.toString(), ex);
                throw new ConnectionException(errorSB.toString(), ex);
            }
        } else if (ejbVersion.equals("3.0") || ejbVersion.equals("3.1")) {
            try {
                ejb = initialContext.lookup(info.getEjbElement().getEjbJndiName());
            }
            catch (NamingException ex) {
                StringBuilder errorSB = new StringBuilder();
                errorSB.append("Can't retrieve EJB 3.x for name : ");
                errorSB.append(info.getEjbElement().getEjbJndiName());
                errorSB.append(" from the given context : ");
                errorSB.append(initialContext.toString());
                this.logger.log(Level.SEVERE, errorSB.toString(), ex);
                throw new ConnectionException(errorSB.toString(), ex);
            }
        } else {
            throw new ConnectionException("Unknown EJB version");
        }
        StringBuilder logMsgBuilder = new StringBuilder();
        logMsgBuilder.append("Lookup successfully the EJB : ");
        logMsgBuilder.append(info.getEjbElement().getEjbJndiName());
        logMsgBuilder.append(" (EJB class : " + ejb.getClass().getName() + ")");
        this.logger.log(Level.INFO, logMsgBuilder.toString());
        return ejb;
    }

    public Context createInitialContext() throws ConnectionException, ConfigurationException {
        Properties environment = new Properties();
        environment.put("java.naming.provider.url", this.info.getAppServerElement().getJavaNamingProviderUrl());
        environment.put("java.naming.factory.initial", this.info.getAppServerElement().getJavaNamingFactoryInitial());
        if (this.info.getAppServerElement().hasJavaNamingFactoryUrlPkgs()) {
            environment.put("java.naming.factory.url.pkgs", this.info.getAppServerElement().getJavaNamingFactoryUrlPkgs());
        }
        if (this.info.hasSecurityElement()) {
            SecurityElement securityElement = this.info.getSecurityElement();
            String securityPrincipal = securityElement.getSecurityPrincipal();
            String securityCredentials = securityElement.getSecurityCredentials();
            if (securityPrincipal != null && !securityPrincipal.equals("") && securityCredentials != null && !securityCredentials.equals("")) {
                environment.put("java.naming.security.principal", securityPrincipal);
                environment.put("java.naming.security.credentials", securityCredentials);
            }
        }
        return this.createJNDIContext(environment);
    }

    private Context createJNDIContext(Properties properties) throws ConnectionException {
        Context initialContext = null;
        Class<?> initialContextFactoryClass = null;
        InitialContextFactory initialContextFactoryInstance = null;
        try {
            initialContextFactoryClass = this.classLoader.loadClass(properties.getProperty("java.naming.factory.initial"));
            initialContextFactoryInstance = (InitialContextFactory)initialContextFactoryClass.newInstance();
            initialContext = initialContextFactoryInstance.getInitialContext(properties);
        }
        catch (NamingException ex) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can't create initial context : ");
            errorSB.append("can't get initial context from the initial context factory instance : ");
            errorSB.append(properties.getProperty("java.naming.factory.initial"));
            errorSB.append(" : NamingException.");
            this.logger.log(Level.SEVERE, errorSB.toString(), ex);
            throw new ConnectionException(errorSB.toString(), ex);
        }
        catch (InstantiationException ex) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can't create initial context : ");
            errorSB.append("can't instanciate the initial context factory class : ");
            errorSB.append(properties.getProperty("java.naming.factory.initial"));
            errorSB.append(" : InstantiationException.");
            this.logger.log(Level.SEVERE, errorSB.toString(), ex);
            throw new ConnectionException(errorSB.toString(), ex);
        }
        catch (IllegalAccessException ex) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can't create initial context : ");
            errorSB.append("can't instanciate the initial context factory class : ");
            errorSB.append(properties.getProperty("java.naming.factory.initial"));
            errorSB.append(" : IllegalAccessException.");
            this.logger.log(Level.SEVERE, errorSB.toString(), ex);
            throw new ConnectionException(errorSB.toString(), ex);
        }
        catch (ClassNotFoundException ex) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can't create initial context : ");
            errorSB.append("can't load the initial context factory class : ");
            errorSB.append(properties.getProperty("java.naming.factory.initial"));
            errorSB.append(" : ClassNotFoundException.");
            this.logger.log(Level.SEVERE, errorSB.toString(), ex);
            throw new ConnectionException(errorSB.toString(), ex);
        }
        return initialContext;
    }

    private Class<?> loadEjbHomeClass(EjbConfiguration info) throws ConnectionException, ConfigurationException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = null;
        try {
            clazz = cl.loadClass(info.getEjbElement().getEjbHomeInterface());
        }
        catch (ClassNotFoundException ex) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can't load EJB Remote Home Interface");
            errorSB.append(ex.getCause());
            this.logger.log(Level.SEVERE, errorSB.toString(), ex);
            throw new ConnectionException(errorSB.toString(), ex);
        }
        return clazz;
    }

    private Object createEjb2x(Object home) throws ConnectionException {
        Method ejbCreateMethod = null;
        try {
            ejbCreateMethod = home.getClass().getMethod("create", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can't create an EJB stub from the given EJB RemoteHome interface ");
            errorSB.append("(" + home.getClass() + ") : ");
            errorSB.append("Your home interface must define a create() method without arguments : ");
            errorSB.append(ex.getCause());
            this.logger.log(Level.SEVERE, errorSB.toString(), ex);
            throw new ConnectionException(errorSB.toString(), ex);
        }
        catch (SecurityException ex) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can't create an EJB stub from the given EJB RemoteHome interface ");
            errorSB.append("(" + home.getClass() + ") : ");
            errorSB.append("Security error : ");
            errorSB.append(ex.getCause());
            this.logger.log(Level.SEVERE, errorSB.toString(), ex);
            throw new ConnectionException(errorSB.toString());
        }
        Object ejb2Object = null;
        try {
            ejb2Object = ejbCreateMethod.invoke(home, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can't create an EJB stub from the given EJB RemoteHome interface ");
            errorSB.append("(" + home.getClass() + ") : ");
            errorSB.append("IllegalAccess : ");
            errorSB.append(ex.getCause());
            this.logger.log(Level.SEVERE, errorSB.toString(), ex);
            throw new ConnectionException(errorSB.toString(), ex);
        }
        catch (IllegalArgumentException ex) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can't create an EJB stub from the given EJB RemoteHome interface ");
            errorSB.append("(" + home.getClass() + ") : ");
            errorSB.append("IllegalArgument : ");
            errorSB.append(ex.getCause());
            this.logger.log(Level.SEVERE, errorSB.toString(), ex);
            throw new ConnectionException(errorSB.toString(), ex);
        }
        catch (InvocationTargetException ex) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can't create an EJB stub from the given EJB RemoteHome interface ");
            errorSB.append("(" + home.getClass() + ") : ");
            errorSB.append("InvocationTarget : ");
            errorSB.append(ex.getCause());
            this.logger.log(Level.SEVERE, errorSB.toString(), ex);
            throw new ConnectionException(errorSB.toString(), ex);
        }
        return ejb2Object;
    }
}

