/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.ejb.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessagingException;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.ow2.petals.bc.ejb.EjbComponent;
import org.ow2.petals.bc.ejb.EjbConnectionPoolElement;
import org.ow2.petals.bc.ejb.configuration.EjbConfiguration;
import org.ow2.petals.bc.ejb.exceptions.AuthenticationException;
import org.ow2.petals.bc.ejb.exceptions.ConfigurationException;
import org.ow2.petals.bc.ejb.exceptions.EjbConnectionPoolException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.util.SourceUtilImpl;
import org.ow2.petals.databinding.jaxb.DataBindingException;
import org.ow2.petals.databinding.jaxb.service.Service;
import org.w3c.dom.Document;

public class EjbService {
    private final Logger logger;
    private final EjbComponent component;

    public EjbService(Logger logger, EjbComponent ejbComponent) {
        this.logger = logger;
        this.component = ejbComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void callEjb(Provides provides, Exchange exchange) throws JBIException {
        if (!exchange.isInOutPattern() && !exchange.isInOptionalOutPattern()) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Supported exchange pattern are IN-OUT and IN-OPTIONAL-OUT.");
            this.logger.log(Level.SEVERE, errorSB.toString());
            throw new JBIException(errorSB.toString());
        }
        if (!exchange.getInMessageAttachments().isEmpty()) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("No attachement expected.");
            this.logger.log(Level.SEVERE, errorSB.toString());
            throw new JBIException(errorSB.toString());
        }
        EjbConnectionPoolElement poolElement = this.retrieveEjbConnectionPoolElementFromProvides(provides);
        ClassLoader suClassLoader = poolElement.getSuClassLoader();
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(suClassLoader);
        LoginContext loginContext = null;
        try {
            Document requestDocument = this.retrieveRequestDocumentFromExchange(exchange);
            String operation = this.retrieveOperationFromExchange(exchange);
            Subject subject = exchange.getInMessage().getSecuritySubject();
            if (subject != null) {
                loginContext = this.login(poolElement.getEjbConfiguration(), subject);
            }
            this.callEjbUsingJAXB(poolElement, operation, requestDocument, exchange);
            Thread.currentThread().setContextClassLoader(oldCL);
            if (loginContext == null) return;
        }
        catch (Throwable throwable) {
            Thread.currentThread().setContextClassLoader(oldCL);
            if (loginContext == null) throw throwable;
            this.logout(loginContext);
            throw throwable;
        }
        this.logout(loginContext);
    }

    private String retrieveOperationFromExchange(Exchange exchange) throws JBIException {
        QName operation = exchange.getOperation();
        String operationName = null;
        if (operation != null) {
            operationName = operation.getLocalPart();
        }
        if (operationName == null || "".equals(operationName)) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("No operation found on the message exchange.");
            this.logger.log(Level.SEVERE, errorSB.toString());
            throw new JBIException(errorSB.toString());
        }
        return operationName;
    }

    private Document retrieveRequestDocumentFromExchange(Exchange exchange) throws JBIException {
        Document requestDocument = null;
        try {
            requestDocument = exchange.getInMessageContentAsDocument();
        }
        catch (MessagingException ex) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can't retireve message content for exchange : ");
            errorSB.append(exchange.getExchangeId());
            errorSB.append(" : Messaging error : ");
            this.logger.log(Level.SEVERE, errorSB.toString(), ex);
            throw new JBIException(errorSB.toString(), (Throwable)ex);
        }
        return requestDocument;
    }

    private EjbConnectionPoolElement retrieveEjbConnectionPoolElementFromProvides(Provides provides) throws JBIException {
        EjbConnectionPoolElement poolElement = null;
        try {
            poolElement = this.component.getEjbConnectionPool().getEjb(provides);
        }
        catch (EjbConnectionPoolException ex) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can't retireve the EJB from the given provides : ");
            errorSB.append(provides.toString());
            this.logger.log(Level.SEVERE, errorSB.toString(), ex);
            throw new JBIException(errorSB.toString(), (Throwable)ex);
        }
        return poolElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callEjbUsingJAXB(EjbConnectionPoolElement poolElement, String operation, Document requestDocument, Exchange exchange) throws JBIException {
        Service jbiService = null;
        try {
            DOMSource messageRequest = new DOMSource(requestDocument);
            jbiService = poolElement.getDatabindingService();
            Document messageResult = null;
            Object[] methodParamValue = null;
            Method methodToInvoke = null;
            Object methodResult = null;
            Service service = jbiService;
            synchronized (service) {
                methodParamValue = jbiService.getServiceUnmarshaller().unmarshallMethodParam(jbiService.getOperationByName(operation), (Source)messageRequest);
                if (methodParamValue != null) {
                    methodToInvoke = poolElement.getEjbObject().getClass().getMethod(operation, jbiService.getOperationByName(operation).getParameterTypes());
                    if (this.checkParameters(methodParamValue, jbiService.getOperationByName(operation).getParameterTypes())) {
                        methodResult = methodToInvoke.invoke(poolElement.getEjbObject(), methodParamValue);
                    } else {
                        StringBuilder errorSB = new StringBuilder();
                        errorSB.append("Cannot invoke the operation: ");
                        errorSB.append(operation);
                        errorSB.append(". Parameters are not compatible with method signature: ");
                        this.logger.log(Level.SEVERE, errorSB.toString());
                        throw new JBIException(errorSB.toString());
                    }
                }
                if ((messageResult = jbiService.getServiceMarshaller().marshallMethodResult(jbiService.getOperationByName(operation), new Object[]{methodResult})) != null) {
                    exchange.setOutMessageContent(messageResult);
                }
            }
        }
        catch (IllegalAccessException ex) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Cannot invoke the operation: ");
            errorSB.append(operation);
            errorSB.append(". Illegal Access error: ");
            this.logger.log(Level.SEVERE, errorSB.toString(), ex);
            throw new JBIException(errorSB.toString(), (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() != null && this.isInstanceOf(ex.getCause(), jbiService.getOperationByName(operation).getExceptionType())) {
                Document exception = null;
                try {
                    exception = jbiService.getServiceMarshaller().marshallMethodException(jbiService.getOperationByName(operation), (Exception)ex.getCause());
                }
                catch (DataBindingException e) {
                    throw new JBIException((Throwable)e);
                }
                Fault fault = exchange.createFault();
                SourceUtilImpl sourceUtil = new SourceUtilImpl();
                fault.setContent((Source)sourceUtil.createDOMSource(exception));
                exchange.setFault(fault);
            }
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Cannot invoke the operation: ");
            errorSB.append(operation);
            errorSB.append(". Target Invocation error: ");
            this.logger.log(Level.SEVERE, errorSB.toString(), ex);
            throw new JBIException(errorSB.toString(), (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Cannot invoke the operation: ");
            errorSB.append(operation);
            errorSB.append(". No Such Method error: ");
            this.logger.log(Level.SEVERE, errorSB.toString(), ex);
            throw new JBIException(errorSB.toString(), (Throwable)ex);
        }
        catch (DataBindingException ex) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Cannot unmarshall the request or marshall the response for the operation: ");
            errorSB.append(operation);
            errorSB.append(". Data-Binding error: ");
            this.logger.log(Level.SEVERE, errorSB.toString(), ex);
            throw new JBIException(errorSB.toString(), (Throwable)ex);
        }
    }

    private boolean checkParameters(Object[] methodParamValue, Class<?>[] parameterTypes) {
        int paramIndex = 0;
        for (Class<?> parameterType : parameterTypes) {
            if (methodParamValue[paramIndex] != null) {
                Class<?> updatedParamClass = this.getAdaptedClass(methodParamValue[paramIndex].getClass());
                Class<?> updatedParameterType = this.getAdaptedClass(parameterType);
                if (!updatedParameterType.isAssignableFrom(updatedParamClass)) {
                    return false;
                }
            }
            ++paramIndex;
        }
        return true;
    }

    private Class<?> getAdaptedClass(Class<?> _class) {
        Class updatedClass = _class.getName().equals("int") ? Integer.class : (_class.getName().equals("double") ? Double.class : (_class.getName().equals("float") ? Float.class : (_class.getName().equals("short") ? Short.class : (_class.getName().equals("long") ? Long.class : (_class.getName().equals("boolean") ? Boolean.class : (_class.getName().equals("byte") ? Byte.class : _class))))));
        return updatedClass;
    }

    private LoginContext login(EjbConfiguration ejbConfiguration, Subject subject) throws JBIException {
        try {
            LoginContext loginContext = null;
            String securityName = ejbConfiguration.getSecurityElement().getSecurityName();
            if (securityName != null) {
                try {
                    loginContext = new LoginContext(securityName, subject);
                }
                catch (LoginException ex) {
                    StringBuilder errorSB = new StringBuilder();
                    errorSB.append("Cannot instantiate login context: ");
                    this.logger.log(Level.SEVERE, errorSB.toString(), ex);
                    throw new AuthenticationException(errorSB.toString(), ex);
                }
                if (loginContext != null) {
                    try {
                        loginContext.login();
                    }
                    catch (LoginException ex) {
                        StringBuilder errorSB = new StringBuilder();
                        errorSB.append("Cannot perform login operation: ");
                        this.logger.log(Level.SEVERE, errorSB.toString(), ex);
                        throw new AuthenticationException(errorSB.toString(), ex);
                    }
                }
            }
            return loginContext;
        }
        catch (ConfigurationException ex) {
            throw new JBIException((Throwable)ex);
        }
        catch (AuthenticationException ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    private void logout(LoginContext loginContext) throws JBIException {
        try {
            try {
                loginContext.logout();
            }
            catch (LoginException ex) {
                StringBuilder errorSB = new StringBuilder();
                errorSB.append("Cannot perform logout operation: ");
                this.logger.log(Level.SEVERE, errorSB.toString(), ex);
                throw new AuthenticationException(errorSB.toString(), ex);
            }
        }
        catch (AuthenticationException ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    private boolean isInstanceOf(Throwable e, Class<?>[] exceptionTypes) {
        for (Class<?> exceptionType : exceptionTypes) {
            if (!e.getClass().equals(exceptionType)) continue;
            return true;
        }
        return false;
    }
}

