/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.commons.threadlocal;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;

public final class Transformers {
    private static final ThreadLocal<Transformer> defaultTransformerThreadLocal = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            try {
                return TransformerFactory.newInstance().newTransformer();
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException("Failed to create Transformer", e);
            }
        }
    };
    private static final ThreadLocal<Transformer> jvmTransformerThreadLocal = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
                Thread.currentThread().setContextClassLoader(systemClassLoader);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                return transformer;
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException("Failed to create Transformer", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
    };

    public static final Transformer getDefaultTransformer() {
        return defaultTransformerThreadLocal.get();
    }

    public static final Transformer getXmlWithDeclarationTransformer() {
        Transformer t = defaultTransformerThreadLocal.get();
        t.setOutputProperty("omit-xml-declaration", "no");
        t.setOutputProperty("method", "xml");
        return t;
    }

    public static final Transformer getXmlWithoutDeclarationTransformer() {
        Transformer t = defaultTransformerThreadLocal.get();
        t.setOutputProperty("omit-xml-declaration", "yes");
        t.setOutputProperty("method", "xml");
        return t;
    }

    public static final Transformer getWithoutDeclarationTransformer() {
        Transformer t = defaultTransformerThreadLocal.get();
        t.setOutputProperty("omit-xml-declaration", "yes");
        return t;
    }
}

