/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.control.binding;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.SuperController;
import org.objectweb.fractal.api.type.InterfaceType;

public class Util {
    private Util() {
    }

    public static Set getFcClientItfsBoundTo(Interface serverItf) throws Exception {
        HashSet result = new HashSet();
        Object[] comps = Util.getFcPotentialClientsOf(serverItf).toArray();
        int i = 0;
        while (i < comps.length) {
            Component comp = (Component)comps[i];
            List clientItfs = Util.getFcClientItfsBoundTo(comp, serverItf);
            int j = 0;
            while (j < clientItfs.size()) {
                result.add(clientItfs.get(j));
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static Set getFcPotentialClientsOf(Interface serverItf) throws Exception {
        HashSet<Component> compSet = new HashSet<Component>();
        Component serverComp = serverItf.getFcItfOwner();
        if (serverItf.isFcInternalItf()) {
            ContentController cc;
            try {
                cc = (ContentController)serverComp.getFcInterface("content-controller");
            }
            catch (NoSuchInterfaceException e) {
                throw new Exception("Cannot create shortcuts");
            }
            Component[] comps = cc.getFcSubComponents();
            int i = 0;
            while (i < comps.length) {
                compSet.add(comps[i]);
                ++i;
            }
            compSet.add(serverComp);
        } else {
            SuperController sc;
            try {
                sc = (SuperController)serverComp.getFcInterface("super-controller");
            }
            catch (NoSuchInterfaceException e) {
                throw new Exception("Cannot create shortcuts");
            }
            Component[] superComps = sc.getFcSuperComponents();
            int i = 0;
            while (i < superComps.length) {
                ContentController cc;
                compSet.add(superComps[i]);
                try {
                    cc = (ContentController)superComps[i].getFcInterface("content-controller");
                }
                catch (NoSuchInterfaceException e) {
                    throw new Exception("Cannot create shortcuts");
                }
                Component[] subComps = cc.getFcSubComponents();
                int j = 0;
                while (j < subComps.length) {
                    compSet.add(subComps[j]);
                    ++j;
                }
                ++i;
            }
        }
        return compSet;
    }

    public static List getFcClientItfsBoundTo(Component component, Interface serverItf) throws Exception {
        ContentController cc;
        BindingController bc;
        ArrayList<Interface> itfList = new ArrayList<Interface>();
        try {
            bc = (BindingController)component.getFcInterface("binding-controller");
        }
        catch (NoSuchInterfaceException e) {
            return itfList;
        }
        Object[] itfs = component.getFcInterfaces();
        int i = 0;
        while (i < itfs.length) {
            block18: {
                InterfaceType itfType;
                Interface itf;
                try {
                    itf = (Interface)itfs[i];
                    itfType = (InterfaceType)itf.getFcItfType();
                }
                catch (ClassCastException e) {
                    throw new Exception("Cannot create shortcuts");
                }
                if (itfType.isFcClientItf()) {
                    Object sItf;
                    try {
                        sItf = bc.lookupFc(itf.getFcItfName());
                    }
                    catch (NoSuchInterfaceException e) {
                        break block18;
                    }
                    if (serverItf.equals(sItf)) {
                        itfList.add(itf);
                    }
                }
            }
            ++i;
        }
        try {
            cc = (ContentController)component.getFcInterface("content-controller");
        }
        catch (NoSuchInterfaceException e) {
            return itfList;
        }
        itfs = cc.getFcInternalInterfaces();
        int i2 = 0;
        while (i2 < itfs.length) {
            block19: {
                InterfaceType itfType;
                Interface itf;
                try {
                    itf = (Interface)itfs[i2];
                    itfType = (InterfaceType)itf.getFcItfType();
                }
                catch (ClassCastException e) {
                    throw new Exception("Cannot create shortcuts");
                }
                if (itfType.isFcClientItf()) {
                    Object sItf;
                    try {
                        sItf = bc.lookupFc(itf.getFcItfName());
                    }
                    catch (NoSuchInterfaceException e) {
                        break block19;
                    }
                    if (serverItf.equals(sItf)) {
                        itfList.add(itf);
                    }
                }
            }
            ++i2;
        }
        return itfList;
    }
}

