/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.ejb;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.petals.bc.ejb.EjbConnectionPoolElement;
import org.ow2.petals.bc.ejb.exceptions.EjbConnectionPoolException;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;

public class EjbConnectionPool {
    private final Logger logger;
    private ConcurrentMap<Provides, EjbConnectionPoolElement> ejbPool;

    public EjbConnectionPool(Logger logger) {
        this.logger = logger;
        this.ejbPool = new ConcurrentHashMap<Provides, EjbConnectionPoolElement>();
    }

    public void addEjb(Provides provides, EjbConnectionPoolElement poolElement) throws EjbConnectionPoolException {
        if (this.ejbPool.containsKey(provides)) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("EJB : ");
            errorSB.append(poolElement.getEjbConfiguration().toString());
            errorSB.append(" already registrered.");
            this.logger.log(Level.SEVERE, errorSB.toString());
            throw new EjbConnectionPoolException(errorSB.toString());
        }
        this.ejbPool.putIfAbsent(provides, poolElement);
    }

    public EjbConnectionPoolElement getEjb(Provides provides) throws EjbConnectionPoolException {
        if (!this.ejbPool.containsKey(provides)) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can't find EJB for provides : ");
            errorSB.append(provides.toString());
            this.logger.log(Level.SEVERE, errorSB.toString());
            throw new EjbConnectionPoolException(errorSB.toString());
        }
        EjbConnectionPoolElement poolElement = (EjbConnectionPoolElement)this.ejbPool.get(provides);
        if (poolElement == null) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can't find EJB for provides : ");
            errorSB.append(provides);
            this.logger.log(Level.SEVERE, errorSB.toString());
            throw new EjbConnectionPoolException(errorSB.toString());
        }
        return poolElement;
    }

    public void removeEjb(Provides provides) throws EjbConnectionPoolException {
        if (!this.ejbPool.containsKey(provides)) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can't find EJB for provides : ");
            errorSB.append(provides);
            this.logger.log(Level.SEVERE, errorSB.toString());
            throw new EjbConnectionPoolException(errorSB.toString());
        }
        this.ejbPool.remove(provides);
    }
}

