/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.ejb.configuration;

import java.util.ArrayList;
import java.util.List;
import org.ow2.petals.bc.ejb.configuration.ConfigurationElement;
import org.ow2.petals.component.framework.util.StringHelper;

public class AppServerElement
implements ConfigurationElement {
    public static final String CONFIGURATION_ELEMENT_NAME = "appserver";
    private final String javaNamingFactoryInitial;
    private final String javaNamingProviderUrl;
    private final String javaNamingFactoryUrlPkgs;

    public AppServerElement(String javaNamingFactoryInitial, String javaNamingFactoryUrlPkgs, String javaNamingProviderUrl) {
        this.javaNamingFactoryInitial = javaNamingFactoryInitial;
        this.javaNamingFactoryUrlPkgs = javaNamingFactoryUrlPkgs;
        this.javaNamingProviderUrl = javaNamingProviderUrl;
    }

    public final String getJavaNamingFactoryInitial() {
        return this.javaNamingFactoryInitial;
    }

    public final String getJavaNamingFactoryUrlPkgs() {
        return this.javaNamingProviderUrl;
    }

    public final boolean hasJavaNamingFactoryUrlPkgs() {
        return this.javaNamingFactoryUrlPkgs == null;
    }

    public final String getJavaNamingProviderUrl() {
        return this.javaNamingProviderUrl;
    }

    @Override
    public List<String> findMissingElements() {
        ArrayList<String> missingElements = new ArrayList<String>();
        if (!this.hasJavaNamingFactoryInitial()) {
            missingElements.add("java.naming.factory.initial");
        }
        if (!this.hasJavaNamingProviderUrl()) {
            missingElements.add("java.naming.provider.url");
        }
        return missingElements;
    }

    @Override
    public List<String> findInvalidElements() {
        ArrayList<String> invalidElements = new ArrayList<String>();
        return invalidElements;
    }

    public String toString() {
        StringBuilder toStringSB = new StringBuilder();
        toStringSB.append("javaNamingFactoryInitial=" + this.javaNamingFactoryInitial);
        toStringSB.append(", ");
        toStringSB.append("javaNamingFactoryUrlPkgs=" + this.javaNamingFactoryUrlPkgs);
        toStringSB.append(", ");
        toStringSB.append("javaNamingProviderUrl=" + this.javaNamingProviderUrl);
        return toStringSB.toString();
    }

    private final boolean hasJavaNamingFactoryInitial() {
        return !StringHelper.isNullOrEmpty((String)this.javaNamingFactoryInitial);
    }

    private final boolean hasJavaNamingProviderUrl() {
        return !StringHelper.isNullOrEmpty((String)this.javaNamingProviderUrl);
    }
}

