/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.ejb.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.petals.bc.ejb.configuration.AppServerElement;
import org.ow2.petals.bc.ejb.configuration.ConfigurationElement;
import org.ow2.petals.bc.ejb.configuration.DatabindingElement;
import org.ow2.petals.bc.ejb.configuration.EjbElement;
import org.ow2.petals.bc.ejb.configuration.SecurityElement;
import org.ow2.petals.bc.ejb.exceptions.ConfigurationException;
import org.ow2.petals.component.framework.util.StringHelper;

public class EjbConfiguration {
    private Map<String, ConfigurationElement> ejbConfigurationElements = new HashMap<String, ConfigurationElement>();

    public EjbConfiguration(String ejbJndiName, String ejbHomeInterface, String ejbVersion, String javaNamingFactoryInitial, String javaNamingFactoryUrlPkgs, String javaNamingProviderUrl, String securityName, String securityPrincipal, String securityCredentials, String wsdlFileName, String serviceName) throws ConfigurationException {
        EjbElement ejbElement = new EjbElement(ejbJndiName, ejbHomeInterface, ejbVersion);
        this.ejbConfigurationElements.put("info", ejbElement);
        AppServerElement appServerElement = new AppServerElement(javaNamingFactoryInitial, javaNamingFactoryUrlPkgs, javaNamingProviderUrl);
        this.ejbConfigurationElements.put("appserver", appServerElement);
        SecurityElement securityElement = null;
        if (!StringHelper.isNullOrEmpty((String)securityName)) {
            securityElement = new SecurityElement();
            securityElement.setSecurityName(securityName);
        }
        if (!StringHelper.isNullOrEmpty((String)securityPrincipal) || !StringHelper.isNullOrEmpty((String)securityCredentials)) {
            securityElement = securityElement != null ? securityElement : new SecurityElement();
            securityElement.setSecurityPrincipal(securityPrincipal);
            securityElement.setSecurityCredentials(securityCredentials);
        }
        if (securityElement != null) {
            this.ejbConfigurationElements.put("security", securityElement);
        }
        this.ejbConfigurationElements.put("databinding", new DatabindingElement(wsdlFileName, serviceName));
        this.validate();
    }

    public EjbElement getEjbElement() throws ConfigurationException {
        ConfigurationElement supposedEjbElement = this.ejbConfigurationElements.get("info");
        if (supposedEjbElement != null && supposedEjbElement instanceof EjbElement) {
            return (EjbElement)supposedEjbElement;
        }
        StringBuilder errorSB = new StringBuilder();
        errorSB.append("Can't retrieve the EjbElement from the EjbConnectionInfo instance.");
        throw new ConfigurationException(errorSB.toString());
    }

    public AppServerElement getAppServerElement() throws ConfigurationException {
        ConfigurationElement supposedAppServerElement = this.ejbConfigurationElements.get("appserver");
        if (supposedAppServerElement != null && supposedAppServerElement instanceof AppServerElement) {
            return (AppServerElement)supposedAppServerElement;
        }
        StringBuilder errorSB = new StringBuilder();
        errorSB.append("Can't retrieve the AppServerElement from the EjbConnectionInfo instance.");
        throw new ConfigurationException(errorSB.toString());
    }

    public SecurityElement getSecurityElement() throws ConfigurationException {
        if (this.hasSecurityElement()) {
            ConfigurationElement supposedSecurityElement = this.ejbConfigurationElements.get("security");
            if (supposedSecurityElement != null && supposedSecurityElement instanceof SecurityElement) {
                return (SecurityElement)supposedSecurityElement;
            }
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can't retrieve the SecurityElement from the EJB configuration.");
            throw new ConfigurationException(errorSB.toString());
        }
        return null;
    }

    public DatabindingElement getDatabindingElement() throws ConfigurationException {
        ConfigurationElement supposedDatabindingElement = this.ejbConfigurationElements.get("databinding");
        if (supposedDatabindingElement instanceof DatabindingElement) {
            return (DatabindingElement)supposedDatabindingElement;
        }
        StringBuilder errorSB = new StringBuilder();
        errorSB.append("Can't retrieve the DatabindingElement from the EJB configuration.");
        throw new ConfigurationException(errorSB.toString());
    }

    public boolean hasSecurityElement() {
        if (!this.ejbConfigurationElements.containsKey("security")) {
            return false;
        }
        ConfigurationElement supposedSecurityElement = this.ejbConfigurationElements.get("security");
        if (supposedSecurityElement == null) {
            return false;
        }
        return supposedSecurityElement instanceof SecurityElement;
    }

    public void validate() throws ConfigurationException {
        StringBuilder errorSB = new StringBuilder();
        StringBuilder missingElementsSB = new StringBuilder("missing configuration element(s) : ");
        StringBuilder invalidElementsSB = new StringBuilder("invalid configuration element(s) : ");
        ArrayList<String> missingElements = new ArrayList<String>();
        ArrayList<String> invalidElements = new ArrayList<String>();
        for (Map.Entry<String, ConfigurationElement> entry : this.ejbConfigurationElements.entrySet()) {
            List<String> els = entry.getValue().findMissingElements();
            if (els != null) {
                missingElements.addAll(els);
            }
            if ((els = entry.getValue().findInvalidElements()) == null) continue;
            invalidElements.addAll(els);
        }
        for (String missingElement : missingElements) {
            missingElementsSB.append(missingElement + ", ");
        }
        for (String invalidElement : invalidElements) {
            invalidElementsSB.append(invalidElement + ", ");
        }
        if (!missingElements.isEmpty() || !invalidElements.isEmpty()) {
            errorSB.append("Can't create ConfigurationExtensions from the given ");
            errorSB.append("JBI descriptor content : ");
            if (!missingElements.isEmpty()) {
                errorSB.append(missingElementsSB.toString());
            }
            if (!invalidElements.isEmpty()) {
                errorSB.append(invalidElementsSB.toString());
            }
            throw new ConfigurationException(errorSB.toString());
        }
    }

    public String toString() {
        StringBuilder toStringSB = new StringBuilder();
        for (Map.Entry<String, ConfigurationElement> entry : this.ejbConfigurationElements.entrySet()) {
            toStringSB.append(entry.getKey() + " : ");
            toStringSB.append(entry.getValue().toString());
            toStringSB.append("\n");
        }
        return toStringSB.toString();
    }
}

