/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.ejb.configuration;

import java.util.ArrayList;
import java.util.List;
import org.ow2.petals.bc.ejb.configuration.ConfigurationElement;
import org.ow2.petals.component.framework.util.StringHelper;

public class EjbElement
implements ConfigurationElement {
    public static final String CONFIGURATION_ELEMENT_NAME = "info";
    private final String ejbJndiName;
    private final String ejbHomeInterface;
    private final String ejbVersion;

    public EjbElement(String ejbJndiName, String ejbHomeInterface, String ejbVersion) {
        this.ejbJndiName = ejbJndiName;
        this.ejbHomeInterface = ejbHomeInterface;
        this.ejbVersion = ejbVersion;
    }

    public final String getEjbJndiName() {
        return this.ejbJndiName;
    }

    public final String getEjbHomeInterface() {
        return this.ejbHomeInterface;
    }

    public final String getEjbVersion() {
        return this.ejbVersion;
    }

    public final boolean isEJB2x() {
        if (this.hasEjbVersion() && this.hasValidEjbVersion()) {
            if (this.ejbVersion.equals("2.0")) {
                return true;
            }
            return this.ejbVersion.equals("2.1");
        }
        return false;
    }

    public final boolean isEJB3x() {
        if (this.hasEjbVersion() && this.hasValidEjbVersion()) {
            if (this.ejbVersion.equals("3.0")) {
                return true;
            }
            return this.ejbVersion.equals("3.1");
        }
        return false;
    }

    @Override
    public List<String> findMissingElements() {
        ArrayList<String> missingElements = new ArrayList<String>();
        if (!this.hasEjbJndiName()) {
            missingElements.add("ejb.jndi.name");
        }
        if (!this.hasEjbVersion()) {
            missingElements.add("ejb.version");
        }
        if (this.isEJB2x() && !this.hasEjbHomeInterface()) {
            missingElements.add("ejb.home.interface");
        }
        return missingElements;
    }

    @Override
    public List<String> findInvalidElements() {
        ArrayList<String> invalidElements = new ArrayList<String>();
        if (this.hasEjbVersion() && !this.hasValidEjbVersion()) {
            invalidElements.add("ejb.version");
        }
        return invalidElements;
    }

    public String toString() {
        StringBuilder toStringSB = new StringBuilder();
        toStringSB.append("ejbJndiName=" + this.ejbJndiName);
        toStringSB.append(", ");
        toStringSB.append("ejbHomeInterface=" + this.ejbHomeInterface);
        toStringSB.append(", ");
        toStringSB.append("ejbVersion=" + this.ejbVersion);
        return toStringSB.toString();
    }

    private final boolean hasEjbJndiName() {
        return !StringHelper.isNullOrEmpty((String)this.ejbJndiName);
    }

    private final boolean hasEjbHomeInterface() {
        return !StringHelper.isNullOrEmpty((String)this.ejbHomeInterface);
    }

    private final boolean hasEjbVersion() {
        return !StringHelper.isNullOrEmpty((String)this.ejbVersion);
    }

    private final boolean hasValidEjbVersion() {
        if (this.hasEjbVersion()) {
            if (this.ejbVersion.equals("2.0")) {
                return true;
            }
            if (this.ejbVersion.equals("2.1")) {
                return true;
            }
            if (this.ejbVersion.equals("3.0")) {
                return true;
            }
            if (this.ejbVersion.equals("3.1")) {
                return true;
            }
        }
        return false;
    }
}

